/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCentralizationRuleForOrganizationResponse extends ObservabilityAdminResponse implements
        ToCopyableBuilder<GetCentralizationRuleForOrganizationResponse.Builder, GetCentralizationRuleForOrganizationResponse> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(GetCentralizationRuleForOrganizationResponse::ruleName))
            .setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(GetCentralizationRuleForOrganizationResponse::ruleArn))
            .setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorAccountId").getter(getter(GetCentralizationRuleForOrganizationResponse::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorAccountId").build()).build();

    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreatedTimeStamp").getter(getter(GetCentralizationRuleForOrganizationResponse::createdTimeStamp))
            .setter(setter(Builder::createdTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()).build();

    private static final SdkField<String> CREATED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedRegion").getter(getter(GetCentralizationRuleForOrganizationResponse::createdRegion))
            .setter(setter(Builder::createdRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedRegion").build()).build();

    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastUpdateTimeStamp").getter(getter(GetCentralizationRuleForOrganizationResponse::lastUpdateTimeStamp))
            .setter(setter(Builder::lastUpdateTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build())
            .build();

    private static final SdkField<String> RULE_HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleHealth").getter(getter(GetCentralizationRuleForOrganizationResponse::ruleHealthAsString))
            .setter(setter(Builder::ruleHealth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleHealth").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(GetCentralizationRuleForOrganizationResponse::failureReasonAsString))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<CentralizationRule> CENTRALIZATION_RULE_FIELD = SdkField
            .<CentralizationRule> builder(MarshallingType.SDK_POJO).memberName("CentralizationRule")
            .getter(getter(GetCentralizationRuleForOrganizationResponse::centralizationRule))
            .setter(setter(Builder::centralizationRule)).constructor(CentralizationRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CentralizationRule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            RULE_ARN_FIELD, CREATOR_ACCOUNT_ID_FIELD, CREATED_TIME_STAMP_FIELD, CREATED_REGION_FIELD,
            LAST_UPDATE_TIME_STAMP_FIELD, RULE_HEALTH_FIELD, FAILURE_REASON_FIELD, CENTRALIZATION_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleName;

    private final String ruleArn;

    private final String creatorAccountId;

    private final Long createdTimeStamp;

    private final String createdRegion;

    private final Long lastUpdateTimeStamp;

    private final String ruleHealth;

    private final String failureReason;

    private final CentralizationRule centralizationRule;

    private GetCentralizationRuleForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.ruleArn = builder.ruleArn;
        this.creatorAccountId = builder.creatorAccountId;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.createdRegion = builder.createdRegion;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
        this.ruleHealth = builder.ruleHealth;
        this.failureReason = builder.failureReason;
        this.centralizationRule = builder.centralizationRule;
    }

    /**
     * <p>
     * The name of the organization centralization rule.
     * </p>
     * 
     * @return The name of the organization centralization rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the organization centralization rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the organization centralization rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The Amazon Web Services Account that created the organization centralization rule.
     * </p>
     * 
     * @return The Amazon Web Services Account that created the organization centralization rule.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    /**
     * <p>
     * The timestamp when the organization centralization rule was created.
     * </p>
     * 
     * @return The timestamp when the organization centralization rule was created.
     */
    public final Long createdTimeStamp() {
        return createdTimeStamp;
    }

    /**
     * <p>
     * The Amazon Web Services region where the organization centralization rule was created.
     * </p>
     * 
     * @return The Amazon Web Services region where the organization centralization rule was created.
     */
    public final String createdRegion() {
        return createdRegion;
    }

    /**
     * <p>
     * The timestamp when the organization centralization rule was last updated.
     * </p>
     * 
     * @return The timestamp when the organization centralization rule was last updated.
     */
    public final Long lastUpdateTimeStamp() {
        return lastUpdateTimeStamp;
    }

    /**
     * <p>
     * The health status of the organization centralization rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleHealth} will
     * return {@link RuleHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleHealthAsString}.
     * </p>
     * 
     * @return The health status of the organization centralization rule.
     * @see RuleHealth
     */
    public final RuleHealth ruleHealth() {
        return RuleHealth.fromValue(ruleHealth);
    }

    /**
     * <p>
     * The health status of the organization centralization rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleHealth} will
     * return {@link RuleHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleHealthAsString}.
     * </p>
     * 
     * @return The health status of the organization centralization rule.
     * @see RuleHealth
     */
    public final String ruleHealthAsString() {
        return ruleHealth;
    }

    /**
     * <p>
     * The reason why an organization centralization rule is marked UNHEALTHY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureReason}
     * will return {@link CentralizationFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureReasonAsString}.
     * </p>
     * 
     * @return The reason why an organization centralization rule is marked UNHEALTHY.
     * @see CentralizationFailureReason
     */
    public final CentralizationFailureReason failureReason() {
        return CentralizationFailureReason.fromValue(failureReason);
    }

    /**
     * <p>
     * The reason why an organization centralization rule is marked UNHEALTHY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureReason}
     * will return {@link CentralizationFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureReasonAsString}.
     * </p>
     * 
     * @return The reason why an organization centralization rule is marked UNHEALTHY.
     * @see CentralizationFailureReason
     */
    public final String failureReasonAsString() {
        return failureReason;
    }

    /**
     * <p>
     * The configuration details for the organization centralization rule.
     * </p>
     * 
     * @return The configuration details for the organization centralization rule.
     */
    public final CentralizationRule centralizationRule() {
        return centralizationRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(createdRegion());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(ruleHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(centralizationRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCentralizationRuleForOrganizationResponse)) {
            return false;
        }
        GetCentralizationRuleForOrganizationResponse other = (GetCentralizationRuleForOrganizationResponse) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(ruleArn(), other.ruleArn())
                && Objects.equals(creatorAccountId(), other.creatorAccountId())
                && Objects.equals(createdTimeStamp(), other.createdTimeStamp())
                && Objects.equals(createdRegion(), other.createdRegion())
                && Objects.equals(lastUpdateTimeStamp(), other.lastUpdateTimeStamp())
                && Objects.equals(ruleHealthAsString(), other.ruleHealthAsString())
                && Objects.equals(failureReasonAsString(), other.failureReasonAsString())
                && Objects.equals(centralizationRule(), other.centralizationRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCentralizationRuleForOrganizationResponse").add("RuleName", ruleName())
                .add("RuleArn", ruleArn()).add("CreatorAccountId", creatorAccountId())
                .add("CreatedTimeStamp", createdTimeStamp()).add("CreatedRegion", createdRegion())
                .add("LastUpdateTimeStamp", lastUpdateTimeStamp()).add("RuleHealth", ruleHealthAsString())
                .add("FailureReason", failureReasonAsString()).add("CentralizationRule", centralizationRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "CreatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        case "CreatedTimeStamp":
            return Optional.ofNullable(clazz.cast(createdTimeStamp()));
        case "CreatedRegion":
            return Optional.ofNullable(clazz.cast(createdRegion()));
        case "LastUpdateTimeStamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimeStamp()));
        case "RuleHealth":
            return Optional.ofNullable(clazz.cast(ruleHealthAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReasonAsString()));
        case "CentralizationRule":
            return Optional.ofNullable(clazz.cast(centralizationRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("CreatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        map.put("CreatedRegion", CREATED_REGION_FIELD);
        map.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        map.put("RuleHealth", RULE_HEALTH_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("CentralizationRule", CENTRALIZATION_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCentralizationRuleForOrganizationResponse, T> g) {
        return obj -> g.apply((GetCentralizationRuleForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCentralizationRuleForOrganizationResponse> {
        /**
         * <p>
         * The name of the organization centralization rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the organization centralization rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the organization centralization rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the organization centralization rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The Amazon Web Services Account that created the organization centralization rule.
         * </p>
         * 
         * @param creatorAccountId
         *        The Amazon Web Services Account that created the organization centralization rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);

        /**
         * <p>
         * The timestamp when the organization centralization rule was created.
         * </p>
         * 
         * @param createdTimeStamp
         *        The timestamp when the organization centralization rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimeStamp(Long createdTimeStamp);

        /**
         * <p>
         * The Amazon Web Services region where the organization centralization rule was created.
         * </p>
         * 
         * @param createdRegion
         *        The Amazon Web Services region where the organization centralization rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRegion(String createdRegion);

        /**
         * <p>
         * The timestamp when the organization centralization rule was last updated.
         * </p>
         * 
         * @param lastUpdateTimeStamp
         *        The timestamp when the organization centralization rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp);

        /**
         * <p>
         * The health status of the organization centralization rule.
         * </p>
         * 
         * @param ruleHealth
         *        The health status of the organization centralization rule.
         * @see RuleHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleHealth
         */
        Builder ruleHealth(String ruleHealth);

        /**
         * <p>
         * The health status of the organization centralization rule.
         * </p>
         * 
         * @param ruleHealth
         *        The health status of the organization centralization rule.
         * @see RuleHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleHealth
         */
        Builder ruleHealth(RuleHealth ruleHealth);

        /**
         * <p>
         * The reason why an organization centralization rule is marked UNHEALTHY.
         * </p>
         * 
         * @param failureReason
         *        The reason why an organization centralization rule is marked UNHEALTHY.
         * @see CentralizationFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CentralizationFailureReason
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The reason why an organization centralization rule is marked UNHEALTHY.
         * </p>
         * 
         * @param failureReason
         *        The reason why an organization centralization rule is marked UNHEALTHY.
         * @see CentralizationFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CentralizationFailureReason
         */
        Builder failureReason(CentralizationFailureReason failureReason);

        /**
         * <p>
         * The configuration details for the organization centralization rule.
         * </p>
         * 
         * @param centralizationRule
         *        The configuration details for the organization centralization rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder centralizationRule(CentralizationRule centralizationRule);

        /**
         * <p>
         * The configuration details for the organization centralization rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link CentralizationRule.Builder} avoiding the
         * need to create one manually via {@link CentralizationRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CentralizationRule.Builder#build()} is called immediately and its
         * result is passed to {@link #centralizationRule(CentralizationRule)}.
         * 
         * @param centralizationRule
         *        a consumer that will call methods on {@link CentralizationRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #centralizationRule(CentralizationRule)
         */
        default Builder centralizationRule(Consumer<CentralizationRule.Builder> centralizationRule) {
            return centralizationRule(CentralizationRule.builder().applyMutation(centralizationRule).build());
        }
    }

    static final class BuilderImpl extends ObservabilityAdminResponse.BuilderImpl implements Builder {
        private String ruleName;

        private String ruleArn;

        private String creatorAccountId;

        private Long createdTimeStamp;

        private String createdRegion;

        private Long lastUpdateTimeStamp;

        private String ruleHealth;

        private String failureReason;

        private CentralizationRule centralizationRule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCentralizationRuleForOrganizationResponse model) {
            super(model);
            ruleName(model.ruleName);
            ruleArn(model.ruleArn);
            creatorAccountId(model.creatorAccountId);
            createdTimeStamp(model.createdTimeStamp);
            createdRegion(model.createdRegion);
            lastUpdateTimeStamp(model.lastUpdateTimeStamp);
            ruleHealth(model.ruleHealth);
            failureReason(model.failureReason);
            centralizationRule(model.centralizationRule);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final Long getCreatedTimeStamp() {
            return createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final String getCreatedRegion() {
            return createdRegion;
        }

        public final void setCreatedRegion(String createdRegion) {
            this.createdRegion = createdRegion;
        }

        @Override
        public final Builder createdRegion(String createdRegion) {
            this.createdRegion = createdRegion;
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public final String getRuleHealth() {
            return ruleHealth;
        }

        public final void setRuleHealth(String ruleHealth) {
            this.ruleHealth = ruleHealth;
        }

        @Override
        public final Builder ruleHealth(String ruleHealth) {
            this.ruleHealth = ruleHealth;
            return this;
        }

        @Override
        public final Builder ruleHealth(RuleHealth ruleHealth) {
            this.ruleHealth(ruleHealth == null ? null : ruleHealth.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(CentralizationFailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public final CentralizationRule.Builder getCentralizationRule() {
            return centralizationRule != null ? centralizationRule.toBuilder() : null;
        }

        public final void setCentralizationRule(CentralizationRule.BuilderImpl centralizationRule) {
            this.centralizationRule = centralizationRule != null ? centralizationRule.build() : null;
        }

        @Override
        public final Builder centralizationRule(CentralizationRule centralizationRule) {
            this.centralizationRule = centralizationRule;
            return this;
        }

        @Override
        public GetCentralizationRuleForOrganizationResponse build() {
            return new GetCentralizationRuleForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
