/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of pipeline configuration components including sources, processors, and destinations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationSummary.Builder, ConfigurationSummary> {
    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField
            .<List<Source>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(ConfigurationSummary::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Source> builder(MarshallingType.SDK_POJO)
                                            .constructor(Source::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField
            .<List<DataSource>> builder(MarshallingType.LIST)
            .memberName("DataSources")
            .getter(getter(ConfigurationSummary::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROCESSORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Processors")
            .getter(getter(ConfigurationSummary::processors))
            .setter(setter(Builder::processors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PROCESSOR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProcessorCount").getter(getter(ConfigurationSummary::processorCount))
            .setter(setter(Builder::processorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorCount").build()).build();

    private static final SdkField<List<String>> SINKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Sinks")
            .getter(getter(ConfigurationSummary::sinks))
            .setter(setter(Builder::sinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD,
            DATA_SOURCES_FIELD, PROCESSORS_FIELD, PROCESSOR_COUNT_FIELD, SINKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Source> sources;

    private final List<DataSource> dataSources;

    private final List<String> processors;

    private final Integer processorCount;

    private final List<String> sinks;

    private ConfigurationSummary(BuilderImpl builder) {
        this.sources = builder.sources;
        this.dataSources = builder.dataSources;
        this.processors = builder.processors;
        this.processorCount = builder.processorCount;
        this.sinks = builder.sinks;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of data sources configured in the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The list of data sources configured in the pipeline.
     */
    public final List<Source> sources() {
        return sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of data sources that provide telemetry data to the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return The list of data sources that provide telemetry data to the pipeline.
     */
    public final List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Processors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProcessors() {
        return processors != null && !(processors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of processors configured in the pipeline for data transformation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessors} method.
     * </p>
     * 
     * @return The list of processors configured in the pipeline for data transformation.
     */
    public final List<String> processors() {
        return processors;
    }

    /**
     * <p>
     * The total number of processors configured in the pipeline.
     * </p>
     * 
     * @return The total number of processors configured in the pipeline.
     */
    public final Integer processorCount() {
        return processorCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sinks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSinks() {
        return sinks != null && !(sinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of destinations where processed data is sent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSinks} method.
     * </p>
     * 
     * @return The list of destinations where processed data is sent.
     */
    public final List<String> sinks() {
        return sinks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessors() ? processors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(processorCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasSinks() ? sinks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationSummary)) {
            return false;
        }
        ConfigurationSummary other = (ConfigurationSummary) obj;
        return hasSources() == other.hasSources() && Objects.equals(sources(), other.sources())
                && hasDataSources() == other.hasDataSources() && Objects.equals(dataSources(), other.dataSources())
                && hasProcessors() == other.hasProcessors() && Objects.equals(processors(), other.processors())
                && Objects.equals(processorCount(), other.processorCount()) && hasSinks() == other.hasSinks()
                && Objects.equals(sinks(), other.sinks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationSummary").add("Sources", hasSources() ? sources() : null)
                .add("DataSources", hasDataSources() ? dataSources() : null)
                .add("Processors", hasProcessors() ? processors() : null).add("ProcessorCount", processorCount())
                .add("Sinks", hasSinks() ? sinks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Processors":
            return Optional.ofNullable(clazz.cast(processors()));
        case "ProcessorCount":
            return Optional.ofNullable(clazz.cast(processorCount()));
        case "Sinks":
            return Optional.ofNullable(clazz.cast(sinks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Sources", SOURCES_FIELD);
        map.put("DataSources", DATA_SOURCES_FIELD);
        map.put("Processors", PROCESSORS_FIELD);
        map.put("ProcessorCount", PROCESSOR_COUNT_FIELD);
        map.put("Sinks", SINKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationSummary, T> g) {
        return obj -> g.apply((ConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationSummary> {
        /**
         * <p>
         * The list of data sources configured in the pipeline.
         * </p>
         * 
         * @param sources
         *        The list of data sources configured in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<Source> sources);

        /**
         * <p>
         * The list of data sources configured in the pipeline.
         * </p>
         * 
         * @param sources
         *        The list of data sources configured in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Source... sources);

        /**
         * <p>
         * The list of data sources configured in the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.observabilityadmin.model.Source.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.observabilityadmin.model.Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.observabilityadmin.model.Source.Builder#build()} is called immediately
         * and its result is passed to {@link #sources(List<Source>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.observabilityadmin.model.Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<Source>)
         */
        Builder sources(Consumer<Source.Builder>... sources);

        /**
         * <p>
         * The list of data sources that provide telemetry data to the pipeline.
         * </p>
         * 
         * @param dataSources
         *        The list of data sources that provide telemetry data to the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * The list of data sources that provide telemetry data to the pipeline.
         * </p>
         * 
         * @param dataSources
         *        The list of data sources that provide telemetry data to the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * The list of data sources that provide telemetry data to the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.observabilityadmin.model.DataSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.observabilityadmin.model.DataSource#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.observabilityadmin.model.DataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSources(List<DataSource>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.observabilityadmin.model.DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(java.util.Collection<DataSource>)
         */
        Builder dataSources(Consumer<DataSource.Builder>... dataSources);

        /**
         * <p>
         * The list of processors configured in the pipeline for data transformation.
         * </p>
         * 
         * @param processors
         *        The list of processors configured in the pipeline for data transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Collection<String> processors);

        /**
         * <p>
         * The list of processors configured in the pipeline for data transformation.
         * </p>
         * 
         * @param processors
         *        The list of processors configured in the pipeline for data transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(String... processors);

        /**
         * <p>
         * The total number of processors configured in the pipeline.
         * </p>
         * 
         * @param processorCount
         *        The total number of processors configured in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorCount(Integer processorCount);

        /**
         * <p>
         * The list of destinations where processed data is sent.
         * </p>
         * 
         * @param sinks
         *        The list of destinations where processed data is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(Collection<String> sinks);

        /**
         * <p>
         * The list of destinations where processed data is sent.
         * </p>
         * 
         * @param sinks
         *        The list of destinations where processed data is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(String... sinks);
    }

    static final class BuilderImpl implements Builder {
        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();

        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();

        private List<String> processors = DefaultSdkAutoConstructList.getInstance();

        private Integer processorCount;

        private List<String> sinks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationSummary model) {
            sources(model.sources);
            dataSources(model.dataSources);
            processors(model.processors);
            processorCount(model.processorCount);
            sinks(model.sinks);
        }

        public final List<Source.Builder> getSources() {
            List<Source.Builder> result = SourcesCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = SourcesCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<Source> sources) {
            this.sources = SourcesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Source... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder>... sources) {
            sources(Stream.of(sources).map(c -> Source.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSource.Builder> getDataSources() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder>... dataSources) {
            dataSources(Stream.of(dataSources).map(c -> DataSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getProcessors() {
            if (processors instanceof SdkAutoConstructList) {
                return null;
            }
            return processors;
        }

        public final void setProcessors(Collection<String> processors) {
            this.processors = ProcessorsCopier.copy(processors);
        }

        @Override
        public final Builder processors(Collection<String> processors) {
            this.processors = ProcessorsCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(String... processors) {
            processors(Arrays.asList(processors));
            return this;
        }

        public final Integer getProcessorCount() {
            return processorCount;
        }

        public final void setProcessorCount(Integer processorCount) {
            this.processorCount = processorCount;
        }

        @Override
        public final Builder processorCount(Integer processorCount) {
            this.processorCount = processorCount;
            return this;
        }

        public final Collection<String> getSinks() {
            if (sinks instanceof SdkAutoConstructList) {
                return null;
            }
            return sinks;
        }

        public final void setSinks(Collection<String> sinks) {
            this.sinks = SinksCopier.copy(sinks);
        }

        @Override
        public final Builder sinks(Collection<String> sinks) {
            this.sinks = SinksCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(String... sinks) {
            sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        public ConfigurationSummary build() {
            return new ConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
