/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.observabilityadmin.model.AccessDeniedException;
import software.amazon.awssdk.services.observabilityadmin.model.ConflictException;
import software.amazon.awssdk.services.observabilityadmin.model.CreateCentralizationRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateCentralizationRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.CreateS3TableIntegrationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateS3TableIntegrationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleRequest;
import software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteCentralizationRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteCentralizationRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteS3TableIntegrationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteS3TableIntegrationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleRequest;
import software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetCentralizationRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetCentralizationRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetS3TableIntegrationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetS3TableIntegrationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEnrichmentStatusRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEnrichmentStatusResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleRequest;
import software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleResponse;
import software.amazon.awssdk.services.observabilityadmin.model.InternalServerException;
import software.amazon.awssdk.services.observabilityadmin.model.InvalidStateException;
import software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminException;
import software.amazon.awssdk.services.observabilityadmin.model.ResourceNotFoundException;
import software.amazon.awssdk.services.observabilityadmin.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEnrichmentRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEnrichmentResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEnrichmentRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEnrichmentResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TagResourceRequest;
import software.amazon.awssdk.services.observabilityadmin.model.TagResourceResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TestTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.TestTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TooManyRequestsException;
import software.amazon.awssdk.services.observabilityadmin.model.UntagResourceRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UntagResourceResponse;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateCentralizationRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateCentralizationRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryPipelineRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryPipelineResponse;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleRequest;
import software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ValidateTelemetryPipelineConfigurationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ValidateTelemetryPipelineConfigurationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.ValidationException;
import software.amazon.awssdk.services.observabilityadmin.paginators.ListCentralizationRulesForOrganizationIterable;
import software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryForOrganizationIterable;
import software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryIterable;
import software.amazon.awssdk.services.observabilityadmin.paginators.ListS3TableIntegrationsIterable;
import software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryPipelinesIterable;
import software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesForOrganizationIterable;
import software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesIterable;

/**
 * Service client for accessing CloudWatch Observability Admin Service. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * You can use Amazon CloudWatch Observability Admin to discover and understand the state of telemetry configuration in
 * CloudWatch for your Amazon Web Services Organization or account. This simplifies the process of auditing your
 * telemetry collection configurations across multiple resource types within your Amazon Web Services Organization or
 * account. By providing a consolidated view, it allows you to easily review and manage telemetry settings, helping you
 * ensure proper monitoring and data collection across your Amazon Web Services environment. For more information, see
 * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/telemetry-config-cloudwatch.html">Auditing
 * CloudWatch telemetry conﬁgurations</a> in the CloudWatch User Guide.
 * </p>
 * <p>
 * For information on the permissions you need to use this API, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html">Identity and
 * access management for Amazon CloudWatch</a> in the CloudWatch User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ObservabilityAdminClient extends AwsClient {
    String SERVICE_NAME = "observabilityadmin";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "observabilityadmin";

    /**
     * <p>
     * Creates a centralization rule that applies across an Amazon Web Services Organization. This operation can only be
     * called by the organization's management account or a delegated administrator account.
     * </p>
     *
     * @param createCentralizationRuleForOrganizationRequest
     * @return Result of the CreateCentralizationRuleForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCentralizationRuleForOrganizationResponse createCentralizationRuleForOrganization(
            CreateCentralizationRuleForOrganizationRequest createCentralizationRuleForOrganizationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a centralization rule that applies across an Amazon Web Services Organization. This operation can only be
     * called by the organization's management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCentralizationRuleForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCentralizationRuleForOrganizationRequest#builder()}
     * </p>
     *
     * @param createCentralizationRuleForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.CreateCentralizationRuleForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCentralizationRuleForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCentralizationRuleForOrganizationResponse createCentralizationRuleForOrganization(
            Consumer<CreateCentralizationRuleForOrganizationRequest.Builder> createCentralizationRuleForOrganizationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return createCentralizationRuleForOrganization(CreateCentralizationRuleForOrganizationRequest.builder()
                .applyMutation(createCentralizationRuleForOrganizationRequest).build());
    }

    /**
     * <p>
     * Creates an integration between CloudWatch and S3 Tables for analytics. This integration enables querying
     * CloudWatch telemetry data using analytics engines like Amazon Athena, Amazon Redshift, and Apache Spark.
     * </p>
     *
     * @param createS3TableIntegrationRequest
     * @return Result of the CreateS3TableIntegration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateS3TableIntegrationResponse createS3TableIntegration(
            CreateS3TableIntegrationRequest createS3TableIntegrationRequest) throws ServiceQuotaExceededException,
            ConflictException, AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an integration between CloudWatch and S3 Tables for analytics. This integration enables querying
     * CloudWatch telemetry data using analytics engines like Amazon Athena, Amazon Redshift, and Apache Spark.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateS3TableIntegrationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateS3TableIntegrationRequest#builder()}
     * </p>
     *
     * @param createS3TableIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.CreateS3TableIntegrationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateS3TableIntegration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateS3TableIntegrationResponse createS3TableIntegration(
            Consumer<CreateS3TableIntegrationRequest.Builder> createS3TableIntegrationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return createS3TableIntegration(CreateS3TableIntegrationRequest.builder().applyMutation(createS3TableIntegrationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a telemetry pipeline for processing and transforming telemetry data. The pipeline defines how data flows
     * from sources through processors to destinations, enabling data transformation and delivering capabilities.
     * </p>
     *
     * @param createTelemetryPipelineRequest
     * @return Result of the CreateTelemetryPipeline operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTelemetryPipelineResponse createTelemetryPipeline(CreateTelemetryPipelineRequest createTelemetryPipelineRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a telemetry pipeline for processing and transforming telemetry data. The pipeline defines how data flows
     * from sources through processors to destinations, enabling data transformation and delivering capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTelemetryPipelineRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTelemetryPipelineRequest#builder()}
     * </p>
     *
     * @param createTelemetryPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryPipelineRequest.Builder} to
     *        create a request.
     * @return Result of the CreateTelemetryPipeline operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTelemetryPipelineResponse createTelemetryPipeline(
            Consumer<CreateTelemetryPipelineRequest.Builder> createTelemetryPipelineRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return createTelemetryPipeline(CreateTelemetryPipelineRequest.builder().applyMutation(createTelemetryPipelineRequest)
                .build());
    }

    /**
     * <p>
     * Creates a telemetry rule that defines how telemetry should be configured for Amazon Web Services resources in
     * your account. The rule specifies which resources should have telemetry enabled and how that telemetry data should
     * be collected based on resource type, telemetry type, and selection criteria.
     * </p>
     *
     * @param createTelemetryRuleRequest
     * @return Result of the CreateTelemetryRule operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTelemetryRuleResponse createTelemetryRule(CreateTelemetryRuleRequest createTelemetryRuleRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a telemetry rule that defines how telemetry should be configured for Amazon Web Services resources in
     * your account. The rule specifies which resources should have telemetry enabled and how that telemetry data should
     * be collected based on resource type, telemetry type, and selection criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTelemetryRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTelemetryRuleRequest#builder()}
     * </p>
     *
     * @param createTelemetryRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleRequest.Builder} to
     *        create a request.
     * @return Result of the CreateTelemetryRule operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTelemetryRuleResponse createTelemetryRule(
            Consumer<CreateTelemetryRuleRequest.Builder> createTelemetryRuleRequest) throws ServiceQuotaExceededException,
            ConflictException, AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return createTelemetryRule(CreateTelemetryRuleRequest.builder().applyMutation(createTelemetryRuleRequest).build());
    }

    /**
     * <p>
     * Creates a telemetry rule that applies across an Amazon Web Services Organization. This operation can only be
     * called by the organization's management account or a delegated administrator account.
     * </p>
     *
     * @param createTelemetryRuleForOrganizationRequest
     * @return Result of the CreateTelemetryRuleForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTelemetryRuleForOrganizationResponse createTelemetryRuleForOrganization(
            CreateTelemetryRuleForOrganizationRequest createTelemetryRuleForOrganizationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a telemetry rule that applies across an Amazon Web Services Organization. This operation can only be
     * called by the organization's management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTelemetryRuleForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTelemetryRuleForOrganizationRequest#builder()}
     * </p>
     *
     * @param createTelemetryRuleForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.CreateTelemetryRuleForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateTelemetryRuleForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.CreateTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/CreateTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTelemetryRuleForOrganizationResponse createTelemetryRuleForOrganization(
            Consumer<CreateTelemetryRuleForOrganizationRequest.Builder> createTelemetryRuleForOrganizationRequest)
            throws ServiceQuotaExceededException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return createTelemetryRuleForOrganization(CreateTelemetryRuleForOrganizationRequest.builder()
                .applyMutation(createTelemetryRuleForOrganizationRequest).build());
    }

    /**
     * <p>
     * Deletes an organization-wide centralization rule. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     *
     * @param deleteCentralizationRuleForOrganizationRequest
     * @return Result of the DeleteCentralizationRuleForOrganization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCentralizationRuleForOrganizationResponse deleteCentralizationRuleForOrganization(
            DeleteCentralizationRuleForOrganizationRequest deleteCentralizationRuleForOrganizationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an organization-wide centralization rule. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteCentralizationRuleForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteCentralizationRuleForOrganizationRequest#builder()}
     * </p>
     *
     * @param deleteCentralizationRuleForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.DeleteCentralizationRuleForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteCentralizationRuleForOrganization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCentralizationRuleForOrganizationResponse deleteCentralizationRuleForOrganization(
            Consumer<DeleteCentralizationRuleForOrganizationRequest.Builder> deleteCentralizationRuleForOrganizationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return deleteCentralizationRuleForOrganization(DeleteCentralizationRuleForOrganizationRequest.builder()
                .applyMutation(deleteCentralizationRuleForOrganizationRequest).build());
    }

    /**
     * <p>
     * Deletes an S3 Table integration and its associated data. This operation removes the connection between CloudWatch
     * Observability Admin and S3 Tables.
     * </p>
     *
     * @param deleteS3TableIntegrationRequest
     * @return Result of the DeleteS3TableIntegration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws InvalidStateException
     *         The requested operation cannot be completed on the specified resource in the current state.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteS3TableIntegrationResponse deleteS3TableIntegration(
            DeleteS3TableIntegrationRequest deleteS3TableIntegrationRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, InternalServerException, InvalidStateException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an S3 Table integration and its associated data. This operation removes the connection between CloudWatch
     * Observability Admin and S3 Tables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteS3TableIntegrationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteS3TableIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteS3TableIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.DeleteS3TableIntegrationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteS3TableIntegration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws InvalidStateException
     *         The requested operation cannot be completed on the specified resource in the current state.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteS3TableIntegrationResponse deleteS3TableIntegration(
            Consumer<DeleteS3TableIntegrationRequest.Builder> deleteS3TableIntegrationRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, InternalServerException, InvalidStateException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return deleteS3TableIntegration(DeleteS3TableIntegrationRequest.builder().applyMutation(deleteS3TableIntegrationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a telemetry pipeline and its associated resources. This operation stops data processing and removes the
     * pipeline configuration.
     * </p>
     *
     * @param deleteTelemetryPipelineRequest
     * @return Result of the DeleteTelemetryPipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTelemetryPipelineResponse deleteTelemetryPipeline(DeleteTelemetryPipelineRequest deleteTelemetryPipelineRequest)
            throws ResourceNotFoundException, ConflictException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a telemetry pipeline and its associated resources. This operation stops data processing and removes the
     * pipeline configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTelemetryPipelineRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTelemetryPipelineRequest#builder()}
     * </p>
     *
     * @param deleteTelemetryPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryPipelineRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTelemetryPipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTelemetryPipelineResponse deleteTelemetryPipeline(
            Consumer<DeleteTelemetryPipelineRequest.Builder> deleteTelemetryPipelineRequest) throws ResourceNotFoundException,
            ConflictException, AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return deleteTelemetryPipeline(DeleteTelemetryPipelineRequest.builder().applyMutation(deleteTelemetryPipelineRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a telemetry rule from your account. Any telemetry configurations previously created by the rule will
     * remain but no new resources will be configured by this rule.
     * </p>
     *
     * @param deleteTelemetryRuleRequest
     * @return Result of the DeleteTelemetryRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTelemetryRuleResponse deleteTelemetryRule(DeleteTelemetryRuleRequest deleteTelemetryRuleRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a telemetry rule from your account. Any telemetry configurations previously created by the rule will
     * remain but no new resources will be configured by this rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTelemetryRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTelemetryRuleRequest#builder()}
     * </p>
     *
     * @param deleteTelemetryRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTelemetryRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTelemetryRuleResponse deleteTelemetryRule(
            Consumer<DeleteTelemetryRuleRequest.Builder> deleteTelemetryRuleRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ObservabilityAdminException {
        return deleteTelemetryRule(DeleteTelemetryRuleRequest.builder().applyMutation(deleteTelemetryRuleRequest).build());
    }

    /**
     * <p>
     * Deletes an organization-wide telemetry rule. This operation can only be called by the organization's management
     * account or a delegated administrator account.
     * </p>
     *
     * @param deleteTelemetryRuleForOrganizationRequest
     * @return Result of the DeleteTelemetryRuleForOrganization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTelemetryRuleForOrganizationResponse deleteTelemetryRuleForOrganization(
            DeleteTelemetryRuleForOrganizationRequest deleteTelemetryRuleForOrganizationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an organization-wide telemetry rule. This operation can only be called by the organization's management
     * account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTelemetryRuleForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTelemetryRuleForOrganizationRequest#builder()}
     * </p>
     *
     * @param deleteTelemetryRuleForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.DeleteTelemetryRuleForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteTelemetryRuleForOrganization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.DeleteTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/DeleteTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTelemetryRuleForOrganizationResponse deleteTelemetryRuleForOrganization(
            Consumer<DeleteTelemetryRuleForOrganizationRequest.Builder> deleteTelemetryRuleForOrganizationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return deleteTelemetryRuleForOrganization(DeleteTelemetryRuleForOrganizationRequest.builder()
                .applyMutation(deleteTelemetryRuleForOrganizationRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a specific organization centralization rule. This operation can only be called by the
     * organization's management account or a delegated administrator account.
     * </p>
     *
     * @param getCentralizationRuleForOrganizationRequest
     * @return Result of the GetCentralizationRuleForOrganization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCentralizationRuleForOrganizationResponse getCentralizationRuleForOrganization(
            GetCentralizationRuleForOrganizationRequest getCentralizationRuleForOrganizationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a specific organization centralization rule. This operation can only be called by the
     * organization's management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetCentralizationRuleForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link GetCentralizationRuleForOrganizationRequest#builder()}
     * </p>
     *
     * @param getCentralizationRuleForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.GetCentralizationRuleForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the GetCentralizationRuleForOrganization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCentralizationRuleForOrganizationResponse getCentralizationRuleForOrganization(
            Consumer<GetCentralizationRuleForOrganizationRequest.Builder> getCentralizationRuleForOrganizationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return getCentralizationRuleForOrganization(GetCentralizationRuleForOrganizationRequest.builder()
                .applyMutation(getCentralizationRuleForOrganizationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific S3 Table integration, including its configuration, status, and metadata.
     * </p>
     *
     * @param getS3TableIntegrationRequest
     * @return Result of the GetS3TableIntegration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetS3TableIntegrationResponse getS3TableIntegration(GetS3TableIntegrationRequest getS3TableIntegrationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific S3 Table integration, including its configuration, status, and metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetS3TableIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link GetS3TableIntegrationRequest#builder()}
     * </p>
     *
     * @param getS3TableIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.GetS3TableIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the GetS3TableIntegration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetS3TableIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetS3TableIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetS3TableIntegrationResponse getS3TableIntegration(
            Consumer<GetS3TableIntegrationRequest.Builder> getS3TableIntegrationRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ObservabilityAdminException {
        return getS3TableIntegration(GetS3TableIntegrationRequest.builder().applyMutation(getS3TableIntegrationRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the resource tags for telemetry feature, which enhances telemetry data with
     * additional resource metadata from Resource Explorer.
     * </p>
     *
     * @param getTelemetryEnrichmentStatusRequest
     * @return Result of the GetTelemetryEnrichmentStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryEnrichmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEnrichmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryEnrichmentStatusResponse getTelemetryEnrichmentStatus(
            GetTelemetryEnrichmentStatusRequest getTelemetryEnrichmentStatusRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of the resource tags for telemetry feature, which enhances telemetry data with
     * additional resource metadata from Resource Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTelemetryEnrichmentStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetTelemetryEnrichmentStatusRequest#builder()}
     * </p>
     *
     * @param getTelemetryEnrichmentStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEnrichmentStatusRequest.Builder}
     *        to create a request.
     * @return Result of the GetTelemetryEnrichmentStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryEnrichmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEnrichmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryEnrichmentStatusResponse getTelemetryEnrichmentStatus(
            Consumer<GetTelemetryEnrichmentStatusRequest.Builder> getTelemetryEnrichmentStatusRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return getTelemetryEnrichmentStatus(GetTelemetryEnrichmentStatusRequest.builder()
                .applyMutation(getTelemetryEnrichmentStatusRequest).build());
    }

    /**
     * <p>
     * Returns the current onboarding status of the telemetry config feature, including the status of the feature and
     * reason the feature failed to start or stop.
     * </p>
     *
     * @param getTelemetryEvaluationStatusRequest
     * @return Result of the GetTelemetryEvaluationStatus operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryEvaluationStatusResponse getTelemetryEvaluationStatus(
            GetTelemetryEvaluationStatusRequest getTelemetryEvaluationStatusRequest) throws AccessDeniedException,
            InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current onboarding status of the telemetry config feature, including the status of the feature and
     * reason the feature failed to start or stop.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTelemetryEvaluationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetTelemetryEvaluationStatusRequest#builder()}
     * </p>
     *
     * @param getTelemetryEvaluationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusRequest.Builder}
     *        to create a request.
     * @return Result of the GetTelemetryEvaluationStatus operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryEvaluationStatusResponse getTelemetryEvaluationStatus(
            Consumer<GetTelemetryEvaluationStatusRequest.Builder> getTelemetryEvaluationStatusRequest)
            throws AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ObservabilityAdminException {
        return getTelemetryEvaluationStatus(GetTelemetryEvaluationStatusRequest.builder()
                .applyMutation(getTelemetryEvaluationStatusRequest).build());
    }

    /**
     * <p>
     * This returns the onboarding status of the telemetry configuration feature for the organization. It can only be
     * called by a Management Account of an Amazon Web Services Organization or an assigned Delegated Admin Account of
     * Amazon CloudWatch telemetry config.
     * </p>
     *
     * @param getTelemetryEvaluationStatusForOrganizationRequest
     * @return Result of the GetTelemetryEvaluationStatusForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryEvaluationStatusForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEvaluationStatusForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryEvaluationStatusForOrganizationResponse getTelemetryEvaluationStatusForOrganization(
            GetTelemetryEvaluationStatusForOrganizationRequest getTelemetryEvaluationStatusForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This returns the onboarding status of the telemetry configuration feature for the organization. It can only be
     * called by a Management Account of an Amazon Web Services Organization or an assigned Delegated Admin Account of
     * Amazon CloudWatch telemetry config.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTelemetryEvaluationStatusForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link GetTelemetryEvaluationStatusForOrganizationRequest#builder()}
     * </p>
     *
     * @param getTelemetryEvaluationStatusForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryEvaluationStatusForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the GetTelemetryEvaluationStatusForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryEvaluationStatusForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryEvaluationStatusForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryEvaluationStatusForOrganizationResponse getTelemetryEvaluationStatusForOrganization(
            Consumer<GetTelemetryEvaluationStatusForOrganizationRequest.Builder> getTelemetryEvaluationStatusForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return getTelemetryEvaluationStatusForOrganization(GetTelemetryEvaluationStatusForOrganizationRequest.builder()
                .applyMutation(getTelemetryEvaluationStatusForOrganizationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific telemetry pipeline, including its configuration, status, and metadata.
     * </p>
     *
     * @param getTelemetryPipelineRequest
     * @return Result of the GetTelemetryPipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryPipelineResponse getTelemetryPipeline(GetTelemetryPipelineRequest getTelemetryPipelineRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific telemetry pipeline, including its configuration, status, and metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTelemetryPipelineRequest.Builder} avoiding the
     * need to create one manually via {@link GetTelemetryPipelineRequest#builder()}
     * </p>
     *
     * @param getTelemetryPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryPipelineRequest.Builder} to
     *        create a request.
     * @return Result of the GetTelemetryPipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryPipelineResponse getTelemetryPipeline(
            Consumer<GetTelemetryPipelineRequest.Builder> getTelemetryPipelineRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ObservabilityAdminException {
        return getTelemetryPipeline(GetTelemetryPipelineRequest.builder().applyMutation(getTelemetryPipelineRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a specific telemetry rule in your account.
     * </p>
     *
     * @param getTelemetryRuleRequest
     * @return Result of the GetTelemetryRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryRuleResponse getTelemetryRule(GetTelemetryRuleRequest getTelemetryRuleRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a specific telemetry rule in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTelemetryRuleRequest.Builder} avoiding the need
     * to create one manually via {@link GetTelemetryRuleRequest#builder()}
     * </p>
     *
     * @param getTelemetryRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleRequest.Builder} to create
     *        a request.
     * @return Result of the GetTelemetryRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryRuleResponse getTelemetryRule(Consumer<GetTelemetryRuleRequest.Builder> getTelemetryRuleRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return getTelemetryRule(GetTelemetryRuleRequest.builder().applyMutation(getTelemetryRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a specific organization telemetry rule. This operation can only be called by the
     * organization's management account or a delegated administrator account.
     * </p>
     *
     * @param getTelemetryRuleForOrganizationRequest
     * @return Result of the GetTelemetryRuleForOrganization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryRuleForOrganizationResponse getTelemetryRuleForOrganization(
            GetTelemetryRuleForOrganizationRequest getTelemetryRuleForOrganizationRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a specific organization telemetry rule. This operation can only be called by the
     * organization's management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTelemetryRuleForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link GetTelemetryRuleForOrganizationRequest#builder()}
     * </p>
     *
     * @param getTelemetryRuleForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.GetTelemetryRuleForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the GetTelemetryRuleForOrganization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.GetTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/GetTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTelemetryRuleForOrganizationResponse getTelemetryRuleForOrganization(
            Consumer<GetTelemetryRuleForOrganizationRequest.Builder> getTelemetryRuleForOrganizationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return getTelemetryRuleForOrganization(GetTelemetryRuleForOrganizationRequest.builder()
                .applyMutation(getTelemetryRuleForOrganizationRequest).build());
    }

    /**
     * <p>
     * Lists all centralization rules in your organization. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     *
     * @param listCentralizationRulesForOrganizationRequest
     * @return Result of the ListCentralizationRulesForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListCentralizationRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListCentralizationRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCentralizationRulesForOrganizationResponse listCentralizationRulesForOrganization(
            ListCentralizationRulesForOrganizationRequest listCentralizationRulesForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all centralization rules in your organization. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCentralizationRulesForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link ListCentralizationRulesForOrganizationRequest#builder()}
     * </p>
     *
     * @param listCentralizationRulesForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the ListCentralizationRulesForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListCentralizationRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListCentralizationRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCentralizationRulesForOrganizationResponse listCentralizationRulesForOrganization(
            Consumer<ListCentralizationRulesForOrganizationRequest.Builder> listCentralizationRulesForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return listCentralizationRulesForOrganization(ListCentralizationRulesForOrganizationRequest.builder()
                .applyMutation(listCentralizationRulesForOrganizationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCentralizationRulesForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListCentralizationRulesForOrganizationIterable responses = client.listCentralizationRulesForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListCentralizationRulesForOrganizationIterable responses = client
     *             .listCentralizationRulesForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListCentralizationRulesForOrganizationIterable responses = client.listCentralizationRulesForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCentralizationRulesForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCentralizationRulesForOrganizationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListCentralizationRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListCentralizationRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCentralizationRulesForOrganizationIterable listCentralizationRulesForOrganizationPaginator(
            ListCentralizationRulesForOrganizationRequest listCentralizationRulesForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return new ListCentralizationRulesForOrganizationIterable(this, listCentralizationRulesForOrganizationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCentralizationRulesForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListCentralizationRulesForOrganizationIterable responses = client.listCentralizationRulesForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListCentralizationRulesForOrganizationIterable responses = client
     *             .listCentralizationRulesForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListCentralizationRulesForOrganizationIterable responses = client.listCentralizationRulesForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCentralizationRulesForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCentralizationRulesForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link ListCentralizationRulesForOrganizationRequest#builder()}
     * </p>
     *
     * @param listCentralizationRulesForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListCentralizationRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListCentralizationRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCentralizationRulesForOrganizationIterable listCentralizationRulesForOrganizationPaginator(
            Consumer<ListCentralizationRulesForOrganizationRequest.Builder> listCentralizationRulesForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return listCentralizationRulesForOrganizationPaginator(ListCentralizationRulesForOrganizationRequest.builder()
                .applyMutation(listCentralizationRulesForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns a list of telemetry configurations for Amazon Web Services resources supported by telemetry config. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/telemetry-config-cloudwatch.html">Auditing
     * CloudWatch telemetry configurations</a>.
     * </p>
     *
     * @param listResourceTelemetryRequest
     * @return Result of the ListResourceTelemetry operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListResourceTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceTelemetryResponse listResourceTelemetry(ListResourceTelemetryRequest listResourceTelemetryRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of telemetry configurations for Amazon Web Services resources supported by telemetry config. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/telemetry-config-cloudwatch.html">Auditing
     * CloudWatch telemetry configurations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceTelemetryRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceTelemetryRequest#builder()}
     * </p>
     *
     * @param listResourceTelemetryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest.Builder} to
     *        create a request.
     * @return Result of the ListResourceTelemetry operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListResourceTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceTelemetryResponse listResourceTelemetry(
            Consumer<ListResourceTelemetryRequest.Builder> listResourceTelemetryRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return listResourceTelemetry(ListResourceTelemetryRequest.builder().applyMutation(listResourceTelemetryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceTelemetry(software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryIterable responses = client.listResourceTelemetryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryIterable responses = client
     *             .listResourceTelemetryPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryIterable responses = client.listResourceTelemetryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTelemetry(software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceTelemetryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListResourceTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceTelemetryIterable listResourceTelemetryPaginator(ListResourceTelemetryRequest listResourceTelemetryRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return new ListResourceTelemetryIterable(this, listResourceTelemetryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceTelemetry(software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryIterable responses = client.listResourceTelemetryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryIterable responses = client
     *             .listResourceTelemetryPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryIterable responses = client.listResourceTelemetryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTelemetry(software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceTelemetryRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceTelemetryRequest#builder()}
     * </p>
     *
     * @param listResourceTelemetryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListResourceTelemetry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetry"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceTelemetryIterable listResourceTelemetryPaginator(
            Consumer<ListResourceTelemetryRequest.Builder> listResourceTelemetryRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return listResourceTelemetryPaginator(ListResourceTelemetryRequest.builder().applyMutation(listResourceTelemetryRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of telemetry configurations for Amazon Web Services resources supported by telemetry config in the
     * organization.
     * </p>
     *
     * @param listResourceTelemetryForOrganizationRequest
     * @return Result of the ListResourceTelemetryForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListResourceTelemetryForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetryForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceTelemetryForOrganizationResponse listResourceTelemetryForOrganization(
            ListResourceTelemetryForOrganizationRequest listResourceTelemetryForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of telemetry configurations for Amazon Web Services resources supported by telemetry config in the
     * organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResourceTelemetryForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link ListResourceTelemetryForOrganizationRequest#builder()}
     * </p>
     *
     * @param listResourceTelemetryForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the ListResourceTelemetryForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListResourceTelemetryForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetryForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceTelemetryForOrganizationResponse listResourceTelemetryForOrganization(
            Consumer<ListResourceTelemetryForOrganizationRequest.Builder> listResourceTelemetryForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return listResourceTelemetryForOrganization(ListResourceTelemetryForOrganizationRequest.builder()
                .applyMutation(listResourceTelemetryForOrganizationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceTelemetryForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryForOrganizationIterable responses = client.listResourceTelemetryForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryForOrganizationIterable responses = client
     *             .listResourceTelemetryForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryForOrganizationIterable responses = client.listResourceTelemetryForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTelemetryForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceTelemetryForOrganizationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListResourceTelemetryForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetryForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceTelemetryForOrganizationIterable listResourceTelemetryForOrganizationPaginator(
            ListResourceTelemetryForOrganizationRequest listResourceTelemetryForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return new ListResourceTelemetryForOrganizationIterable(this, listResourceTelemetryForOrganizationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceTelemetryForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryForOrganizationIterable responses = client.listResourceTelemetryForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryForOrganizationIterable responses = client
     *             .listResourceTelemetryForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListResourceTelemetryForOrganizationIterable responses = client.listResourceTelemetryForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceTelemetryForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResourceTelemetryForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link ListResourceTelemetryForOrganizationRequest#builder()}
     * </p>
     *
     * @param listResourceTelemetryForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListResourceTelemetryForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListResourceTelemetryForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceTelemetryForOrganizationIterable listResourceTelemetryForOrganizationPaginator(
            Consumer<ListResourceTelemetryForOrganizationRequest.Builder> listResourceTelemetryForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return listResourceTelemetryForOrganizationPaginator(ListResourceTelemetryForOrganizationRequest.builder()
                .applyMutation(listResourceTelemetryForOrganizationRequest).build());
    }

    /**
     * <p>
     * Lists all S3 Table integrations in your account. We recommend using pagination to ensure that the operation
     * returns quickly and successfully.
     * </p>
     *
     * @param listS3TableIntegrationsRequest
     * @return Result of the ListS3TableIntegrations operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListS3TableIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListS3TableIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListS3TableIntegrationsResponse listS3TableIntegrations(ListS3TableIntegrationsRequest listS3TableIntegrationsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all S3 Table integrations in your account. We recommend using pagination to ensure that the operation
     * returns quickly and successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListS3TableIntegrationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListS3TableIntegrationsRequest#builder()}
     * </p>
     *
     * @param listS3TableIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListS3TableIntegrations operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListS3TableIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListS3TableIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListS3TableIntegrationsResponse listS3TableIntegrations(
            Consumer<ListS3TableIntegrationsRequest.Builder> listS3TableIntegrationsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return listS3TableIntegrations(ListS3TableIntegrationsRequest.builder().applyMutation(listS3TableIntegrationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listS3TableIntegrations(software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListS3TableIntegrationsIterable responses = client.listS3TableIntegrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListS3TableIntegrationsIterable responses = client
     *             .listS3TableIntegrationsPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListS3TableIntegrationsIterable responses = client.listS3TableIntegrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listS3TableIntegrations(software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listS3TableIntegrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListS3TableIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListS3TableIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListS3TableIntegrationsIterable listS3TableIntegrationsPaginator(
            ListS3TableIntegrationsRequest listS3TableIntegrationsRequest) throws AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return new ListS3TableIntegrationsIterable(this, listS3TableIntegrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listS3TableIntegrations(software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListS3TableIntegrationsIterable responses = client.listS3TableIntegrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListS3TableIntegrationsIterable responses = client
     *             .listS3TableIntegrationsPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListS3TableIntegrationsIterable responses = client.listS3TableIntegrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listS3TableIntegrations(software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListS3TableIntegrationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListS3TableIntegrationsRequest#builder()}
     * </p>
     *
     * @param listS3TableIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListS3TableIntegrationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListS3TableIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListS3TableIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListS3TableIntegrationsIterable listS3TableIntegrationsPaginator(
            Consumer<ListS3TableIntegrationsRequest.Builder> listS3TableIntegrationsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return listS3TableIntegrationsPaginator(ListS3TableIntegrationsRequest.builder()
                .applyMutation(listS3TableIntegrationsRequest).build());
    }

    /**
     * <p>
     * Lists all tags attached to the specified resource. Supports telemetry rule resources and telemetry pipeline
     * resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags attached to the specified resource. Supports telemetry rule resources and telemetry pipeline
     * resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ObservabilityAdminException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of telemetry pipelines in your account. Returns up to 100 results. If more than 100 telemetry
     * pipelines exist, include the <code>NextToken</code> value from the response to retrieve the next set of results.
     * </p>
     *
     * @param listTelemetryPipelinesRequest
     * @return Result of the ListTelemetryPipelines operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryPipelinesResponse listTelemetryPipelines(ListTelemetryPipelinesRequest listTelemetryPipelinesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of telemetry pipelines in your account. Returns up to 100 results. If more than 100 telemetry
     * pipelines exist, include the <code>NextToken</code> value from the response to retrieve the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTelemetryPipelinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTelemetryPipelinesRequest#builder()}
     * </p>
     *
     * @param listTelemetryPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest.Builder} to
     *        create a request.
     * @return Result of the ListTelemetryPipelines operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryPipelinesResponse listTelemetryPipelines(
            Consumer<ListTelemetryPipelinesRequest.Builder> listTelemetryPipelinesRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return listTelemetryPipelines(ListTelemetryPipelinesRequest.builder().applyMutation(listTelemetryPipelinesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTelemetryPipelines(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryPipelinesIterable responses = client.listTelemetryPipelinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryPipelinesIterable responses = client
     *             .listTelemetryPipelinesPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryPipelinesIterable responses = client.listTelemetryPipelinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTelemetryPipelines(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTelemetryPipelinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryPipelinesIterable listTelemetryPipelinesPaginator(
            ListTelemetryPipelinesRequest listTelemetryPipelinesRequest) throws AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return new ListTelemetryPipelinesIterable(this, listTelemetryPipelinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTelemetryPipelines(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryPipelinesIterable responses = client.listTelemetryPipelinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryPipelinesIterable responses = client
     *             .listTelemetryPipelinesPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryPipelinesIterable responses = client.listTelemetryPipelinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTelemetryPipelines(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTelemetryPipelinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTelemetryPipelinesRequest#builder()}
     * </p>
     *
     * @param listTelemetryPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryPipelinesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryPipelinesIterable listTelemetryPipelinesPaginator(
            Consumer<ListTelemetryPipelinesRequest.Builder> listTelemetryPipelinesRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return listTelemetryPipelinesPaginator(ListTelemetryPipelinesRequest.builder()
                .applyMutation(listTelemetryPipelinesRequest).build());
    }

    /**
     * <p>
     * Lists all telemetry rules in your account. You can filter the results by specifying a rule name prefix.
     * </p>
     *
     * @param listTelemetryRulesRequest
     * @return Result of the ListTelemetryRules operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryRulesResponse listTelemetryRules(ListTelemetryRulesRequest listTelemetryRulesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all telemetry rules in your account. You can filter the results by specifying a rule name prefix.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTelemetryRulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTelemetryRulesRequest#builder()}
     * </p>
     *
     * @param listTelemetryRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest.Builder} to
     *        create a request.
     * @return Result of the ListTelemetryRules operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryRulesResponse listTelemetryRules(Consumer<ListTelemetryRulesRequest.Builder> listTelemetryRulesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return listTelemetryRules(ListTelemetryRulesRequest.builder().applyMutation(listTelemetryRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTelemetryRules(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesIterable responses = client.listTelemetryRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesIterable responses = client
     *             .listTelemetryRulesPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesIterable responses = client.listTelemetryRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTelemetryRules(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTelemetryRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryRulesIterable listTelemetryRulesPaginator(ListTelemetryRulesRequest listTelemetryRulesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return new ListTelemetryRulesIterable(this, listTelemetryRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTelemetryRules(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesIterable responses = client.listTelemetryRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesIterable responses = client
     *             .listTelemetryRulesPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesIterable responses = client.listTelemetryRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTelemetryRules(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTelemetryRulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTelemetryRulesRequest#builder()}
     * </p>
     *
     * @param listTelemetryRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryRulesIterable listTelemetryRulesPaginator(
            Consumer<ListTelemetryRulesRequest.Builder> listTelemetryRulesRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return listTelemetryRulesPaginator(ListTelemetryRulesRequest.builder().applyMutation(listTelemetryRulesRequest).build());
    }

    /**
     * <p>
     * Lists all telemetry rules in your organization. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     *
     * @param listTelemetryRulesForOrganizationRequest
     * @return Result of the ListTelemetryRulesForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryRulesForOrganizationResponse listTelemetryRulesForOrganization(
            ListTelemetryRulesForOrganizationRequest listTelemetryRulesForOrganizationRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all telemetry rules in your organization. This operation can only be called by the organization's
     * management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTelemetryRulesForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link ListTelemetryRulesForOrganizationRequest#builder()}
     * </p>
     *
     * @param listTelemetryRulesForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the ListTelemetryRulesForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryRulesForOrganizationResponse listTelemetryRulesForOrganization(
            Consumer<ListTelemetryRulesForOrganizationRequest.Builder> listTelemetryRulesForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return listTelemetryRulesForOrganization(ListTelemetryRulesForOrganizationRequest.builder()
                .applyMutation(listTelemetryRulesForOrganizationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTelemetryRulesForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesForOrganizationIterable responses = client.listTelemetryRulesForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesForOrganizationIterable responses = client
     *             .listTelemetryRulesForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesForOrganizationIterable responses = client.listTelemetryRulesForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTelemetryRulesForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTelemetryRulesForOrganizationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryRulesForOrganizationIterable listTelemetryRulesForOrganizationPaginator(
            ListTelemetryRulesForOrganizationRequest listTelemetryRulesForOrganizationRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return new ListTelemetryRulesForOrganizationIterable(this, listTelemetryRulesForOrganizationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTelemetryRulesForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesForOrganizationIterable responses = client.listTelemetryRulesForOrganizationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesForOrganizationIterable responses = client
     *             .listTelemetryRulesForOrganizationPaginator(request);
     *     for (software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.observabilityadmin.paginators.ListTelemetryRulesForOrganizationIterable responses = client.listTelemetryRulesForOrganizationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTelemetryRulesForOrganization(software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTelemetryRulesForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link ListTelemetryRulesForOrganizationRequest#builder()}
     * </p>
     *
     * @param listTelemetryRulesForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ListTelemetryRulesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ListTelemetryRulesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTelemetryRulesForOrganizationIterable listTelemetryRulesForOrganizationPaginator(
            Consumer<ListTelemetryRulesForOrganizationRequest.Builder> listTelemetryRulesForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return listTelemetryRulesForOrganizationPaginator(ListTelemetryRulesForOrganizationRequest.builder()
                .applyMutation(listTelemetryRulesForOrganizationRequest).build());
    }

    /**
     * <p>
     * Enables the resource tags for telemetry feature for your account, which enhances telemetry data with additional
     * resource metadata from Resource Explorer to provide richer context for monitoring and observability.
     * </p>
     *
     * @param startTelemetryEnrichmentRequest
     * @return Result of the StartTelemetryEnrichment operation returned by the service.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StartTelemetryEnrichment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEnrichment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTelemetryEnrichmentResponse startTelemetryEnrichment(
            StartTelemetryEnrichmentRequest startTelemetryEnrichmentRequest) throws ConflictException, AccessDeniedException,
            InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the resource tags for telemetry feature for your account, which enhances telemetry data with additional
     * resource metadata from Resource Explorer to provide richer context for monitoring and observability.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTelemetryEnrichmentRequest.Builder} avoiding
     * the need to create one manually via {@link StartTelemetryEnrichmentRequest#builder()}
     * </p>
     *
     * @param startTelemetryEnrichmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEnrichmentRequest.Builder}
     *        to create a request.
     * @return Result of the StartTelemetryEnrichment operation returned by the service.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StartTelemetryEnrichment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEnrichment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTelemetryEnrichmentResponse startTelemetryEnrichment(
            Consumer<StartTelemetryEnrichmentRequest.Builder> startTelemetryEnrichmentRequest) throws ConflictException,
            AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return startTelemetryEnrichment(StartTelemetryEnrichmentRequest.builder().applyMutation(startTelemetryEnrichmentRequest)
                .build());
    }

    /**
     * <p>
     * This action begins onboarding the caller Amazon Web Services account to the telemetry config feature.
     * </p>
     *
     * @param startTelemetryEvaluationRequest
     * @return Result of the StartTelemetryEvaluation operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StartTelemetryEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTelemetryEvaluationResponse startTelemetryEvaluation(
            StartTelemetryEvaluationRequest startTelemetryEvaluationRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action begins onboarding the caller Amazon Web Services account to the telemetry config feature.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTelemetryEvaluationRequest.Builder} avoiding
     * the need to create one manually via {@link StartTelemetryEvaluationRequest#builder()}
     * </p>
     *
     * @param startTelemetryEvaluationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationRequest.Builder}
     *        to create a request.
     * @return Result of the StartTelemetryEvaluation operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StartTelemetryEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTelemetryEvaluationResponse startTelemetryEvaluation(
            Consumer<StartTelemetryEvaluationRequest.Builder> startTelemetryEvaluationRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return startTelemetryEvaluation(StartTelemetryEvaluationRequest.builder().applyMutation(startTelemetryEvaluationRequest)
                .build());
    }

    /**
     * <p>
     * This actions begins onboarding the organization and all member accounts to the telemetry config feature.
     * </p>
     *
     * @param startTelemetryEvaluationForOrganizationRequest
     * @return Result of the StartTelemetryEvaluationForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StartTelemetryEvaluationForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEvaluationForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTelemetryEvaluationForOrganizationResponse startTelemetryEvaluationForOrganization(
            StartTelemetryEvaluationForOrganizationRequest startTelemetryEvaluationForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This actions begins onboarding the organization and all member accounts to the telemetry config feature.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartTelemetryEvaluationForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link StartTelemetryEvaluationForOrganizationRequest#builder()}
     * </p>
     *
     * @param startTelemetryEvaluationForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.StartTelemetryEvaluationForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the StartTelemetryEvaluationForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StartTelemetryEvaluationForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StartTelemetryEvaluationForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTelemetryEvaluationForOrganizationResponse startTelemetryEvaluationForOrganization(
            Consumer<StartTelemetryEvaluationForOrganizationRequest.Builder> startTelemetryEvaluationForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return startTelemetryEvaluationForOrganization(StartTelemetryEvaluationForOrganizationRequest.builder()
                .applyMutation(startTelemetryEvaluationForOrganizationRequest).build());
    }

    /**
     * <p>
     * Disables the resource tags for telemetry feature for your account, stopping the enhancement of telemetry data
     * with additional resource metadata.
     * </p>
     *
     * @param stopTelemetryEnrichmentRequest
     * @return Result of the StopTelemetryEnrichment operation returned by the service.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StopTelemetryEnrichment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEnrichment"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTelemetryEnrichmentResponse stopTelemetryEnrichment(StopTelemetryEnrichmentRequest stopTelemetryEnrichmentRequest)
            throws ConflictException, AccessDeniedException, InternalServerException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the resource tags for telemetry feature for your account, stopping the enhancement of telemetry data
     * with additional resource metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTelemetryEnrichmentRequest.Builder} avoiding
     * the need to create one manually via {@link StopTelemetryEnrichmentRequest#builder()}
     * </p>
     *
     * @param stopTelemetryEnrichmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEnrichmentRequest.Builder} to
     *        create a request.
     * @return Result of the StopTelemetryEnrichment operation returned by the service.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StopTelemetryEnrichment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEnrichment"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTelemetryEnrichmentResponse stopTelemetryEnrichment(
            Consumer<StopTelemetryEnrichmentRequest.Builder> stopTelemetryEnrichmentRequest) throws ConflictException,
            AccessDeniedException, InternalServerException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return stopTelemetryEnrichment(StopTelemetryEnrichmentRequest.builder().applyMutation(stopTelemetryEnrichmentRequest)
                .build());
    }

    /**
     * <p>
     * This action begins offboarding the caller Amazon Web Services account from the telemetry config feature.
     * </p>
     *
     * @param stopTelemetryEvaluationRequest
     * @return Result of the StopTelemetryEvaluation operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StopTelemetryEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTelemetryEvaluationResponse stopTelemetryEvaluation(StopTelemetryEvaluationRequest stopTelemetryEvaluationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action begins offboarding the caller Amazon Web Services account from the telemetry config feature.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTelemetryEvaluationRequest.Builder} avoiding
     * the need to create one manually via {@link StopTelemetryEvaluationRequest#builder()}
     * </p>
     *
     * @param stopTelemetryEvaluationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationRequest.Builder} to
     *        create a request.
     * @return Result of the StopTelemetryEvaluation operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StopTelemetryEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTelemetryEvaluationResponse stopTelemetryEvaluation(
            Consumer<StopTelemetryEvaluationRequest.Builder> stopTelemetryEvaluationRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return stopTelemetryEvaluation(StopTelemetryEvaluationRequest.builder().applyMutation(stopTelemetryEvaluationRequest)
                .build());
    }

    /**
     * <p>
     * This action offboards the Organization of the caller Amazon Web Services account from the telemetry config
     * feature.
     * </p>
     *
     * @param stopTelemetryEvaluationForOrganizationRequest
     * @return Result of the StopTelemetryEvaluationForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StopTelemetryEvaluationForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEvaluationForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTelemetryEvaluationForOrganizationResponse stopTelemetryEvaluationForOrganization(
            StopTelemetryEvaluationForOrganizationRequest stopTelemetryEvaluationForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action offboards the Organization of the caller Amazon Web Services account from the telemetry config
     * feature.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StopTelemetryEvaluationForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link StopTelemetryEvaluationForOrganizationRequest#builder()}
     * </p>
     *
     * @param stopTelemetryEvaluationForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.StopTelemetryEvaluationForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the StopTelemetryEvaluationForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.StopTelemetryEvaluationForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/StopTelemetryEvaluationForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTelemetryEvaluationForOrganizationResponse stopTelemetryEvaluationForOrganization(
            Consumer<StopTelemetryEvaluationForOrganizationRequest.Builder> stopTelemetryEvaluationForOrganizationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return stopTelemetryEvaluationForOrganization(StopTelemetryEvaluationForOrganizationRequest.builder()
                .applyMutation(stopTelemetryEvaluationForOrganizationRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a resource. Supports telemetry rule resources and telemetry pipeline resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a resource. Supports telemetry rule resources and telemetry pipeline resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests a pipeline configuration with sample records to validate data processing before deployment. This operation
     * helps ensure your pipeline configuration works as expected.
     * </p>
     *
     * @param testTelemetryPipelineRequest
     * @return Result of the TestTelemetryPipeline operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.TestTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/TestTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default TestTelemetryPipelineResponse testTelemetryPipeline(TestTelemetryPipelineRequest testTelemetryPipelineRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests a pipeline configuration with sample records to validate data processing before deployment. This operation
     * helps ensure your pipeline configuration works as expected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestTelemetryPipelineRequest.Builder} avoiding the
     * need to create one manually via {@link TestTelemetryPipelineRequest#builder()}
     * </p>
     *
     * @param testTelemetryPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.TestTelemetryPipelineRequest.Builder} to
     *        create a request.
     * @return Result of the TestTelemetryPipeline operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.TestTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/TestTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default TestTelemetryPipelineResponse testTelemetryPipeline(
            Consumer<TestTelemetryPipelineRequest.Builder> testTelemetryPipelineRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        return testTelemetryPipeline(TestTelemetryPipelineRequest.builder().applyMutation(testTelemetryPipelineRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource. Supports telemetry rule resources and telemetry pipeline resources.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource. Supports telemetry rule resources and telemetry pipeline resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing centralization rule that applies across an Amazon Web Services Organization. This operation
     * can only be called by the organization's management account or a delegated administrator account.
     * </p>
     *
     * @param updateCentralizationRuleForOrganizationRequest
     * @return Result of the UpdateCentralizationRuleForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UpdateCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCentralizationRuleForOrganizationResponse updateCentralizationRuleForOrganization(
            UpdateCentralizationRuleForOrganizationRequest updateCentralizationRuleForOrganizationRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing centralization rule that applies across an Amazon Web Services Organization. This operation
     * can only be called by the organization's management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCentralizationRuleForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCentralizationRuleForOrganizationRequest#builder()}
     * </p>
     *
     * @param updateCentralizationRuleForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.UpdateCentralizationRuleForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateCentralizationRuleForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UpdateCentralizationRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateCentralizationRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCentralizationRuleForOrganizationResponse updateCentralizationRuleForOrganization(
            Consumer<UpdateCentralizationRuleForOrganizationRequest.Builder> updateCentralizationRuleForOrganizationRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return updateCentralizationRuleForOrganization(UpdateCentralizationRuleForOrganizationRequest.builder()
                .applyMutation(updateCentralizationRuleForOrganizationRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing telemetry pipeline.
     * </p>
     * <note>
     * <p>
     * The following attributes cannot be updated after pipeline creation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Pipeline name</b> - The pipeline name is immutable
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Pipeline ARN</b> - The ARN is automatically generated and cannot be changed
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Source type</b> - Once a pipeline is created with a specific source type (such as S3, CloudWatch Logs, GitHub,
     * or third-party sources), it cannot be changed to a different source type
     * </p>
     * </li>
     * </ul>
     * <p>
     * Processors can be added, removed, or modified. However, some processors are not supported for third-party
     * pipelines and cannot be added through updates.
     * </p>
     * </note>
     * <p>
     * <b>Source-Specific Update Rules</b>
     * </p>
     * <dl>
     * <dt>CloudWatch Logs Sources (Vended and Custom)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> <code>sts_role_arn</code>
     * </p>
     * <p>
     * <b>Fixed:</b> <code>data_source_name</code>, <code>data_source_type</code>, sink (must remain
     * <code>@original</code>)
     * </p>
     * </dd>
     * <dt>S3 Sources (Crowdstrike, Zscaler, SentinelOne, Custom)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All SQS configuration parameters, <code>sts_role_arn</code>, codec settings, compression type,
     * bucket ownership settings, sink log group
     * </p>
     * <p>
     * <b>Fixed:</b> <code>notification_type</code>, <code>aws.region</code>
     * </p>
     * </dd>
     * <dt>GitHub Audit Logs</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>scope</code> (can switch between
     * ORGANIZATION/ENTERPRISE), <code>organization</code> or <code>enterprise</code> name, <code>range</code>,
     * authentication credentials (PAT or GitHub App)
     * </p>
     * </dd>
     * <dt>Microsoft Sources (Entra ID, Office365, Windows)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>tenant_id</code>,
     * <code>workspace_id</code> (Windows only), OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Okta Sources (SSO, Auth0)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>domain</code>, <code>range</code>
     * (SSO only), OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Palo Alto Networks</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>hostname</code>, basic authentication
     * credentials (<code>username</code>, <code>password</code>)
     * </p>
     * </dd>
     * <dt>ServiceNow CMDB</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>instance_url</code>,
     * <code>range</code>, OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Wiz CNAPP</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>region</code>, <code>range</code>,
     * OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * </dl>
     *
     * @param updateTelemetryPipelineRequest
     * @return Result of the UpdateTelemetryPipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UpdateTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTelemetryPipelineResponse updateTelemetryPipeline(UpdateTelemetryPipelineRequest updateTelemetryPipelineRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing telemetry pipeline.
     * </p>
     * <note>
     * <p>
     * The following attributes cannot be updated after pipeline creation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Pipeline name</b> - The pipeline name is immutable
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Pipeline ARN</b> - The ARN is automatically generated and cannot be changed
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Source type</b> - Once a pipeline is created with a specific source type (such as S3, CloudWatch Logs, GitHub,
     * or third-party sources), it cannot be changed to a different source type
     * </p>
     * </li>
     * </ul>
     * <p>
     * Processors can be added, removed, or modified. However, some processors are not supported for third-party
     * pipelines and cannot be added through updates.
     * </p>
     * </note>
     * <p>
     * <b>Source-Specific Update Rules</b>
     * </p>
     * <dl>
     * <dt>CloudWatch Logs Sources (Vended and Custom)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> <code>sts_role_arn</code>
     * </p>
     * <p>
     * <b>Fixed:</b> <code>data_source_name</code>, <code>data_source_type</code>, sink (must remain
     * <code>@original</code>)
     * </p>
     * </dd>
     * <dt>S3 Sources (Crowdstrike, Zscaler, SentinelOne, Custom)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All SQS configuration parameters, <code>sts_role_arn</code>, codec settings, compression type,
     * bucket ownership settings, sink log group
     * </p>
     * <p>
     * <b>Fixed:</b> <code>notification_type</code>, <code>aws.region</code>
     * </p>
     * </dd>
     * <dt>GitHub Audit Logs</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>scope</code> (can switch between
     * ORGANIZATION/ENTERPRISE), <code>organization</code> or <code>enterprise</code> name, <code>range</code>,
     * authentication credentials (PAT or GitHub App)
     * </p>
     * </dd>
     * <dt>Microsoft Sources (Entra ID, Office365, Windows)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>tenant_id</code>,
     * <code>workspace_id</code> (Windows only), OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Okta Sources (SSO, Auth0)</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>domain</code>, <code>range</code>
     * (SSO only), OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Palo Alto Networks</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>hostname</code>, basic authentication
     * credentials (<code>username</code>, <code>password</code>)
     * </p>
     * </dd>
     * <dt>ServiceNow CMDB</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>instance_url</code>,
     * <code>range</code>, OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * <dt>Wiz CNAPP</dt>
     * <dd>
     * <p>
     * <b>Updatable:</b> All Amazon Web Services Secrets Manager attributes, <code>region</code>, <code>range</code>,
     * OAuth2 credentials (<code>client_id</code>, <code>client_secret</code>)
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTelemetryPipelineRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateTelemetryPipelineRequest#builder()}
     * </p>
     *
     * @param updateTelemetryPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryPipelineRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateTelemetryPipeline operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UpdateTelemetryPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTelemetryPipelineResponse updateTelemetryPipeline(
            Consumer<UpdateTelemetryPipelineRequest.Builder> updateTelemetryPipelineRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ObservabilityAdminException {
        return updateTelemetryPipeline(UpdateTelemetryPipelineRequest.builder().applyMutation(updateTelemetryPipelineRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing telemetry rule in your account. If multiple users attempt to modify the same telemetry rule
     * simultaneously, a ConflictException is returned to provide specific error information for concurrent modification
     * scenarios.
     * </p>
     *
     * @param updateTelemetryRuleRequest
     * @return Result of the UpdateTelemetryRule operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UpdateTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTelemetryRuleResponse updateTelemetryRule(UpdateTelemetryRuleRequest updateTelemetryRuleRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, ConflictException, AccessDeniedException,
            InternalServerException, ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing telemetry rule in your account. If multiple users attempt to modify the same telemetry rule
     * simultaneously, a ConflictException is returned to provide specific error information for concurrent modification
     * scenarios.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTelemetryRuleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTelemetryRuleRequest#builder()}
     * </p>
     *
     * @param updateTelemetryRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateTelemetryRule operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws ConflictException
     *         The requested operation conflicts with the current state of the specified resource or with another
     *         request.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UpdateTelemetryRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTelemetryRuleResponse updateTelemetryRule(
            Consumer<UpdateTelemetryRuleRequest.Builder> updateTelemetryRuleRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, ConflictException, AccessDeniedException, InternalServerException, ValidationException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return updateTelemetryRule(UpdateTelemetryRuleRequest.builder().applyMutation(updateTelemetryRuleRequest).build());
    }

    /**
     * <p>
     * Updates an existing telemetry rule that applies across an Amazon Web Services Organization. This operation can
     * only be called by the organization's management account or a delegated administrator account.
     * </p>
     *
     * @param updateTelemetryRuleForOrganizationRequest
     * @return Result of the UpdateTelemetryRuleForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UpdateTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTelemetryRuleForOrganizationResponse updateTelemetryRuleForOrganization(
            UpdateTelemetryRuleForOrganizationRequest updateTelemetryRuleForOrganizationRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing telemetry rule that applies across an Amazon Web Services Organization. This operation can
     * only be called by the organization's management account or a delegated administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTelemetryRuleForOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTelemetryRuleForOrganizationRequest#builder()}
     * </p>
     *
     * @param updateTelemetryRuleForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.UpdateTelemetryRuleForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateTelemetryRuleForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The requested operation would exceed the allowed quota for the specified resource type.
     * @throws ResourceNotFoundException
     *         The specified resource (such as a telemetry rule) could not be found.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.UpdateTelemetryRuleForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/UpdateTelemetryRuleForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTelemetryRuleForOrganizationResponse updateTelemetryRuleForOrganization(
            Consumer<UpdateTelemetryRuleForOrganizationRequest.Builder> updateTelemetryRuleForOrganizationRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            ValidationException, TooManyRequestsException, AwsServiceException, SdkClientException, ObservabilityAdminException {
        return updateTelemetryRuleForOrganization(UpdateTelemetryRuleForOrganizationRequest.builder()
                .applyMutation(updateTelemetryRuleForOrganizationRequest).build());
    }

    /**
     * <p>
     * Validates a pipeline configuration without creating the pipeline. This operation checks the configuration for
     * syntax errors and compatibility issues.
     * </p>
     *
     * @param validateTelemetryPipelineConfigurationRequest
     * @return Result of the ValidateTelemetryPipelineConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ValidateTelemetryPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ValidateTelemetryPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateTelemetryPipelineConfigurationResponse validateTelemetryPipelineConfiguration(
            ValidateTelemetryPipelineConfigurationRequest validateTelemetryPipelineConfigurationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates a pipeline configuration without creating the pipeline. This operation checks the configuration for
     * syntax errors and compatibility issues.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ValidateTelemetryPipelineConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link ValidateTelemetryPipelineConfigurationRequest#builder()}
     * </p>
     *
     * @param validateTelemetryPipelineConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.observabilityadmin.model.ValidateTelemetryPipelineConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the ValidateTelemetryPipelineConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         Indicates you don't have permissions to perform the requested operation. The user or role that is making
     *         the request must have at least one IAM permissions policy attached that grants the required permissions.
     *         For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         management for Amazon Web Services resources</a> in the IAM user guide.
     * @throws InternalServerException
     *         Indicates the request has failed to process because of an unknown server error, exception, or failure.
     * @throws ValidationException
     *         Indicates input validation failed. Check your request parameters and retry the request.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ObservabilityAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ObservabilityAdminClient.ValidateTelemetryPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/observabilityadmin-2018-05-10/ValidateTelemetryPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateTelemetryPipelineConfigurationResponse validateTelemetryPipelineConfiguration(
            Consumer<ValidateTelemetryPipelineConfigurationRequest.Builder> validateTelemetryPipelineConfigurationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ObservabilityAdminException {
        return validateTelemetryPipelineConfiguration(ValidateTelemetryPipelineConfigurationRequest.builder()
                .applyMutation(validateTelemetryPipelineConfigurationRequest).build());
    }

    /**
     * Create a {@link ObservabilityAdminClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ObservabilityAdminClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ObservabilityAdminClient}.
     */
    static ObservabilityAdminClientBuilder builder() {
        return new DefaultObservabilityAdminClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ObservabilityAdminServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
