/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.observabilityadmin.model.CentralizationFailureReason;
import software.amazon.awssdk.services.observabilityadmin.model.CentralizationRule;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminResponse;
import software.amazon.awssdk.services.observabilityadmin.model.RuleHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCentralizationRuleForOrganizationResponse
extends ObservabilityAdminResponse
implements ToCopyableBuilder<Builder, GetCentralizationRuleForOrganizationResponse> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::ruleName)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::ruleArn)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorAccountId").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::creatorAccountId)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorAccountId").build()}).build();
    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreatedTimeStamp").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::createdTimeStamp)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()}).build();
    private static final SdkField<String> CREATED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedRegion").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::createdRegion)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::createdRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedRegion").build()}).build();
    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastUpdateTimeStamp").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::lastUpdateTimeStamp)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::lastUpdateTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build()}).build();
    private static final SdkField<String> RULE_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleHealth").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::ruleHealthAsString)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::ruleHealth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleHealth").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::failureReasonAsString)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<CentralizationRule> CENTRALIZATION_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CentralizationRule").getter(GetCentralizationRuleForOrganizationResponse.getter(GetCentralizationRuleForOrganizationResponse::centralizationRule)).setter(GetCentralizationRuleForOrganizationResponse.setter(Builder::centralizationRule)).constructor(CentralizationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CentralizationRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, RULE_ARN_FIELD, CREATOR_ACCOUNT_ID_FIELD, CREATED_TIME_STAMP_FIELD, CREATED_REGION_FIELD, LAST_UPDATE_TIME_STAMP_FIELD, RULE_HEALTH_FIELD, FAILURE_REASON_FIELD, CENTRALIZATION_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCentralizationRuleForOrganizationResponse.memberNameToFieldInitializer();
    private final String ruleName;
    private final String ruleArn;
    private final String creatorAccountId;
    private final Long createdTimeStamp;
    private final String createdRegion;
    private final Long lastUpdateTimeStamp;
    private final String ruleHealth;
    private final String failureReason;
    private final CentralizationRule centralizationRule;

    private GetCentralizationRuleForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.ruleArn = builder.ruleArn;
        this.creatorAccountId = builder.creatorAccountId;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.createdRegion = builder.createdRegion;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
        this.ruleHealth = builder.ruleHealth;
        this.failureReason = builder.failureReason;
        this.centralizationRule = builder.centralizationRule;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public final Long createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public final String createdRegion() {
        return this.createdRegion;
    }

    public final Long lastUpdateTimeStamp() {
        return this.lastUpdateTimeStamp;
    }

    public final RuleHealth ruleHealth() {
        return RuleHealth.fromValue(this.ruleHealth);
    }

    public final String ruleHealthAsString() {
        return this.ruleHealth;
    }

    public final CentralizationFailureReason failureReason() {
        return CentralizationFailureReason.fromValue(this.failureReason);
    }

    public final String failureReasonAsString() {
        return this.failureReason;
    }

    public final CentralizationRule centralizationRule() {
        return this.centralizationRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.centralizationRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCentralizationRuleForOrganizationResponse)) {
            return false;
        }
        GetCentralizationRuleForOrganizationResponse other = (GetCentralizationRuleForOrganizationResponse)((Object)obj);
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId()) && Objects.equals(this.createdTimeStamp(), other.createdTimeStamp()) && Objects.equals(this.createdRegion(), other.createdRegion()) && Objects.equals(this.lastUpdateTimeStamp(), other.lastUpdateTimeStamp()) && Objects.equals(this.ruleHealthAsString(), other.ruleHealthAsString()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString()) && Objects.equals(this.centralizationRule(), other.centralizationRule());
    }

    public final String toString() {
        return ToString.builder((String)"GetCentralizationRuleForOrganizationResponse").add("RuleName", (Object)this.ruleName()).add("RuleArn", (Object)this.ruleArn()).add("CreatorAccountId", (Object)this.creatorAccountId()).add("CreatedTimeStamp", (Object)this.createdTimeStamp()).add("CreatedRegion", (Object)this.createdRegion()).add("LastUpdateTimeStamp", (Object)this.lastUpdateTimeStamp()).add("RuleHealth", (Object)this.ruleHealthAsString()).add("FailureReason", (Object)this.failureReasonAsString()).add("CentralizationRule", (Object)this.centralizationRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "CreatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
            case "CreatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
            case "CreatedRegion": {
                return Optional.ofNullable(clazz.cast(this.createdRegion()));
            }
            case "LastUpdateTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimeStamp()));
            }
            case "RuleHealth": {
                return Optional.ofNullable(clazz.cast(this.ruleHealthAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReasonAsString()));
            }
            case "CentralizationRule": {
                return Optional.ofNullable(clazz.cast(this.centralizationRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("CreatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        map.put("CreatedRegion", CREATED_REGION_FIELD);
        map.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        map.put("RuleHealth", RULE_HEALTH_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("CentralizationRule", CENTRALIZATION_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCentralizationRuleForOrganizationResponse, T> g) {
        return obj -> g.apply((GetCentralizationRuleForOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminResponse.BuilderImpl
    implements Builder {
        private String ruleName;
        private String ruleArn;
        private String creatorAccountId;
        private Long createdTimeStamp;
        private String createdRegion;
        private Long lastUpdateTimeStamp;
        private String ruleHealth;
        private String failureReason;
        private CentralizationRule centralizationRule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCentralizationRuleForOrganizationResponse model) {
            super(model);
            this.ruleName(model.ruleName);
            this.ruleArn(model.ruleArn);
            this.creatorAccountId(model.creatorAccountId);
            this.createdTimeStamp(model.createdTimeStamp);
            this.createdRegion(model.createdRegion);
            this.lastUpdateTimeStamp(model.lastUpdateTimeStamp);
            this.ruleHealth(model.ruleHealth);
            this.failureReason(model.failureReason);
            this.centralizationRule(model.centralizationRule);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final Long getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final String getCreatedRegion() {
            return this.createdRegion;
        }

        public final void setCreatedRegion(String createdRegion) {
            this.createdRegion = createdRegion;
        }

        @Override
        public final Builder createdRegion(String createdRegion) {
            this.createdRegion = createdRegion;
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return this.lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public final String getRuleHealth() {
            return this.ruleHealth;
        }

        public final void setRuleHealth(String ruleHealth) {
            this.ruleHealth = ruleHealth;
        }

        @Override
        public final Builder ruleHealth(String ruleHealth) {
            this.ruleHealth = ruleHealth;
            return this;
        }

        @Override
        public final Builder ruleHealth(RuleHealth ruleHealth) {
            this.ruleHealth(ruleHealth == null ? null : ruleHealth.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(CentralizationFailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public final CentralizationRule.Builder getCentralizationRule() {
            return this.centralizationRule != null ? this.centralizationRule.toBuilder() : null;
        }

        public final void setCentralizationRule(CentralizationRule.BuilderImpl centralizationRule) {
            this.centralizationRule = centralizationRule != null ? centralizationRule.build() : null;
        }

        @Override
        public final Builder centralizationRule(CentralizationRule centralizationRule) {
            this.centralizationRule = centralizationRule;
            return this;
        }

        @Override
        public GetCentralizationRuleForOrganizationResponse build() {
            return new GetCentralizationRuleForOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCentralizationRuleForOrganizationResponse> {
        public Builder ruleName(String var1);

        public Builder ruleArn(String var1);

        public Builder creatorAccountId(String var1);

        public Builder createdTimeStamp(Long var1);

        public Builder createdRegion(String var1);

        public Builder lastUpdateTimeStamp(Long var1);

        public Builder ruleHealth(String var1);

        public Builder ruleHealth(RuleHealth var1);

        public Builder failureReason(String var1);

        public Builder failureReason(CentralizationFailureReason var1);

        public Builder centralizationRule(CentralizationRule var1);

        default public Builder centralizationRule(Consumer<CentralizationRule.Builder> centralizationRule) {
            return this.centralizationRule((CentralizationRule)((CentralizationRule.Builder)CentralizationRule.builder().applyMutation(centralizationRule)).build());
        }
    }
}

