/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.novaact.model.WorkflowDefinitionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowDefinitionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowDefinitionSummary> {
    private static final SdkField<String> WORKFLOW_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowDefinitionArn").getter(WorkflowDefinitionSummary.getter(WorkflowDefinitionSummary::workflowDefinitionArn)).setter(WorkflowDefinitionSummary.setter(Builder::workflowDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowDefinitionArn").build()}).build();
    private static final SdkField<String> WORKFLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowDefinitionName").getter(WorkflowDefinitionSummary.getter(WorkflowDefinitionSummary::workflowDefinitionName)).setter(WorkflowDefinitionSummary.setter(Builder::workflowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowDefinitionName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(WorkflowDefinitionSummary.getter(WorkflowDefinitionSummary::createdAt)).setter(WorkflowDefinitionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkflowDefinitionSummary.getter(WorkflowDefinitionSummary::statusAsString)).setter(WorkflowDefinitionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_DEFINITION_ARN_FIELD, WORKFLOW_DEFINITION_NAME_FIELD, CREATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowDefinitionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workflowDefinitionArn;
    private final String workflowDefinitionName;
    private final Instant createdAt;
    private final String status;

    private WorkflowDefinitionSummary(BuilderImpl builder) {
        this.workflowDefinitionArn = builder.workflowDefinitionArn;
        this.workflowDefinitionName = builder.workflowDefinitionName;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
    }

    public final String workflowDefinitionArn() {
        return this.workflowDefinitionArn;
    }

    public final String workflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final WorkflowDefinitionStatus status() {
        return WorkflowDefinitionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowDefinitionSummary)) {
            return false;
        }
        WorkflowDefinitionSummary other = (WorkflowDefinitionSummary)obj;
        return Objects.equals(this.workflowDefinitionArn(), other.workflowDefinitionArn()) && Objects.equals(this.workflowDefinitionName(), other.workflowDefinitionName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowDefinitionSummary").add("WorkflowDefinitionArn", (Object)this.workflowDefinitionArn()).add("WorkflowDefinitionName", (Object)this.workflowDefinitionName()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.workflowDefinitionArn()));
            }
            case "workflowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.workflowDefinitionName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowDefinitionArn", WORKFLOW_DEFINITION_ARN_FIELD);
        map.put("workflowDefinitionName", WORKFLOW_DEFINITION_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowDefinitionSummary, T> g) {
        return obj -> g.apply((WorkflowDefinitionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workflowDefinitionArn;
        private String workflowDefinitionName;
        private Instant createdAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowDefinitionSummary model) {
            this.workflowDefinitionArn(model.workflowDefinitionArn);
            this.workflowDefinitionName(model.workflowDefinitionName);
            this.createdAt(model.createdAt);
            this.status(model.status);
        }

        public final String getWorkflowDefinitionArn() {
            return this.workflowDefinitionArn;
        }

        public final void setWorkflowDefinitionArn(String workflowDefinitionArn) {
            this.workflowDefinitionArn = workflowDefinitionArn;
        }

        @Override
        public final Builder workflowDefinitionArn(String workflowDefinitionArn) {
            this.workflowDefinitionArn = workflowDefinitionArn;
            return this;
        }

        public final String getWorkflowDefinitionName() {
            return this.workflowDefinitionName;
        }

        public final void setWorkflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
        }

        @Override
        public final Builder workflowDefinitionName(String workflowDefinitionName) {
            this.workflowDefinitionName = workflowDefinitionName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowDefinitionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public WorkflowDefinitionSummary build() {
            return new WorkflowDefinitionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowDefinitionSummary> {
        public Builder workflowDefinitionArn(String var1);

        public Builder workflowDefinitionName(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(WorkflowDefinitionStatus var1);
    }
}

