/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.notifications.model.LocaleCode;
import software.amazon.awssdk.services.notifications.model.TextByLocaleCopier;
import software.amazon.awssdk.services.notifications.model.TextPartType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextPartValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextPartValue> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TextPartValue.getter(TextPartValue::typeAsString)).setter(TextPartValue.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DISPLAY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayText").getter(TextPartValue.getter(TextPartValue::displayText)).setter(TextPartValue.setter(Builder::displayText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayText").build()}).build();
    private static final SdkField<Map<String, String>> TEXT_BY_LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("textByLocale").getter(TextPartValue.getter(TextPartValue::textByLocaleAsStrings)).setter(TextPartValue.setter(Builder::textByLocaleWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textByLocale").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(TextPartValue.getter(TextPartValue::url)).setter(TextPartValue.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DISPLAY_TEXT_FIELD, TEXT_BY_LOCALE_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TextPartValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String displayText;
    private final Map<String, String> textByLocale;
    private final String url;

    private TextPartValue(BuilderImpl builder) {
        this.type = builder.type;
        this.displayText = builder.displayText;
        this.textByLocale = builder.textByLocale;
        this.url = builder.url;
    }

    public final TextPartType type() {
        return TextPartType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String displayText() {
        return this.displayText;
    }

    public final Map<LocaleCode, String> textByLocale() {
        return TextByLocaleCopier.copyStringToEnum(this.textByLocale);
    }

    public final boolean hasTextByLocale() {
        return this.textByLocale != null && !(this.textByLocale instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> textByLocaleAsStrings() {
        return this.textByLocale;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayText());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextByLocale() ? this.textByLocaleAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextPartValue)) {
            return false;
        }
        TextPartValue other = (TextPartValue)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.displayText(), other.displayText()) && this.hasTextByLocale() == other.hasTextByLocale() && Objects.equals(this.textByLocaleAsStrings(), other.textByLocaleAsStrings()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"TextPartValue").add("Type", (Object)this.typeAsString()).add("DisplayText", (Object)this.displayText()).add("TextByLocale", this.hasTextByLocale() ? this.textByLocaleAsStrings() : null).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "displayText": {
                return Optional.ofNullable(clazz.cast(this.displayText()));
            }
            case "textByLocale": {
                return Optional.ofNullable(clazz.cast(this.textByLocaleAsStrings()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("displayText", DISPLAY_TEXT_FIELD);
        map.put("textByLocale", TEXT_BY_LOCALE_FIELD);
        map.put("url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextPartValue, T> g) {
        return obj -> g.apply((TextPartValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String displayText;
        private Map<String, String> textByLocale = DefaultSdkAutoConstructMap.getInstance();
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(TextPartValue model) {
            this.type(model.type);
            this.displayText(model.displayText);
            this.textByLocaleWithStrings(model.textByLocale);
            this.url(model.url);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TextPartType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDisplayText() {
            return this.displayText;
        }

        public final void setDisplayText(String displayText) {
            this.displayText = displayText;
        }

        @Override
        public final Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public final Map<String, String> getTextByLocale() {
            if (this.textByLocale instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.textByLocale;
        }

        public final void setTextByLocale(Map<String, String> textByLocale) {
            this.textByLocale = TextByLocaleCopier.copy(textByLocale);
        }

        @Override
        public final Builder textByLocaleWithStrings(Map<String, String> textByLocale) {
            this.textByLocale = TextByLocaleCopier.copy(textByLocale);
            return this;
        }

        @Override
        public final Builder textByLocale(Map<LocaleCode, String> textByLocale) {
            this.textByLocale = TextByLocaleCopier.copyEnumToString(textByLocale);
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public TextPartValue build() {
            return new TextPartValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextPartValue> {
        public Builder type(String var1);

        public Builder type(TextPartType var1);

        public Builder displayText(String var1);

        public Builder textByLocaleWithStrings(Map<String, String> var1);

        public Builder textByLocale(Map<LocaleCode, String> var1);

        public Builder url(String var1);
    }
}

