/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationEventOverview;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationEventsCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedNotificationEventsResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListManagedNotificationEventsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListManagedNotificationEventsResponse.getter(ListManagedNotificationEventsResponse::nextToken)).setter(ListManagedNotificationEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ManagedNotificationEventOverview>> MANAGED_NOTIFICATION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedNotificationEvents").getter(ListManagedNotificationEventsResponse.getter(ListManagedNotificationEventsResponse::managedNotificationEvents)).setter(ListManagedNotificationEventsResponse.setter(Builder::managedNotificationEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedNotificationEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedNotificationEventOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MANAGED_NOTIFICATION_EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedNotificationEventsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ManagedNotificationEventOverview> managedNotificationEvents;

    private ListManagedNotificationEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.managedNotificationEvents = builder.managedNotificationEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasManagedNotificationEvents() {
        return this.managedNotificationEvents != null && !(this.managedNotificationEvents instanceof SdkAutoConstructList);
    }

    public final List<ManagedNotificationEventOverview> managedNotificationEvents() {
        return this.managedNotificationEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedNotificationEvents() ? this.managedNotificationEvents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedNotificationEventsResponse)) {
            return false;
        }
        ListManagedNotificationEventsResponse other = (ListManagedNotificationEventsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasManagedNotificationEvents() == other.hasManagedNotificationEvents() && Objects.equals(this.managedNotificationEvents(), other.managedNotificationEvents());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedNotificationEventsResponse").add("NextToken", (Object)this.nextToken()).add("ManagedNotificationEvents", this.hasManagedNotificationEvents() ? this.managedNotificationEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "managedNotificationEvents": {
                return Optional.ofNullable(clazz.cast(this.managedNotificationEvents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("managedNotificationEvents", MANAGED_NOTIFICATION_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedNotificationEventsResponse, T> g) {
        return obj -> g.apply((ListManagedNotificationEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ManagedNotificationEventOverview> managedNotificationEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedNotificationEventsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.managedNotificationEvents(model.managedNotificationEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ManagedNotificationEventOverview.Builder> getManagedNotificationEvents() {
            List<ManagedNotificationEventOverview.Builder> result = ManagedNotificationEventsCopier.copyToBuilder(this.managedNotificationEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedNotificationEvents(Collection<ManagedNotificationEventOverview.BuilderImpl> managedNotificationEvents) {
            this.managedNotificationEvents = ManagedNotificationEventsCopier.copyFromBuilder(managedNotificationEvents);
        }

        @Override
        public final Builder managedNotificationEvents(Collection<ManagedNotificationEventOverview> managedNotificationEvents) {
            this.managedNotificationEvents = ManagedNotificationEventsCopier.copy(managedNotificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedNotificationEvents(ManagedNotificationEventOverview ... managedNotificationEvents) {
            this.managedNotificationEvents(Arrays.asList(managedNotificationEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedNotificationEvents(Consumer<ManagedNotificationEventOverview.Builder> ... managedNotificationEvents) {
            this.managedNotificationEvents(Stream.of(managedNotificationEvents).map(c -> (ManagedNotificationEventOverview)((ManagedNotificationEventOverview.Builder)ManagedNotificationEventOverview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListManagedNotificationEventsResponse build() {
            return new ListManagedNotificationEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedNotificationEventsResponse> {
        public Builder nextToken(String var1);

        public Builder managedNotificationEvents(Collection<ManagedNotificationEventOverview> var1);

        public Builder managedNotificationEvents(ManagedNotificationEventOverview ... var1);

        public Builder managedNotificationEvents(Consumer<ManagedNotificationEventOverview.Builder> ... var1);
    }
}

