/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsAsyncClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse;
import software.amazon.awssdk.services.notifications.model.NotificationHubOverview;

public class ListNotificationHubsPublisher
implements SdkPublisher<ListNotificationHubsResponse> {
    private final NotificationsAsyncClient client;
    private final ListNotificationHubsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotificationHubsPublisher(NotificationsAsyncClient client, ListNotificationHubsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotificationHubsPublisher(NotificationsAsyncClient client, ListNotificationHubsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotificationHubsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotificationHubsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotificationHubOverview> notificationHubs() {
        Function<ListNotificationHubsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationHubs() != null) {
                return response.notificationHubs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotificationHubsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotificationHubsResponseFetcher
    implements AsyncPageFetcher<ListNotificationHubsResponse> {
        private ListNotificationHubsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationHubsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotificationHubsResponse> nextPage(ListNotificationHubsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationHubsPublisher.this.client.listNotificationHubs(ListNotificationHubsPublisher.this.firstRequest);
            }
            return ListNotificationHubsPublisher.this.client.listNotificationHubs((ListNotificationHubsRequest)((Object)ListNotificationHubsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

