/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedNotificationChildEventOverview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedNotificationChildEventOverview> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ManagedNotificationChildEventOverview.getter(ManagedNotificationChildEventOverview::arn)).setter(ManagedNotificationChildEventOverview.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedNotificationConfigurationArn").getter(ManagedNotificationChildEventOverview.getter(ManagedNotificationChildEventOverview::managedNotificationConfigurationArn)).setter(ManagedNotificationChildEventOverview.setter(Builder::managedNotificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedNotificationConfigurationArn").build()}).build();
    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedAccount").getter(ManagedNotificationChildEventOverview.getter(ManagedNotificationChildEventOverview::relatedAccount)).setter(ManagedNotificationChildEventOverview.setter(Builder::relatedAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedAccount").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ManagedNotificationChildEventOverview.getter(ManagedNotificationChildEventOverview::creationTime)).setter(ManagedNotificationChildEventOverview.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ManagedNotificationChildEventSummary> CHILD_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("childEvent").getter(ManagedNotificationChildEventOverview.getter(ManagedNotificationChildEventOverview::childEvent)).setter(ManagedNotificationChildEventOverview.setter(Builder::childEvent)).constructor(ManagedNotificationChildEventSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childEvent").build()}).build();
    private static final SdkField<String> AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregateManagedNotificationEventArn").getter(ManagedNotificationChildEventOverview.getter(ManagedNotificationChildEventOverview::aggregateManagedNotificationEventArn)).setter(ManagedNotificationChildEventOverview.setter(Builder::aggregateManagedNotificationEventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateManagedNotificationEventArn").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationalUnitId").getter(ManagedNotificationChildEventOverview.getter(ManagedNotificationChildEventOverview::organizationalUnitId)).setter(ManagedNotificationChildEventOverview.setter(Builder::organizationalUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD, RELATED_ACCOUNT_FIELD, CREATION_TIME_FIELD, CHILD_EVENT_FIELD, AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedNotificationChildEventOverview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String managedNotificationConfigurationArn;
    private final String relatedAccount;
    private final Instant creationTime;
    private final ManagedNotificationChildEventSummary childEvent;
    private final String aggregateManagedNotificationEventArn;
    private final String organizationalUnitId;

    private ManagedNotificationChildEventOverview(BuilderImpl builder) {
        this.arn = builder.arn;
        this.managedNotificationConfigurationArn = builder.managedNotificationConfigurationArn;
        this.relatedAccount = builder.relatedAccount;
        this.creationTime = builder.creationTime;
        this.childEvent = builder.childEvent;
        this.aggregateManagedNotificationEventArn = builder.aggregateManagedNotificationEventArn;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String managedNotificationConfigurationArn() {
        return this.managedNotificationConfigurationArn;
    }

    public final String relatedAccount() {
        return this.relatedAccount;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ManagedNotificationChildEventSummary childEvent() {
        return this.childEvent;
    }

    public final String aggregateManagedNotificationEventArn() {
        return this.aggregateManagedNotificationEventArn;
    }

    public final String organizationalUnitId() {
        return this.organizationalUnitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedNotificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.childEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateManagedNotificationEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationChildEventOverview)) {
            return false;
        }
        ManagedNotificationChildEventOverview other = (ManagedNotificationChildEventOverview)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.managedNotificationConfigurationArn(), other.managedNotificationConfigurationArn()) && Objects.equals(this.relatedAccount(), other.relatedAccount()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.childEvent(), other.childEvent()) && Objects.equals(this.aggregateManagedNotificationEventArn(), other.aggregateManagedNotificationEventArn()) && Objects.equals(this.organizationalUnitId(), other.organizationalUnitId());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedNotificationChildEventOverview").add("Arn", (Object)this.arn()).add("ManagedNotificationConfigurationArn", (Object)this.managedNotificationConfigurationArn()).add("RelatedAccount", (Object)this.relatedAccount()).add("CreationTime", (Object)this.creationTime()).add("ChildEvent", (Object)this.childEvent()).add("AggregateManagedNotificationEventArn", (Object)this.aggregateManagedNotificationEventArn()).add("OrganizationalUnitId", (Object)this.organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "managedNotificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.managedNotificationConfigurationArn()));
            }
            case "relatedAccount": {
                return Optional.ofNullable(clazz.cast(this.relatedAccount()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "childEvent": {
                return Optional.ofNullable(clazz.cast(this.childEvent()));
            }
            case "aggregateManagedNotificationEventArn": {
                return Optional.ofNullable(clazz.cast(this.aggregateManagedNotificationEventArn()));
            }
            case "organizationalUnitId": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("managedNotificationConfigurationArn", MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("childEvent", CHILD_EVENT_FIELD);
        map.put("aggregateManagedNotificationEventArn", AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationChildEventOverview, T> g) {
        return obj -> g.apply((ManagedNotificationChildEventOverview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String managedNotificationConfigurationArn;
        private String relatedAccount;
        private Instant creationTime;
        private ManagedNotificationChildEventSummary childEvent;
        private String aggregateManagedNotificationEventArn;
        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationChildEventOverview model) {
            this.arn(model.arn);
            this.managedNotificationConfigurationArn(model.managedNotificationConfigurationArn);
            this.relatedAccount(model.relatedAccount);
            this.creationTime(model.creationTime);
            this.childEvent(model.childEvent);
            this.aggregateManagedNotificationEventArn(model.aggregateManagedNotificationEventArn);
            this.organizationalUnitId(model.organizationalUnitId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getManagedNotificationConfigurationArn() {
            return this.managedNotificationConfigurationArn;
        }

        public final void setManagedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
        }

        @Override
        public final Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        public final String getRelatedAccount() {
            return this.relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ManagedNotificationChildEventSummary.Builder getChildEvent() {
            return this.childEvent != null ? this.childEvent.toBuilder() : null;
        }

        public final void setChildEvent(ManagedNotificationChildEventSummary.BuilderImpl childEvent) {
            this.childEvent = childEvent != null ? childEvent.build() : null;
        }

        @Override
        public final Builder childEvent(ManagedNotificationChildEventSummary childEvent) {
            this.childEvent = childEvent;
            return this;
        }

        public final String getAggregateManagedNotificationEventArn() {
            return this.aggregateManagedNotificationEventArn;
        }

        public final void setAggregateManagedNotificationEventArn(String aggregateManagedNotificationEventArn) {
            this.aggregateManagedNotificationEventArn = aggregateManagedNotificationEventArn;
        }

        @Override
        public final Builder aggregateManagedNotificationEventArn(String aggregateManagedNotificationEventArn) {
            this.aggregateManagedNotificationEventArn = aggregateManagedNotificationEventArn;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public ManagedNotificationChildEventOverview build() {
            return new ManagedNotificationChildEventOverview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedNotificationChildEventOverview> {
        public Builder arn(String var1);

        public Builder managedNotificationConfigurationArn(String var1);

        public Builder relatedAccount(String var1);

        public Builder creationTime(Instant var1);

        public Builder childEvent(ManagedNotificationChildEventSummary var1);

        default public Builder childEvent(Consumer<ManagedNotificationChildEventSummary.Builder> childEvent) {
            return this.childEvent((ManagedNotificationChildEventSummary)((ManagedNotificationChildEventSummary.Builder)ManagedNotificationChildEventSummary.builder().applyMutation(childEvent)).build());
        }

        public Builder aggregateManagedNotificationEventArn(String var1);

        public Builder organizationalUnitId(String var1);
    }
}

