/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationConfigurationStructure;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationConfigurationsCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedNotificationConfigurationsResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListManagedNotificationConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListManagedNotificationConfigurationsResponse.getter(ListManagedNotificationConfigurationsResponse::nextToken)).setter(ListManagedNotificationConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ManagedNotificationConfigurationStructure>> MANAGED_NOTIFICATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedNotificationConfigurations").getter(ListManagedNotificationConfigurationsResponse.getter(ListManagedNotificationConfigurationsResponse::managedNotificationConfigurations)).setter(ListManagedNotificationConfigurationsResponse.setter(Builder::managedNotificationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedNotificationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedNotificationConfigurationStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MANAGED_NOTIFICATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedNotificationConfigurationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ManagedNotificationConfigurationStructure> managedNotificationConfigurations;

    private ListManagedNotificationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.managedNotificationConfigurations = builder.managedNotificationConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasManagedNotificationConfigurations() {
        return this.managedNotificationConfigurations != null && !(this.managedNotificationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ManagedNotificationConfigurationStructure> managedNotificationConfigurations() {
        return this.managedNotificationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedNotificationConfigurations() ? this.managedNotificationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedNotificationConfigurationsResponse)) {
            return false;
        }
        ListManagedNotificationConfigurationsResponse other = (ListManagedNotificationConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasManagedNotificationConfigurations() == other.hasManagedNotificationConfigurations() && Objects.equals(this.managedNotificationConfigurations(), other.managedNotificationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedNotificationConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("ManagedNotificationConfigurations", this.hasManagedNotificationConfigurations() ? this.managedNotificationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "managedNotificationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.managedNotificationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("managedNotificationConfigurations", MANAGED_NOTIFICATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedNotificationConfigurationsResponse, T> g) {
        return obj -> g.apply((ListManagedNotificationConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ManagedNotificationConfigurationStructure> managedNotificationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedNotificationConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.managedNotificationConfigurations(model.managedNotificationConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ManagedNotificationConfigurationStructure.Builder> getManagedNotificationConfigurations() {
            List<ManagedNotificationConfigurationStructure.Builder> result = ManagedNotificationConfigurationsCopier.copyToBuilder(this.managedNotificationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedNotificationConfigurations(Collection<ManagedNotificationConfigurationStructure.BuilderImpl> managedNotificationConfigurations) {
            this.managedNotificationConfigurations = ManagedNotificationConfigurationsCopier.copyFromBuilder(managedNotificationConfigurations);
        }

        @Override
        public final Builder managedNotificationConfigurations(Collection<ManagedNotificationConfigurationStructure> managedNotificationConfigurations) {
            this.managedNotificationConfigurations = ManagedNotificationConfigurationsCopier.copy(managedNotificationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedNotificationConfigurations(ManagedNotificationConfigurationStructure ... managedNotificationConfigurations) {
            this.managedNotificationConfigurations(Arrays.asList(managedNotificationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedNotificationConfigurations(Consumer<ManagedNotificationConfigurationStructure.Builder> ... managedNotificationConfigurations) {
            this.managedNotificationConfigurations(Stream.of(managedNotificationConfigurations).map(c -> (ManagedNotificationConfigurationStructure)((ManagedNotificationConfigurationStructure.Builder)ManagedNotificationConfigurationStructure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListManagedNotificationConfigurationsResponse build() {
            return new ListManagedNotificationConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedNotificationConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder managedNotificationConfigurations(Collection<ManagedNotificationConfigurationStructure> var1);

        public Builder managedNotificationConfigurations(ManagedNotificationConfigurationStructure ... var1);

        public Builder managedNotificationConfigurations(Consumer<ManagedNotificationConfigurationStructure.Builder> ... var1);
    }
}

