/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.NotificationHubOverview;
import software.amazon.awssdk.services.notifications.model.NotificationHubsCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationHubsResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListNotificationHubsResponse> {
    private static final SdkField<List<NotificationHubOverview>> NOTIFICATION_HUBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationHubs").getter(ListNotificationHubsResponse.getter(ListNotificationHubsResponse::notificationHubs)).setter(ListNotificationHubsResponse.setter(Builder::notificationHubs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationHubs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationHubOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNotificationHubsResponse.getter(ListNotificationHubsResponse::nextToken)).setter(ListNotificationHubsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_HUBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotificationHubsResponse.memberNameToFieldInitializer();
    private final List<NotificationHubOverview> notificationHubs;
    private final String nextToken;

    private ListNotificationHubsResponse(BuilderImpl builder) {
        super(builder);
        this.notificationHubs = builder.notificationHubs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNotificationHubs() {
        return this.notificationHubs != null && !(this.notificationHubs instanceof SdkAutoConstructList);
    }

    public final List<NotificationHubOverview> notificationHubs() {
        return this.notificationHubs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationHubs() ? this.notificationHubs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationHubsResponse)) {
            return false;
        }
        ListNotificationHubsResponse other = (ListNotificationHubsResponse)((Object)obj);
        return this.hasNotificationHubs() == other.hasNotificationHubs() && Objects.equals(this.notificationHubs(), other.notificationHubs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotificationHubsResponse").add("NotificationHubs", this.hasNotificationHubs() ? this.notificationHubs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notificationHubs": {
                return Optional.ofNullable(clazz.cast(this.notificationHubs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("notificationHubs", NOTIFICATION_HUBS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationHubsResponse, T> g) {
        return obj -> g.apply((ListNotificationHubsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private List<NotificationHubOverview> notificationHubs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationHubsResponse model) {
            super(model);
            this.notificationHubs(model.notificationHubs);
            this.nextToken(model.nextToken);
        }

        public final List<NotificationHubOverview.Builder> getNotificationHubs() {
            List<NotificationHubOverview.Builder> result = NotificationHubsCopier.copyToBuilder(this.notificationHubs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationHubs(Collection<NotificationHubOverview.BuilderImpl> notificationHubs) {
            this.notificationHubs = NotificationHubsCopier.copyFromBuilder(notificationHubs);
        }

        @Override
        public final Builder notificationHubs(Collection<NotificationHubOverview> notificationHubs) {
            this.notificationHubs = NotificationHubsCopier.copy(notificationHubs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationHubs(NotificationHubOverview ... notificationHubs) {
            this.notificationHubs(Arrays.asList(notificationHubs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationHubs(Consumer<NotificationHubOverview.Builder> ... notificationHubs) {
            this.notificationHubs(Stream.of(notificationHubs).map(c -> (NotificationHubOverview)((NotificationHubOverview.Builder)NotificationHubOverview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNotificationHubsResponse build() {
            return new ListNotificationHubsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationHubsResponse> {
        public Builder notificationHubs(Collection<NotificationHubOverview> var1);

        public Builder notificationHubs(NotificationHubOverview ... var1);

        public Builder notificationHubs(Consumer<NotificationHubOverview.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

