/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsAsyncClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse;
import software.amazon.awssdk.services.notifications.model.NotificationEventOverview;

public class ListNotificationEventsPublisher
implements SdkPublisher<ListNotificationEventsResponse> {
    private final NotificationsAsyncClient client;
    private final ListNotificationEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotificationEventsPublisher(NotificationsAsyncClient client, ListNotificationEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotificationEventsPublisher(NotificationsAsyncClient client, ListNotificationEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotificationEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotificationEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotificationEventOverview> notificationEvents() {
        Function<ListNotificationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationEvents() != null) {
                return response.notificationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotificationEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotificationEventsResponseFetcher
    implements AsyncPageFetcher<ListNotificationEventsResponse> {
        private ListNotificationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotificationEventsResponse> nextPage(ListNotificationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationEventsPublisher.this.client.listNotificationEvents(ListNotificationEventsPublisher.this.firstRequest);
            }
            return ListNotificationEventsPublisher.this.client.listNotificationEvents((ListNotificationEventsRequest)((Object)ListNotificationEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

