/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaElementType {
    IMAGE("IMAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaElementType> VALUE_MAP;
    private final String value;

    private MediaElementType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaElementType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaElementType> knownValues() {
        EnumSet<MediaElementType> knownValues = EnumSet.allOf(MediaElementType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaElementType.class, MediaElementType::toString);
    }
}

