/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.EventRuleStructure;
import software.amazon.awssdk.services.notifications.model.EventRulesCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventRulesResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListEventRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEventRulesResponse.getter(ListEventRulesResponse::nextToken)).setter(ListEventRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<EventRuleStructure>> EVENT_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventRules").getter(ListEventRulesResponse.getter(ListEventRulesResponse::eventRules)).setter(ListEventRulesResponse.setter(Builder::eventRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventRuleStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, EVENT_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEventRulesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<EventRuleStructure> eventRules;

    private ListEventRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.eventRules = builder.eventRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEventRules() {
        return this.eventRules != null && !(this.eventRules instanceof SdkAutoConstructList);
    }

    public final List<EventRuleStructure> eventRules() {
        return this.eventRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventRules() ? this.eventRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventRulesResponse)) {
            return false;
        }
        ListEventRulesResponse other = (ListEventRulesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEventRules() == other.hasEventRules() && Objects.equals(this.eventRules(), other.eventRules());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventRulesResponse").add("NextToken", (Object)this.nextToken()).add("EventRules", this.hasEventRules() ? this.eventRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "eventRules": {
                return Optional.ofNullable(clazz.cast(this.eventRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("eventRules", EVENT_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventRulesResponse, T> g) {
        return obj -> g.apply((ListEventRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<EventRuleStructure> eventRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventRulesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.eventRules(model.eventRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EventRuleStructure.Builder> getEventRules() {
            List<EventRuleStructure.Builder> result = EventRulesCopier.copyToBuilder(this.eventRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventRules(Collection<EventRuleStructure.BuilderImpl> eventRules) {
            this.eventRules = EventRulesCopier.copyFromBuilder(eventRules);
        }

        @Override
        public final Builder eventRules(Collection<EventRuleStructure> eventRules) {
            this.eventRules = EventRulesCopier.copy(eventRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventRules(EventRuleStructure ... eventRules) {
            this.eventRules(Arrays.asList(eventRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventRules(Consumer<EventRuleStructure.Builder> ... eventRules) {
            this.eventRules(Stream.of(eventRules).map(c -> (EventRuleStructure)((EventRuleStructure.Builder)EventRuleStructure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEventRulesResponse build() {
            return new ListEventRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventRulesResponse> {
        public Builder nextToken(String var1);

        public Builder eventRules(Collection<EventRuleStructure> var1);

        public Builder eventRules(EventRuleStructure ... var1);

        public Builder eventRules(Consumer<EventRuleStructure.Builder> ... var1);
    }
}

