/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.ChannelAssociationOverrideOption;
import software.amazon.awssdk.services.notifications.model.ChannelType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedNotificationChannelAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedNotificationChannelAssociationSummary> {
    private static final SdkField<String> CHANNEL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelIdentifier").getter(ManagedNotificationChannelAssociationSummary.getter(ManagedNotificationChannelAssociationSummary::channelIdentifier)).setter(ManagedNotificationChannelAssociationSummary.setter(Builder::channelIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelIdentifier").build()}).build();
    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelType").getter(ManagedNotificationChannelAssociationSummary.getter(ManagedNotificationChannelAssociationSummary::channelTypeAsString)).setter(ManagedNotificationChannelAssociationSummary.setter(Builder::channelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelType").build()}).build();
    private static final SdkField<String> OVERRIDE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideOption").getter(ManagedNotificationChannelAssociationSummary.getter(ManagedNotificationChannelAssociationSummary::overrideOptionAsString)).setter(ManagedNotificationChannelAssociationSummary.setter(Builder::overrideOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_IDENTIFIER_FIELD, CHANNEL_TYPE_FIELD, OVERRIDE_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedNotificationChannelAssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channelIdentifier;
    private final String channelType;
    private final String overrideOption;

    private ManagedNotificationChannelAssociationSummary(BuilderImpl builder) {
        this.channelIdentifier = builder.channelIdentifier;
        this.channelType = builder.channelType;
        this.overrideOption = builder.overrideOption;
    }

    public final String channelIdentifier() {
        return this.channelIdentifier;
    }

    public final ChannelType channelType() {
        return ChannelType.fromValue(this.channelType);
    }

    public final String channelTypeAsString() {
        return this.channelType;
    }

    public final ChannelAssociationOverrideOption overrideOption() {
        return ChannelAssociationOverrideOption.fromValue(this.overrideOption);
    }

    public final String overrideOptionAsString() {
        return this.overrideOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationChannelAssociationSummary)) {
            return false;
        }
        ManagedNotificationChannelAssociationSummary other = (ManagedNotificationChannelAssociationSummary)obj;
        return Objects.equals(this.channelIdentifier(), other.channelIdentifier()) && Objects.equals(this.channelTypeAsString(), other.channelTypeAsString()) && Objects.equals(this.overrideOptionAsString(), other.overrideOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedNotificationChannelAssociationSummary").add("ChannelIdentifier", (Object)this.channelIdentifier()).add("ChannelType", (Object)this.channelTypeAsString()).add("OverrideOption", (Object)this.overrideOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelIdentifier": {
                return Optional.ofNullable(clazz.cast(this.channelIdentifier()));
            }
            case "channelType": {
                return Optional.ofNullable(clazz.cast(this.channelTypeAsString()));
            }
            case "overrideOption": {
                return Optional.ofNullable(clazz.cast(this.overrideOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("channelIdentifier", CHANNEL_IDENTIFIER_FIELD);
        map.put("channelType", CHANNEL_TYPE_FIELD);
        map.put("overrideOption", OVERRIDE_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationChannelAssociationSummary, T> g) {
        return obj -> g.apply((ManagedNotificationChannelAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelIdentifier;
        private String channelType;
        private String overrideOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationChannelAssociationSummary model) {
            this.channelIdentifier(model.channelIdentifier);
            this.channelType(model.channelType);
            this.overrideOption(model.overrideOption);
        }

        public final String getChannelIdentifier() {
            return this.channelIdentifier;
        }

        public final void setChannelIdentifier(String channelIdentifier) {
            this.channelIdentifier = channelIdentifier;
        }

        @Override
        public final Builder channelIdentifier(String channelIdentifier) {
            this.channelIdentifier = channelIdentifier;
            return this;
        }

        public final String getChannelType() {
            return this.channelType;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final String getOverrideOption() {
            return this.overrideOption;
        }

        public final void setOverrideOption(String overrideOption) {
            this.overrideOption = overrideOption;
        }

        @Override
        public final Builder overrideOption(String overrideOption) {
            this.overrideOption = overrideOption;
            return this;
        }

        @Override
        public final Builder overrideOption(ChannelAssociationOverrideOption overrideOption) {
            this.overrideOption(overrideOption == null ? null : overrideOption.toString());
            return this;
        }

        public ManagedNotificationChannelAssociationSummary build() {
            return new ManagedNotificationChannelAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedNotificationChannelAssociationSummary> {
        public Builder channelIdentifier(String var1);

        public Builder channelType(String var1);

        public Builder channelType(ChannelType var1);

        public Builder overrideOption(String var1);

        public Builder overrideOption(ChannelAssociationOverrideOption var1);
    }
}

