/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.EventRuleStructure;
import software.amazon.awssdk.services.notifications.model.ListEventRulesRequest;
import software.amazon.awssdk.services.notifications.model.ListEventRulesResponse;

public class ListEventRulesIterable
implements SdkIterable<ListEventRulesResponse> {
    private final NotificationsClient client;
    private final ListEventRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventRulesIterable(NotificationsClient client, ListEventRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventRulesResponseFetcher();
    }

    public Iterator<ListEventRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventRuleStructure> eventRules() {
        Function<ListEventRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventRules() != null) {
                return response.eventRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventRulesResponseFetcher
    implements SyncPageFetcher<ListEventRulesResponse> {
        private ListEventRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListEventRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventRulesResponse nextPage(ListEventRulesResponse previousPage) {
            if (previousPage == null) {
                return ListEventRulesIterable.this.client.listEventRules(ListEventRulesIterable.this.firstRequest);
            }
            return ListEventRulesIterable.this.client.listEventRules((ListEventRulesRequest)((Object)ListEventRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

