/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.AccountContactType;
import software.amazon.awssdk.services.notifications.model.NotificationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateManagedNotificationAccountContactRequest
extends NotificationsRequest
implements ToCopyableBuilder<Builder, AssociateManagedNotificationAccountContactRequest> {
    private static final SdkField<String> CONTACT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactIdentifier").getter(AssociateManagedNotificationAccountContactRequest.getter(AssociateManagedNotificationAccountContactRequest::contactIdentifierAsString)).setter(AssociateManagedNotificationAccountContactRequest.setter(Builder::contactIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("contactIdentifier").build()}).build();
    private static final SdkField<String> MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedNotificationConfigurationArn").getter(AssociateManagedNotificationAccountContactRequest.getter(AssociateManagedNotificationAccountContactRequest::managedNotificationConfigurationArn)).setter(AssociateManagedNotificationAccountContactRequest.setter(Builder::managedNotificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedNotificationConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_IDENTIFIER_FIELD, MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateManagedNotificationAccountContactRequest.memberNameToFieldInitializer();
    private final String contactIdentifier;
    private final String managedNotificationConfigurationArn;

    private AssociateManagedNotificationAccountContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactIdentifier = builder.contactIdentifier;
        this.managedNotificationConfigurationArn = builder.managedNotificationConfigurationArn;
    }

    public final AccountContactType contactIdentifier() {
        return AccountContactType.fromValue(this.contactIdentifier);
    }

    public final String contactIdentifierAsString() {
        return this.contactIdentifier;
    }

    public final String managedNotificationConfigurationArn() {
        return this.managedNotificationConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactIdentifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedNotificationConfigurationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateManagedNotificationAccountContactRequest)) {
            return false;
        }
        AssociateManagedNotificationAccountContactRequest other = (AssociateManagedNotificationAccountContactRequest)((Object)obj);
        return Objects.equals(this.contactIdentifierAsString(), other.contactIdentifierAsString()) && Objects.equals(this.managedNotificationConfigurationArn(), other.managedNotificationConfigurationArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateManagedNotificationAccountContactRequest").add("ContactIdentifier", (Object)this.contactIdentifierAsString()).add("ManagedNotificationConfigurationArn", (Object)this.managedNotificationConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contactIdentifier": {
                return Optional.ofNullable(clazz.cast(this.contactIdentifierAsString()));
            }
            case "managedNotificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.managedNotificationConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("contactIdentifier", CONTACT_IDENTIFIER_FIELD);
        map.put("managedNotificationConfigurationArn", MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateManagedNotificationAccountContactRequest, T> g) {
        return obj -> g.apply((AssociateManagedNotificationAccountContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsRequest.BuilderImpl
    implements Builder {
        private String contactIdentifier;
        private String managedNotificationConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateManagedNotificationAccountContactRequest model) {
            super(model);
            this.contactIdentifier(model.contactIdentifier);
            this.managedNotificationConfigurationArn(model.managedNotificationConfigurationArn);
        }

        public final String getContactIdentifier() {
            return this.contactIdentifier;
        }

        public final void setContactIdentifier(String contactIdentifier) {
            this.contactIdentifier = contactIdentifier;
        }

        @Override
        public final Builder contactIdentifier(String contactIdentifier) {
            this.contactIdentifier = contactIdentifier;
            return this;
        }

        @Override
        public final Builder contactIdentifier(AccountContactType contactIdentifier) {
            this.contactIdentifier(contactIdentifier == null ? null : contactIdentifier.toString());
            return this;
        }

        public final String getManagedNotificationConfigurationArn() {
            return this.managedNotificationConfigurationArn;
        }

        public final void setManagedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
        }

        @Override
        public final Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateManagedNotificationAccountContactRequest build() {
            return new AssociateManagedNotificationAccountContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateManagedNotificationAccountContactRequest> {
        public Builder contactIdentifier(String var1);

        public Builder contactIdentifier(AccountContactType var1);

        public Builder managedNotificationConfigurationArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

