/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.notifications.model.AggregationEventType;
import software.amazon.awssdk.services.notifications.model.EventStatus;
import software.amazon.awssdk.services.notifications.model.MediaCopier;
import software.amazon.awssdk.services.notifications.model.MediaElement;
import software.amazon.awssdk.services.notifications.model.MessageComponents;
import software.amazon.awssdk.services.notifications.model.NotificationType;
import software.amazon.awssdk.services.notifications.model.SchemaVersion;
import software.amazon.awssdk.services.notifications.model.SourceEventMetadata;
import software.amazon.awssdk.services.notifications.model.TextPartValue;
import software.amazon.awssdk.services.notifications.model.TextPartsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationEvent> {
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaVersion").getter(NotificationEvent.getter(NotificationEvent::schemaVersionAsString)).setter(NotificationEvent.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(NotificationEvent.getter(NotificationEvent::id)).setter(NotificationEvent.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<SourceEventMetadata> SOURCE_EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceEventMetadata").getter(NotificationEvent.getter(NotificationEvent::sourceEventMetadata)).setter(NotificationEvent.setter(Builder::sourceEventMetadata)).constructor(SourceEventMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventMetadata").build()}).build();
    private static final SdkField<MessageComponents> MESSAGE_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageComponents").getter(NotificationEvent.getter(NotificationEvent::messageComponents)).setter(NotificationEvent.setter(Builder::messageComponents)).constructor(MessageComponents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageComponents").build()}).build();
    private static final SdkField<String> SOURCE_EVENT_DETAIL_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceEventDetailUrl").getter(NotificationEvent.getter(NotificationEvent::sourceEventDetailUrl)).setter(NotificationEvent.setter(Builder::sourceEventDetailUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventDetailUrl").build()}).build();
    private static final SdkField<String> SOURCE_EVENT_DETAIL_URL_DISPLAY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceEventDetailUrlDisplayText").getter(NotificationEvent.getter(NotificationEvent::sourceEventDetailUrlDisplayText)).setter(NotificationEvent.setter(Builder::sourceEventDetailUrlDisplayText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventDetailUrlDisplayText").build()}).build();
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationType").getter(NotificationEvent.getter(NotificationEvent::notificationTypeAsString)).setter(NotificationEvent.setter(Builder::notificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationType").build()}).build();
    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventStatus").getter(NotificationEvent.getter(NotificationEvent::eventStatusAsString)).setter(NotificationEvent.setter(Builder::eventStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatus").build()}).build();
    private static final SdkField<String> AGGREGATION_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationEventType").getter(NotificationEvent.getter(NotificationEvent::aggregationEventTypeAsString)).setter(NotificationEvent.setter(Builder::aggregationEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationEventType").build()}).build();
    private static final SdkField<String> AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregateNotificationEventArn").getter(NotificationEvent.getter(NotificationEvent::aggregateNotificationEventArn)).setter(NotificationEvent.setter(Builder::aggregateNotificationEventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateNotificationEventArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(NotificationEvent.getter(NotificationEvent::startTime)).setter(NotificationEvent.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(NotificationEvent.getter(NotificationEvent::endTime)).setter(NotificationEvent.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, TextPartValue>> TEXT_PARTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("textParts").getter(NotificationEvent.getter(NotificationEvent::textParts)).setter(NotificationEvent.setter(Builder::textParts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textParts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextPartValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<MediaElement>> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("media").getter(NotificationEvent.getter(NotificationEvent::media)).setter(NotificationEvent.setter(Builder::media)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("media").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD, ID_FIELD, SOURCE_EVENT_METADATA_FIELD, MESSAGE_COMPONENTS_FIELD, SOURCE_EVENT_DETAIL_URL_FIELD, SOURCE_EVENT_DETAIL_URL_DISPLAY_TEXT_FIELD, NOTIFICATION_TYPE_FIELD, EVENT_STATUS_FIELD, AGGREGATION_EVENT_TYPE_FIELD, AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, TEXT_PARTS_FIELD, MEDIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotificationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String schemaVersion;
    private final String id;
    private final SourceEventMetadata sourceEventMetadata;
    private final MessageComponents messageComponents;
    private final String sourceEventDetailUrl;
    private final String sourceEventDetailUrlDisplayText;
    private final String notificationType;
    private final String eventStatus;
    private final String aggregationEventType;
    private final String aggregateNotificationEventArn;
    private final Instant startTime;
    private final Instant endTime;
    private final Map<String, TextPartValue> textParts;
    private final List<MediaElement> media;

    private NotificationEvent(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.id = builder.id;
        this.sourceEventMetadata = builder.sourceEventMetadata;
        this.messageComponents = builder.messageComponents;
        this.sourceEventDetailUrl = builder.sourceEventDetailUrl;
        this.sourceEventDetailUrlDisplayText = builder.sourceEventDetailUrlDisplayText;
        this.notificationType = builder.notificationType;
        this.eventStatus = builder.eventStatus;
        this.aggregationEventType = builder.aggregationEventType;
        this.aggregateNotificationEventArn = builder.aggregateNotificationEventArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.textParts = builder.textParts;
        this.media = builder.media;
    }

    public final SchemaVersion schemaVersion() {
        return SchemaVersion.fromValue(this.schemaVersion);
    }

    public final String schemaVersionAsString() {
        return this.schemaVersion;
    }

    public final String id() {
        return this.id;
    }

    public final SourceEventMetadata sourceEventMetadata() {
        return this.sourceEventMetadata;
    }

    public final MessageComponents messageComponents() {
        return this.messageComponents;
    }

    public final String sourceEventDetailUrl() {
        return this.sourceEventDetailUrl;
    }

    public final String sourceEventDetailUrlDisplayText() {
        return this.sourceEventDetailUrlDisplayText;
    }

    public final NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public final String notificationTypeAsString() {
        return this.notificationType;
    }

    public final EventStatus eventStatus() {
        return EventStatus.fromValue(this.eventStatus);
    }

    public final String eventStatusAsString() {
        return this.eventStatus;
    }

    public final AggregationEventType aggregationEventType() {
        return AggregationEventType.fromValue(this.aggregationEventType);
    }

    public final String aggregationEventTypeAsString() {
        return this.aggregationEventType;
    }

    public final String aggregateNotificationEventArn() {
        return this.aggregateNotificationEventArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasTextParts() {
        return this.textParts != null && !(this.textParts instanceof SdkAutoConstructMap);
    }

    public final Map<String, TextPartValue> textParts() {
        return this.textParts;
    }

    public final boolean hasMedia() {
        return this.media != null && !(this.media instanceof SdkAutoConstructList);
    }

    public final List<MediaElement> media() {
        return this.media;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageComponents());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEventDetailUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEventDetailUrlDisplayText());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateNotificationEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextParts() ? this.textParts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMedia() ? this.media() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationEvent)) {
            return false;
        }
        NotificationEvent other = (NotificationEvent)obj;
        return Objects.equals(this.schemaVersionAsString(), other.schemaVersionAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.sourceEventMetadata(), other.sourceEventMetadata()) && Objects.equals(this.messageComponents(), other.messageComponents()) && Objects.equals(this.sourceEventDetailUrl(), other.sourceEventDetailUrl()) && Objects.equals(this.sourceEventDetailUrlDisplayText(), other.sourceEventDetailUrlDisplayText()) && Objects.equals(this.notificationTypeAsString(), other.notificationTypeAsString()) && Objects.equals(this.eventStatusAsString(), other.eventStatusAsString()) && Objects.equals(this.aggregationEventTypeAsString(), other.aggregationEventTypeAsString()) && Objects.equals(this.aggregateNotificationEventArn(), other.aggregateNotificationEventArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasTextParts() == other.hasTextParts() && Objects.equals(this.textParts(), other.textParts()) && this.hasMedia() == other.hasMedia() && Objects.equals(this.media(), other.media());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationEvent").add("SchemaVersion", (Object)this.schemaVersionAsString()).add("Id", (Object)this.id()).add("SourceEventMetadata", (Object)this.sourceEventMetadata()).add("MessageComponents", (Object)this.messageComponents()).add("SourceEventDetailUrl", (Object)this.sourceEventDetailUrl()).add("SourceEventDetailUrlDisplayText", (Object)this.sourceEventDetailUrlDisplayText()).add("NotificationType", (Object)this.notificationTypeAsString()).add("EventStatus", (Object)this.eventStatusAsString()).add("AggregationEventType", (Object)this.aggregationEventTypeAsString()).add("AggregateNotificationEventArn", (Object)this.aggregateNotificationEventArn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("TextParts", this.hasTextParts() ? this.textParts() : null).add("Media", this.hasMedia() ? this.media() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "sourceEventMetadata": {
                return Optional.ofNullable(clazz.cast(this.sourceEventMetadata()));
            }
            case "messageComponents": {
                return Optional.ofNullable(clazz.cast(this.messageComponents()));
            }
            case "sourceEventDetailUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceEventDetailUrl()));
            }
            case "sourceEventDetailUrlDisplayText": {
                return Optional.ofNullable(clazz.cast(this.sourceEventDetailUrlDisplayText()));
            }
            case "notificationType": {
                return Optional.ofNullable(clazz.cast(this.notificationTypeAsString()));
            }
            case "eventStatus": {
                return Optional.ofNullable(clazz.cast(this.eventStatusAsString()));
            }
            case "aggregationEventType": {
                return Optional.ofNullable(clazz.cast(this.aggregationEventTypeAsString()));
            }
            case "aggregateNotificationEventArn": {
                return Optional.ofNullable(clazz.cast(this.aggregateNotificationEventArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "textParts": {
                return Optional.ofNullable(clazz.cast(this.textParts()));
            }
            case "media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        map.put("id", ID_FIELD);
        map.put("sourceEventMetadata", SOURCE_EVENT_METADATA_FIELD);
        map.put("messageComponents", MESSAGE_COMPONENTS_FIELD);
        map.put("sourceEventDetailUrl", SOURCE_EVENT_DETAIL_URL_FIELD);
        map.put("sourceEventDetailUrlDisplayText", SOURCE_EVENT_DETAIL_URL_DISPLAY_TEXT_FIELD);
        map.put("notificationType", NOTIFICATION_TYPE_FIELD);
        map.put("eventStatus", EVENT_STATUS_FIELD);
        map.put("aggregationEventType", AGGREGATION_EVENT_TYPE_FIELD);
        map.put("aggregateNotificationEventArn", AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("textParts", TEXT_PARTS_FIELD);
        map.put("media", MEDIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationEvent, T> g) {
        return obj -> g.apply((NotificationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaVersion;
        private String id;
        private SourceEventMetadata sourceEventMetadata;
        private MessageComponents messageComponents;
        private String sourceEventDetailUrl;
        private String sourceEventDetailUrlDisplayText;
        private String notificationType;
        private String eventStatus;
        private String aggregationEventType;
        private String aggregateNotificationEventArn;
        private Instant startTime;
        private Instant endTime;
        private Map<String, TextPartValue> textParts = DefaultSdkAutoConstructMap.getInstance();
        private List<MediaElement> media = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationEvent model) {
            this.schemaVersion(model.schemaVersion);
            this.id(model.id);
            this.sourceEventMetadata(model.sourceEventMetadata);
            this.messageComponents(model.messageComponents);
            this.sourceEventDetailUrl(model.sourceEventDetailUrl);
            this.sourceEventDetailUrlDisplayText(model.sourceEventDetailUrlDisplayText);
            this.notificationType(model.notificationType);
            this.eventStatus(model.eventStatus);
            this.aggregationEventType(model.aggregationEventType);
            this.aggregateNotificationEventArn(model.aggregateNotificationEventArn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.textParts(model.textParts);
            this.media(model.media);
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public final Builder schemaVersion(SchemaVersion schemaVersion) {
            this.schemaVersion(schemaVersion == null ? null : schemaVersion.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final SourceEventMetadata.Builder getSourceEventMetadata() {
            return this.sourceEventMetadata != null ? this.sourceEventMetadata.toBuilder() : null;
        }

        public final void setSourceEventMetadata(SourceEventMetadata.BuilderImpl sourceEventMetadata) {
            this.sourceEventMetadata = sourceEventMetadata != null ? sourceEventMetadata.build() : null;
        }

        @Override
        public final Builder sourceEventMetadata(SourceEventMetadata sourceEventMetadata) {
            this.sourceEventMetadata = sourceEventMetadata;
            return this;
        }

        public final MessageComponents.Builder getMessageComponents() {
            return this.messageComponents != null ? this.messageComponents.toBuilder() : null;
        }

        public final void setMessageComponents(MessageComponents.BuilderImpl messageComponents) {
            this.messageComponents = messageComponents != null ? messageComponents.build() : null;
        }

        @Override
        public final Builder messageComponents(MessageComponents messageComponents) {
            this.messageComponents = messageComponents;
            return this;
        }

        public final String getSourceEventDetailUrl() {
            return this.sourceEventDetailUrl;
        }

        public final void setSourceEventDetailUrl(String sourceEventDetailUrl) {
            this.sourceEventDetailUrl = sourceEventDetailUrl;
        }

        @Override
        public final Builder sourceEventDetailUrl(String sourceEventDetailUrl) {
            this.sourceEventDetailUrl = sourceEventDetailUrl;
            return this;
        }

        public final String getSourceEventDetailUrlDisplayText() {
            return this.sourceEventDetailUrlDisplayText;
        }

        public final void setSourceEventDetailUrlDisplayText(String sourceEventDetailUrlDisplayText) {
            this.sourceEventDetailUrlDisplayText = sourceEventDetailUrlDisplayText;
        }

        @Override
        public final Builder sourceEventDetailUrlDisplayText(String sourceEventDetailUrlDisplayText) {
            this.sourceEventDetailUrlDisplayText = sourceEventDetailUrlDisplayText;
            return this;
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        public final String getEventStatus() {
            return this.eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(EventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final String getAggregationEventType() {
            return this.aggregationEventType;
        }

        public final void setAggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
        }

        @Override
        public final Builder aggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
            return this;
        }

        @Override
        public final Builder aggregationEventType(AggregationEventType aggregationEventType) {
            this.aggregationEventType(aggregationEventType == null ? null : aggregationEventType.toString());
            return this;
        }

        public final String getAggregateNotificationEventArn() {
            return this.aggregateNotificationEventArn;
        }

        public final void setAggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
        }

        @Override
        public final Builder aggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Map<String, TextPartValue.Builder> getTextParts() {
            Map<String, TextPartValue.Builder> result = TextPartsCopier.copyToBuilder(this.textParts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTextParts(Map<String, TextPartValue.BuilderImpl> textParts) {
            this.textParts = TextPartsCopier.copyFromBuilder(textParts);
        }

        @Override
        public final Builder textParts(Map<String, TextPartValue> textParts) {
            this.textParts = TextPartsCopier.copy(textParts);
            return this;
        }

        public final List<MediaElement.Builder> getMedia() {
            List<MediaElement.Builder> result = MediaCopier.copyToBuilder(this.media);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMedia(Collection<MediaElement.BuilderImpl> media) {
            this.media = MediaCopier.copyFromBuilder(media);
        }

        @Override
        public final Builder media(Collection<MediaElement> media) {
            this.media = MediaCopier.copy(media);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder media(MediaElement ... media) {
            this.media(Arrays.asList(media));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder media(Consumer<MediaElement.Builder> ... media) {
            this.media(Stream.of(media).map(c -> (MediaElement)((MediaElement.Builder)MediaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NotificationEvent build() {
            return new NotificationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationEvent> {
        public Builder schemaVersion(String var1);

        public Builder schemaVersion(SchemaVersion var1);

        public Builder id(String var1);

        public Builder sourceEventMetadata(SourceEventMetadata var1);

        default public Builder sourceEventMetadata(Consumer<SourceEventMetadata.Builder> sourceEventMetadata) {
            return this.sourceEventMetadata((SourceEventMetadata)((SourceEventMetadata.Builder)SourceEventMetadata.builder().applyMutation(sourceEventMetadata)).build());
        }

        public Builder messageComponents(MessageComponents var1);

        default public Builder messageComponents(Consumer<MessageComponents.Builder> messageComponents) {
            return this.messageComponents((MessageComponents)((MessageComponents.Builder)MessageComponents.builder().applyMutation(messageComponents)).build());
        }

        public Builder sourceEventDetailUrl(String var1);

        public Builder sourceEventDetailUrlDisplayText(String var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);

        public Builder eventStatus(String var1);

        public Builder eventStatus(EventStatus var1);

        public Builder aggregationEventType(String var1);

        public Builder aggregationEventType(AggregationEventType var1);

        public Builder aggregateNotificationEventArn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder textParts(Map<String, TextPartValue> var1);

        public Builder media(Collection<MediaElement> var1);

        public Builder media(MediaElement ... var1);

        public Builder media(Consumer<MediaElement.Builder> ... var1);
    }
}

