/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.NotificationsRequest;
import software.amazon.awssdk.services.notifications.model.RegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEventRuleRequest
extends NotificationsRequest
implements ToCopyableBuilder<Builder, CreateEventRuleRequest> {
    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationConfigurationArn").getter(CreateEventRuleRequest.getter(CreateEventRuleRequest::notificationConfigurationArn)).setter(CreateEventRuleRequest.setter(Builder::notificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(CreateEventRuleRequest.getter(CreateEventRuleRequest::source)).setter(CreateEventRuleRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(CreateEventRuleRequest.getter(CreateEventRuleRequest::eventType)).setter(CreateEventRuleRequest.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventPattern").getter(CreateEventRuleRequest.getter(CreateEventRuleRequest::eventPattern)).setter(CreateEventRuleRequest.setter(Builder::eventPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPattern").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(CreateEventRuleRequest.getter(CreateEventRuleRequest::regions)).setter(CreateEventRuleRequest.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_CONFIGURATION_ARN_FIELD, SOURCE_FIELD, EVENT_TYPE_FIELD, EVENT_PATTERN_FIELD, REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("eventType", EVENT_TYPE_FIELD);
            this.put("eventPattern", EVENT_PATTERN_FIELD);
            this.put("regions", REGIONS_FIELD);
        }
    });
    private final String notificationConfigurationArn;
    private final String source;
    private final String eventType;
    private final String eventPattern;
    private final List<String> regions;

    private CreateEventRuleRequest(BuilderImpl builder) {
        super(builder);
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.source = builder.source;
        this.eventType = builder.eventType;
        this.eventPattern = builder.eventPattern;
        this.regions = builder.regions;
    }

    public final String notificationConfigurationArn() {
        return this.notificationConfigurationArn;
    }

    public final String source() {
        return this.source;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final String eventPattern() {
        return this.eventPattern;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventRuleRequest)) {
            return false;
        }
        CreateEventRuleRequest other = (CreateEventRuleRequest)((Object)obj);
        return Objects.equals(this.notificationConfigurationArn(), other.notificationConfigurationArn()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.eventPattern(), other.eventPattern()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEventRuleRequest").add("NotificationConfigurationArn", (Object)this.notificationConfigurationArn()).add("Source", (Object)this.source()).add("EventType", (Object)this.eventType()).add("EventPattern", (Object)this.eventPattern()).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.notificationConfigurationArn()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "eventPattern": {
                return Optional.ofNullable(clazz.cast(this.eventPattern()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventRuleRequest, T> g) {
        return obj -> g.apply((CreateEventRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsRequest.BuilderImpl
    implements Builder {
        private String notificationConfigurationArn;
        private String source;
        private String eventType;
        private String eventPattern;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventRuleRequest model) {
            super(model);
            this.notificationConfigurationArn(model.notificationConfigurationArn);
            this.source(model.source);
            this.eventType(model.eventType);
            this.eventPattern(model.eventPattern);
            this.regions(model.regions);
        }

        public final String getNotificationConfigurationArn() {
            return this.notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getEventPattern() {
            return this.eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventRuleRequest build() {
            return new CreateEventRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEventRuleRequest> {
        public Builder notificationConfigurationArn(String var1);

        public Builder source(String var1);

        public Builder eventType(String var1);

        public Builder eventPattern(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

