/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaVersion {
    V1_0("v1.0"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaVersion> VALUE_MAP;
    private final String value;

    private SchemaVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaVersion> knownValues() {
        EnumSet<SchemaVersion> knownValues = EnumSet.allOf(SchemaVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaVersion.class, SchemaVersion::toString);
    }
}

