/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchProfileValidationState {
    VALIDATION_NOT_STARTED("VALIDATION_NOT_STARTED"),
    VALIDATION_IN_PROGRESS("VALIDATION_IN_PROGRESS"),
    VALIDATION_SUCCESS("VALIDATION_SUCCESS"),
    VALIDATION_FAILED("VALIDATION_FAILED"),
    VALIDATION_FAILED_INTERNAL_SERVER_ERROR("VALIDATION_FAILED_INTERNAL_SERVER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchProfileValidationState> VALUE_MAP;
    private final String value;

    private LaunchProfileValidationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchProfileValidationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchProfileValidationState> knownValues() {
        EnumSet<LaunchProfileValidationState> knownValues = EnumSet.allOf(LaunchProfileValidationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchProfileValidationState.class, LaunchProfileValidationState::toString);
    }
}

