/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum StreamingInstanceType {
    G4_DN_XLARGE("g4dn.xlarge"),

    G4_DN_2_XLARGE("g4dn.2xlarge"),

    G4_DN_4_XLARGE("g4dn.4xlarge"),

    G4_DN_8_XLARGE("g4dn.8xlarge"),

    G4_DN_12_XLARGE("g4dn.12xlarge"),

    G4_DN_16_XLARGE("g4dn.16xlarge"),

    G3_4_XLARGE("g3.4xlarge"),

    G3_S_XLARGE("g3s.xlarge"),

    G5_XLARGE("g5.xlarge"),

    G5_2_XLARGE("g5.2xlarge"),

    G5_4_XLARGE("g5.4xlarge"),

    G5_8_XLARGE("g5.8xlarge"),

    G5_16_XLARGE("g5.16xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamingInstanceType> VALUE_MAP = EnumUtils.uniqueIndex(StreamingInstanceType.class,
            StreamingInstanceType::toString);

    private final String value;

    private StreamingInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return StreamingInstanceType corresponding to the value
     */
    public static StreamingInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link StreamingInstanceType}s
     */
    public static Set<StreamingInstanceType> knownValues() {
        Set<StreamingInstanceType> knownValues = EnumSet.allOf(StreamingInstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
