/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.internal.UserAgentUtils;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse;
import software.amazon.awssdk.services.nimble.model.StudioComponent;

public class ListStudioComponentsPublisher
implements SdkPublisher<ListStudioComponentsResponse> {
    private final NimbleAsyncClient client;
    private final ListStudioComponentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStudioComponentsPublisher(NimbleAsyncClient client, ListStudioComponentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStudioComponentsPublisher(NimbleAsyncClient client, ListStudioComponentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStudioComponentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStudioComponentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StudioComponent> studioComponents() {
        Function<ListStudioComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.studioComponents() != null) {
                return response.studioComponents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStudioComponentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStudioComponentsResponseFetcher
    implements AsyncPageFetcher<ListStudioComponentsResponse> {
        private ListStudioComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListStudioComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStudioComponentsResponse> nextPage(ListStudioComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListStudioComponentsPublisher.this.client.listStudioComponents(ListStudioComponentsPublisher.this.firstRequest);
            }
            return ListStudioComponentsPublisher.this.client.listStudioComponents((ListStudioComponentsRequest)((Object)ListStudioComponentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

