/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectPeerAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectPeerAssociation> {
    private static final SdkField<String> CONNECT_PEER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectPeerId").getter(ConnectPeerAssociation.getter(ConnectPeerAssociation::connectPeerId)).setter(ConnectPeerAssociation.setter(Builder::connectPeerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerId").build()}).build();
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(ConnectPeerAssociation.getter(ConnectPeerAssociation::globalNetworkId)).setter(ConnectPeerAssociation.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(ConnectPeerAssociation.getter(ConnectPeerAssociation::deviceId)).setter(ConnectPeerAssociation.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkId").getter(ConnectPeerAssociation.getter(ConnectPeerAssociation::linkId)).setter(ConnectPeerAssociation.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ConnectPeerAssociation.getter(ConnectPeerAssociation::stateAsString)).setter(ConnectPeerAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_PEER_ID_FIELD, GLOBAL_NETWORK_ID_FIELD, DEVICE_ID_FIELD, LINK_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectPeerAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectPeerId;
    private final String globalNetworkId;
    private final String deviceId;
    private final String linkId;
    private final String state;

    private ConnectPeerAssociation(BuilderImpl builder) {
        this.connectPeerId = builder.connectPeerId;
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.linkId = builder.linkId;
        this.state = builder.state;
    }

    public final String connectPeerId() {
        return this.connectPeerId;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final ConnectPeerAssociationState state() {
        return ConnectPeerAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeerAssociation)) {
            return false;
        }
        ConnectPeerAssociation other = (ConnectPeerAssociation)obj;
        return Objects.equals(this.connectPeerId(), other.connectPeerId()) && Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.linkId(), other.linkId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectPeerAssociation").add("ConnectPeerId", (Object)this.connectPeerId()).add("GlobalNetworkId", (Object)this.globalNetworkId()).add("DeviceId", (Object)this.deviceId()).add("LinkId", (Object)this.linkId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectPeerId": {
                return Optional.ofNullable(clazz.cast(this.connectPeerId()));
            }
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "LinkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectPeerId", CONNECT_PEER_ID_FIELD);
        map.put("GlobalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("LinkId", LINK_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectPeerAssociation, T> g) {
        return obj -> g.apply((ConnectPeerAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectPeerId;
        private String globalNetworkId;
        private String deviceId;
        private String linkId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectPeerAssociation model) {
            this.connectPeerId(model.connectPeerId);
            this.globalNetworkId(model.globalNetworkId);
            this.deviceId(model.deviceId);
            this.linkId(model.linkId);
            this.state(model.state);
        }

        public final String getConnectPeerId() {
            return this.connectPeerId;
        }

        public final void setConnectPeerId(String connectPeerId) {
            this.connectPeerId = connectPeerId;
        }

        @Override
        public final Builder connectPeerId(String connectPeerId) {
            this.connectPeerId = connectPeerId;
            return this;
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConnectPeerAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public ConnectPeerAssociation build() {
            return new ConnectPeerAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectPeerAssociation> {
        public Builder connectPeerId(String var1);

        public Builder globalNetworkId(String var1);

        public Builder deviceId(String var1);

        public Builder linkId(String var1);

        public Builder state(String var1);

        public Builder state(ConnectPeerAssociationState var1);
    }
}

