/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerState;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectPeerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectPeerSummary> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(ConnectPeerSummary.getter(ConnectPeerSummary::coreNetworkId)).setter(ConnectPeerSummary.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> CONNECT_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectAttachmentId").getter(ConnectPeerSummary.getter(ConnectPeerSummary::connectAttachmentId)).setter(ConnectPeerSummary.setter(Builder::connectAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectAttachmentId").build()}).build();
    private static final SdkField<String> CONNECT_PEER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectPeerId").getter(ConnectPeerSummary.getter(ConnectPeerSummary::connectPeerId)).setter(ConnectPeerSummary.setter(Builder::connectPeerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerId").build()}).build();
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeLocation").getter(ConnectPeerSummary.getter(ConnectPeerSummary::edgeLocation)).setter(ConnectPeerSummary.setter(Builder::edgeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()}).build();
    private static final SdkField<String> CONNECT_PEER_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectPeerState").getter(ConnectPeerSummary.getter(ConnectPeerSummary::connectPeerStateAsString)).setter(ConnectPeerSummary.setter(Builder::connectPeerState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeerState").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ConnectPeerSummary.getter(ConnectPeerSummary::createdAt)).setter(ConnectPeerSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ConnectPeerSummary.getter(ConnectPeerSummary::tags)).setter(ConnectPeerSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetArn").getter(ConnectPeerSummary.getter(ConnectPeerSummary::subnetArn)).setter(ConnectPeerSummary.setter(Builder::subnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, CONNECT_ATTACHMENT_ID_FIELD, CONNECT_PEER_ID_FIELD, EDGE_LOCATION_FIELD, CONNECT_PEER_STATE_FIELD, CREATED_AT_FIELD, TAGS_FIELD, SUBNET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
            this.put("ConnectAttachmentId", CONNECT_ATTACHMENT_ID_FIELD);
            this.put("ConnectPeerId", CONNECT_PEER_ID_FIELD);
            this.put("EdgeLocation", EDGE_LOCATION_FIELD);
            this.put("ConnectPeerState", CONNECT_PEER_STATE_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("SubnetArn", SUBNET_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String coreNetworkId;
    private final String connectAttachmentId;
    private final String connectPeerId;
    private final String edgeLocation;
    private final String connectPeerState;
    private final Instant createdAt;
    private final List<Tag> tags;
    private final String subnetArn;

    private ConnectPeerSummary(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.connectAttachmentId = builder.connectAttachmentId;
        this.connectPeerId = builder.connectPeerId;
        this.edgeLocation = builder.edgeLocation;
        this.connectPeerState = builder.connectPeerState;
        this.createdAt = builder.createdAt;
        this.tags = builder.tags;
        this.subnetArn = builder.subnetArn;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String connectAttachmentId() {
        return this.connectAttachmentId;
    }

    public final String connectPeerId() {
        return this.connectPeerId;
    }

    public final String edgeLocation() {
        return this.edgeLocation;
    }

    public final ConnectPeerState connectPeerState() {
        return ConnectPeerState.fromValue(this.connectPeerState);
    }

    public final String connectPeerStateAsString() {
        return this.connectPeerState;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String subnetArn() {
        return this.subnetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectPeerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeerSummary)) {
            return false;
        }
        ConnectPeerSummary other = (ConnectPeerSummary)obj;
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.connectAttachmentId(), other.connectAttachmentId()) && Objects.equals(this.connectPeerId(), other.connectPeerId()) && Objects.equals(this.edgeLocation(), other.edgeLocation()) && Objects.equals(this.connectPeerStateAsString(), other.connectPeerStateAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.subnetArn(), other.subnetArn());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectPeerSummary").add("CoreNetworkId", (Object)this.coreNetworkId()).add("ConnectAttachmentId", (Object)this.connectAttachmentId()).add("ConnectPeerId", (Object)this.connectPeerId()).add("EdgeLocation", (Object)this.edgeLocation()).add("ConnectPeerState", (Object)this.connectPeerStateAsString()).add("CreatedAt", (Object)this.createdAt()).add("Tags", this.hasTags() ? this.tags() : null).add("SubnetArn", (Object)this.subnetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "ConnectAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.connectAttachmentId()));
            }
            case "ConnectPeerId": {
                return Optional.ofNullable(clazz.cast(this.connectPeerId()));
            }
            case "EdgeLocation": {
                return Optional.ofNullable(clazz.cast(this.edgeLocation()));
            }
            case "ConnectPeerState": {
                return Optional.ofNullable(clazz.cast(this.connectPeerStateAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SubnetArn": {
                return Optional.ofNullable(clazz.cast(this.subnetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectPeerSummary, T> g) {
        return obj -> g.apply((ConnectPeerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String connectAttachmentId;
        private String connectPeerId;
        private String edgeLocation;
        private String connectPeerState;
        private Instant createdAt;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String subnetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectPeerSummary model) {
            this.coreNetworkId(model.coreNetworkId);
            this.connectAttachmentId(model.connectAttachmentId);
            this.connectPeerId(model.connectPeerId);
            this.edgeLocation(model.edgeLocation);
            this.connectPeerState(model.connectPeerState);
            this.createdAt(model.createdAt);
            this.tags(model.tags);
            this.subnetArn(model.subnetArn);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getConnectAttachmentId() {
            return this.connectAttachmentId;
        }

        public final void setConnectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
        }

        @Override
        public final Builder connectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
            return this;
        }

        public final String getConnectPeerId() {
            return this.connectPeerId;
        }

        public final void setConnectPeerId(String connectPeerId) {
            this.connectPeerId = connectPeerId;
        }

        @Override
        public final Builder connectPeerId(String connectPeerId) {
            this.connectPeerId = connectPeerId;
            return this;
        }

        public final String getEdgeLocation() {
            return this.edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getConnectPeerState() {
            return this.connectPeerState;
        }

        public final void setConnectPeerState(String connectPeerState) {
            this.connectPeerState = connectPeerState;
        }

        @Override
        public final Builder connectPeerState(String connectPeerState) {
            this.connectPeerState = connectPeerState;
            return this;
        }

        @Override
        public final Builder connectPeerState(ConnectPeerState connectPeerState) {
            this.connectPeerState(connectPeerState == null ? null : connectPeerState.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubnetArn() {
            return this.subnetArn;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        public ConnectPeerSummary build() {
            return new ConnectPeerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectPeerSummary> {
        public Builder coreNetworkId(String var1);

        public Builder connectAttachmentId(String var1);

        public Builder connectPeerId(String var1);

        public Builder edgeLocation(String var1);

        public Builder connectPeerState(String var1);

        public Builder connectPeerState(ConnectPeerState var1);

        public Builder createdAt(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder subnetArn(String var1);
    }
}

