/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkResourceCount;
import software.amazon.awssdk.services.networkmanager.model.NetworkResourceCountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNetworkResourceCountsResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, GetNetworkResourceCountsResponse> {
    private static final SdkField<List<NetworkResourceCount>> NETWORK_RESOURCE_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkResourceCounts").getter(GetNetworkResourceCountsResponse.getter(GetNetworkResourceCountsResponse::networkResourceCounts)).setter(GetNetworkResourceCountsResponse.setter(Builder::networkResourceCounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkResourceCounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkResourceCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetNetworkResourceCountsResponse.getter(GetNetworkResourceCountsResponse::nextToken)).setter(GetNetworkResourceCountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_RESOURCE_COUNTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NetworkResourceCounts", NETWORK_RESOURCE_COUNTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<NetworkResourceCount> networkResourceCounts;
    private final String nextToken;

    private GetNetworkResourceCountsResponse(BuilderImpl builder) {
        super(builder);
        this.networkResourceCounts = builder.networkResourceCounts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkResourceCounts() {
        return this.networkResourceCounts != null && !(this.networkResourceCounts instanceof SdkAutoConstructList);
    }

    public final List<NetworkResourceCount> networkResourceCounts() {
        return this.networkResourceCounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkResourceCounts() ? this.networkResourceCounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkResourceCountsResponse)) {
            return false;
        }
        GetNetworkResourceCountsResponse other = (GetNetworkResourceCountsResponse)((Object)obj);
        return this.hasNetworkResourceCounts() == other.hasNetworkResourceCounts() && Objects.equals(this.networkResourceCounts(), other.networkResourceCounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetNetworkResourceCountsResponse").add("NetworkResourceCounts", this.hasNetworkResourceCounts() ? this.networkResourceCounts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkResourceCounts": {
                return Optional.ofNullable(clazz.cast(this.networkResourceCounts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkResourceCountsResponse, T> g) {
        return obj -> g.apply((GetNetworkResourceCountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<NetworkResourceCount> networkResourceCounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkResourceCountsResponse model) {
            super(model);
            this.networkResourceCounts(model.networkResourceCounts);
            this.nextToken(model.nextToken);
        }

        public final List<NetworkResourceCount.Builder> getNetworkResourceCounts() {
            List<NetworkResourceCount.Builder> result = NetworkResourceCountListCopier.copyToBuilder(this.networkResourceCounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkResourceCounts(Collection<NetworkResourceCount.BuilderImpl> networkResourceCounts) {
            this.networkResourceCounts = NetworkResourceCountListCopier.copyFromBuilder(networkResourceCounts);
        }

        @Override
        public final Builder networkResourceCounts(Collection<NetworkResourceCount> networkResourceCounts) {
            this.networkResourceCounts = NetworkResourceCountListCopier.copy(networkResourceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkResourceCounts(NetworkResourceCount ... networkResourceCounts) {
            this.networkResourceCounts(Arrays.asList(networkResourceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkResourceCounts(Consumer<NetworkResourceCount.Builder> ... networkResourceCounts) {
            this.networkResourceCounts(Stream.of(networkResourceCounts).map(c -> (NetworkResourceCount)((NetworkResourceCount.Builder)NetworkResourceCount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetNetworkResourceCountsResponse build() {
            return new GetNetworkResourceCountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNetworkResourceCountsResponse> {
        public Builder networkResourceCounts(Collection<NetworkResourceCount> var1);

        public Builder networkResourceCounts(NetworkResourceCount ... var1);

        public Builder networkResourceCounts(Consumer<NetworkResourceCount.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

