/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryRequest;
import software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse;
import software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry;

public class GetNetworkTelemetryIterable
implements SdkIterable<GetNetworkTelemetryResponse> {
    private final NetworkManagerClient client;
    private final GetNetworkTelemetryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetNetworkTelemetryIterable(NetworkManagerClient client, GetNetworkTelemetryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetNetworkTelemetryResponseFetcher();
    }

    public Iterator<GetNetworkTelemetryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkTelemetry> networkTelemetry() {
        Function<GetNetworkTelemetryResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkTelemetry() != null) {
                return response.networkTelemetry().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetNetworkTelemetryResponseFetcher
    implements SyncPageFetcher<GetNetworkTelemetryResponse> {
        private GetNetworkTelemetryResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkTelemetryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetNetworkTelemetryResponse nextPage(GetNetworkTelemetryResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkTelemetryIterable.this.client.getNetworkTelemetry(GetNetworkTelemetryIterable.this.firstRequest);
            }
            return GetNetworkTelemetryIterable.this.client.getNetworkTelemetry((GetNetworkTelemetryRequest)((Object)GetNetworkTelemetryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

