/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetwork implements SdkPojo, Serializable, ToCopyableBuilder<CoreNetwork.Builder, CoreNetwork> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(CoreNetwork::globalNetworkId)).setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(CoreNetwork::coreNetworkId)).setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkArn").getter(getter(CoreNetwork::coreNetworkArn)).setter(setter(Builder::coreNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CoreNetwork::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(CoreNetwork::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CoreNetwork::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<CoreNetworkSegment>> SEGMENTS_FIELD = SdkField
            .<List<CoreNetworkSegment>> builder(MarshallingType.LIST)
            .memberName("Segments")
            .getter(getter(CoreNetwork::segments))
            .setter(setter(Builder::segments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoreNetworkSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoreNetworkSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoreNetworkEdge>> EDGES_FIELD = SdkField
            .<List<CoreNetworkEdge>> builder(MarshallingType.LIST)
            .memberName("Edges")
            .getter(getter(CoreNetwork::edges))
            .setter(setter(Builder::edges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoreNetworkEdge> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoreNetworkEdge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CoreNetwork::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            CORE_NETWORK_ID_FIELD, CORE_NETWORK_ARN_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, STATE_FIELD, SEGMENTS_FIELD,
            EDGES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String globalNetworkId;

    private final String coreNetworkId;

    private final String coreNetworkArn;

    private final String description;

    private final Instant createdAt;

    private final String state;

    private final List<CoreNetworkSegment> segments;

    private final List<CoreNetworkEdge> edges;

    private final List<Tag> tags;

    private CoreNetwork(BuilderImpl builder) {
        this.globalNetworkId = builder.globalNetworkId;
        this.coreNetworkId = builder.coreNetworkId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.state = builder.state;
        this.segments = builder.segments;
        this.edges = builder.edges;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the global network that your core network is a part of.
     * </p>
     * 
     * @return The ID of the global network that your core network is a part of.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ARN of a core network.
     * </p>
     * 
     * @return The ARN of a core network.
     */
    public final String coreNetworkArn() {
        return coreNetworkArn;
    }

    /**
     * <p>
     * The description of a core network.
     * </p>
     * 
     * @return The description of a core network.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when a core network was created.
     * </p>
     * 
     * @return The timestamp when a core network was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The current state of a core network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CoreNetworkState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of a core network.
     * @see CoreNetworkState
     */
    public final CoreNetworkState state() {
        return CoreNetworkState.fromValue(state);
    }

    /**
     * <p>
     * The current state of a core network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CoreNetworkState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of a core network.
     * @see CoreNetworkState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Segments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSegments() {
        return segments != null && !(segments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The segments within a core network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegments} method.
     * </p>
     * 
     * @return The segments within a core network.
     */
    public final List<CoreNetworkSegment> segments() {
        return segments;
    }

    /**
     * For responses, this returns true if the service returned a value for the Edges property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEdges() {
        return edges != null && !(edges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The edges within a core network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdges} method.
     * </p>
     * 
     * @return The edges within a core network.
     */
    public final List<CoreNetworkEdge> edges() {
        return edges;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of key-value tags associated with a core network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of key-value tags associated with a core network.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegments() ? segments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEdges() ? edges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetwork)) {
            return false;
        }
        CoreNetwork other = (CoreNetwork) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId())
                && Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(coreNetworkArn(), other.coreNetworkArn()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasSegments() == other.hasSegments() && Objects.equals(segments(), other.segments())
                && hasEdges() == other.hasEdges() && Objects.equals(edges(), other.edges()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetwork").add("GlobalNetworkId", globalNetworkId()).add("CoreNetworkId", coreNetworkId())
                .add("CoreNetworkArn", coreNetworkArn()).add("Description", description()).add("CreatedAt", createdAt())
                .add("State", stateAsString()).add("Segments", hasSegments() ? segments() : null)
                .add("Edges", hasEdges() ? edges() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "CoreNetworkArn":
            return Optional.ofNullable(clazz.cast(coreNetworkArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Segments":
            return Optional.ofNullable(clazz.cast(segments()));
        case "Edges":
            return Optional.ofNullable(clazz.cast(edges()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetwork, T> g) {
        return obj -> g.apply((CoreNetwork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetwork> {
        /**
         * <p>
         * The ID of the global network that your core network is a part of.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network that your core network is a part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ARN of a core network.
         * </p>
         * 
         * @param coreNetworkArn
         *        The ARN of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkArn(String coreNetworkArn);

        /**
         * <p>
         * The description of a core network.
         * </p>
         * 
         * @param description
         *        The description of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when a core network was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when a core network was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The current state of a core network.
         * </p>
         * 
         * @param state
         *        The current state of a core network.
         * @see CoreNetworkState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreNetworkState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of a core network.
         * </p>
         * 
         * @param state
         *        The current state of a core network.
         * @see CoreNetworkState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreNetworkState
         */
        Builder state(CoreNetworkState state);

        /**
         * <p>
         * The segments within a core network.
         * </p>
         * 
         * @param segments
         *        The segments within a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segments(Collection<CoreNetworkSegment> segments);

        /**
         * <p>
         * The segments within a core network.
         * </p>
         * 
         * @param segments
         *        The segments within a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segments(CoreNetworkSegment... segments);

        /**
         * <p>
         * The segments within a core network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment.Builder#build()} is called
         * immediately and its result is passed to {@link #segments(List<CoreNetworkSegment>)}.
         * 
         * @param segments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segments(java.util.Collection<CoreNetworkSegment>)
         */
        Builder segments(Consumer<CoreNetworkSegment.Builder>... segments);

        /**
         * <p>
         * The edges within a core network.
         * </p>
         * 
         * @param edges
         *        The edges within a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Collection<CoreNetworkEdge> edges);

        /**
         * <p>
         * The edges within a core network.
         * </p>
         * 
         * @param edges
         *        The edges within a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(CoreNetworkEdge... edges);

        /**
         * <p>
         * The edges within a core network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge.Builder#build()} is called
         * immediately and its result is passed to {@link #edges(List<CoreNetworkEdge>)}.
         * 
         * @param edges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edges(java.util.Collection<CoreNetworkEdge>)
         */
        Builder edges(Consumer<CoreNetworkEdge.Builder>... edges);

        /**
         * <p>
         * The list of key-value tags associated with a core network.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of key-value tags associated with a core network.
         * </p>
         * 
         * @param tags
         *        The list of key-value tags associated with a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of key-value tags associated with a core network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String globalNetworkId;

        private String coreNetworkId;

        private String coreNetworkArn;

        private String description;

        private Instant createdAt;

        private String state;

        private List<CoreNetworkSegment> segments = DefaultSdkAutoConstructList.getInstance();

        private List<CoreNetworkEdge> edges = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetwork model) {
            globalNetworkId(model.globalNetworkId);
            coreNetworkId(model.coreNetworkId);
            coreNetworkArn(model.coreNetworkArn);
            description(model.description);
            createdAt(model.createdAt);
            state(model.state);
            segments(model.segments);
            edges(model.edges);
            tags(model.tags);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CoreNetworkState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<CoreNetworkSegment.Builder> getSegments() {
            List<CoreNetworkSegment.Builder> result = CoreNetworkSegmentListCopier.copyToBuilder(this.segments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegments(Collection<CoreNetworkSegment.BuilderImpl> segments) {
            this.segments = CoreNetworkSegmentListCopier.copyFromBuilder(segments);
        }

        @Override
        public final Builder segments(Collection<CoreNetworkSegment> segments) {
            this.segments = CoreNetworkSegmentListCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(CoreNetworkSegment... segments) {
            segments(Arrays.asList(segments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Consumer<CoreNetworkSegment.Builder>... segments) {
            segments(Stream.of(segments).map(c -> CoreNetworkSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoreNetworkEdge.Builder> getEdges() {
            List<CoreNetworkEdge.Builder> result = CoreNetworkEdgeListCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdges(Collection<CoreNetworkEdge.BuilderImpl> edges) {
            this.edges = CoreNetworkEdgeListCopier.copyFromBuilder(edges);
        }

        @Override
        public final Builder edges(Collection<CoreNetworkEdge> edges) {
            this.edges = CoreNetworkEdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(CoreNetworkEdge... edges) {
            edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<CoreNetworkEdge.Builder>... edges) {
            edges(Stream.of(edges).map(c -> CoreNetworkEdge.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CoreNetwork build() {
            return new CoreNetwork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
