/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.Attachment;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse;

public class ListAttachmentsIterable
implements SdkIterable<ListAttachmentsResponse> {
    private final NetworkManagerClient client;
    private final ListAttachmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachmentsIterable(NetworkManagerClient client, ListAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachmentsResponseFetcher();
    }

    public Iterator<ListAttachmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Attachment> attachments() {
        Function<ListAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachments() != null) {
                return response.attachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttachmentsResponseFetcher
    implements SyncPageFetcher<ListAttachmentsResponse> {
        private ListAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAttachmentsResponse nextPage(ListAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return ListAttachmentsIterable.this.client.listAttachments(ListAttachmentsIterable.this.firstRequest);
            }
            return ListAttachmentsIterable.this.client.listAttachments((ListAttachmentsRequest)((Object)ListAttachmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

