/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.Connection;
import software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse;

public class GetConnectionsPublisher
implements SdkPublisher<GetConnectionsResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetConnectionsPublisher(NetworkManagerAsyncClient client, GetConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetConnectionsPublisher(NetworkManagerAsyncClient client, GetConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Connection> connections() {
        Function<GetConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connections() != null) {
                return response.connections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetConnectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetConnectionsResponseFetcher
    implements AsyncPageFetcher<GetConnectionsResponse> {
        private GetConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetConnectionsResponse> nextPage(GetConnectionsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectionsPublisher.this.client.getConnections(GetConnectionsPublisher.this.firstRequest);
            }
            return GetConnectionsPublisher.this.client.getConnections((GetConnectionsRequest)((Object)GetConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

