/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerAssociation;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsResponse;

public class GetConnectPeerAssociationsIterable
implements SdkIterable<GetConnectPeerAssociationsResponse> {
    private final NetworkManagerClient client;
    private final GetConnectPeerAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetConnectPeerAssociationsIterable(NetworkManagerClient client, GetConnectPeerAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetConnectPeerAssociationsResponseFetcher();
    }

    public Iterator<GetConnectPeerAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectPeerAssociation> connectPeerAssociations() {
        Function<GetConnectPeerAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectPeerAssociations() != null) {
                return response.connectPeerAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetConnectPeerAssociationsResponseFetcher
    implements SyncPageFetcher<GetConnectPeerAssociationsResponse> {
        private GetConnectPeerAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectPeerAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetConnectPeerAssociationsResponse nextPage(GetConnectPeerAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectPeerAssociationsIterable.this.client.getConnectPeerAssociations(GetConnectPeerAssociationsIterable.this.firstRequest);
            }
            return GetConnectPeerAssociationsIterable.this.client.getConnectPeerAssociations((GetConnectPeerAssociationsRequest)((Object)GetConnectPeerAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

