/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.Attachment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SiteToSiteVpnAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SiteToSiteVpnAttachment> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(SiteToSiteVpnAttachment.getter(SiteToSiteVpnAttachment::attachment)).setter(SiteToSiteVpnAttachment.setter(Builder::attachment)).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final SdkField<String> VPN_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnConnectionArn").getter(SiteToSiteVpnAttachment.getter(SiteToSiteVpnAttachment::vpnConnectionArn)).setter(SiteToSiteVpnAttachment.setter(Builder::vpnConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, VPN_CONNECTION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Attachment attachment;
    private final String vpnConnectionArn;

    private SiteToSiteVpnAttachment(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.vpnConnectionArn = builder.vpnConnectionArn;
    }

    public final Attachment attachment() {
        return this.attachment;
    }

    public final String vpnConnectionArn() {
        return this.vpnConnectionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SiteToSiteVpnAttachment)) {
            return false;
        }
        SiteToSiteVpnAttachment other = (SiteToSiteVpnAttachment)obj;
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.vpnConnectionArn(), other.vpnConnectionArn());
    }

    public final String toString() {
        return ToString.builder((String)"SiteToSiteVpnAttachment").add("Attachment", (Object)this.attachment()).add("VpnConnectionArn", (Object)this.vpnConnectionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "VpnConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SiteToSiteVpnAttachment, T> g) {
        return obj -> g.apply((SiteToSiteVpnAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Attachment attachment;
        private String vpnConnectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SiteToSiteVpnAttachment model) {
            this.attachment(model.attachment);
            this.vpnConnectionArn(model.vpnConnectionArn);
        }

        public final Attachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getVpnConnectionArn() {
            return this.vpnConnectionArn;
        }

        public final void setVpnConnectionArn(String vpnConnectionArn) {
            this.vpnConnectionArn = vpnConnectionArn;
        }

        @Override
        public final Builder vpnConnectionArn(String vpnConnectionArn) {
            this.vpnConnectionArn = vpnConnectionArn;
            return this;
        }

        public SiteToSiteVpnAttachment build() {
            return new SiteToSiteVpnAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SiteToSiteVpnAttachment> {
        public Builder attachment(Attachment var1);

        default public Builder attachment(Consumer<Attachment.Builder> attachment) {
            return this.attachment((Attachment)((Attachment.Builder)Attachment.builder().applyMutation(attachment)).build());
        }

        public Builder vpnConnectionArn(String var1);
    }
}

