/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.SubnetArnListCopier;
import software.amazon.awssdk.services.networkmanager.model.VpcOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVpcAttachmentRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, UpdateVpcAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(UpdateVpcAttachmentRequest.getter(UpdateVpcAttachmentRequest::attachmentId)).setter(UpdateVpcAttachmentRequest.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("attachmentId").build()}).build();
    private static final SdkField<List<String>> ADD_SUBNET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddSubnetArns").getter(UpdateVpcAttachmentRequest.getter(UpdateVpcAttachmentRequest::addSubnetArns)).setter(UpdateVpcAttachmentRequest.setter(Builder::addSubnetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SUBNET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveSubnetArns").getter(UpdateVpcAttachmentRequest.getter(UpdateVpcAttachmentRequest::removeSubnetArns)).setter(UpdateVpcAttachmentRequest.setter(Builder::removeSubnetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(UpdateVpcAttachmentRequest.getter(UpdateVpcAttachmentRequest::options)).setter(UpdateVpcAttachmentRequest.setter(Builder::options)).constructor(VpcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, ADD_SUBNET_ARNS_FIELD, REMOVE_SUBNET_ARNS_FIELD, OPTIONS_FIELD));
    private final String attachmentId;
    private final List<String> addSubnetArns;
    private final List<String> removeSubnetArns;
    private final VpcOptions options;

    private UpdateVpcAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.addSubnetArns = builder.addSubnetArns;
        this.removeSubnetArns = builder.removeSubnetArns;
        this.options = builder.options;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final boolean hasAddSubnetArns() {
        return this.addSubnetArns != null && !(this.addSubnetArns instanceof SdkAutoConstructList);
    }

    public final List<String> addSubnetArns() {
        return this.addSubnetArns;
    }

    public final boolean hasRemoveSubnetArns() {
        return this.removeSubnetArns != null && !(this.removeSubnetArns instanceof SdkAutoConstructList);
    }

    public final List<String> removeSubnetArns() {
        return this.removeSubnetArns;
    }

    public final VpcOptions options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSubnetArns() ? this.addSubnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSubnetArns() ? this.removeSubnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcAttachmentRequest)) {
            return false;
        }
        UpdateVpcAttachmentRequest other = (UpdateVpcAttachmentRequest)((Object)obj);
        return Objects.equals(this.attachmentId(), other.attachmentId()) && this.hasAddSubnetArns() == other.hasAddSubnetArns() && Objects.equals(this.addSubnetArns(), other.addSubnetArns()) && this.hasRemoveSubnetArns() == other.hasRemoveSubnetArns() && Objects.equals(this.removeSubnetArns(), other.removeSubnetArns()) && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVpcAttachmentRequest").add("AttachmentId", (Object)this.attachmentId()).add("AddSubnetArns", this.hasAddSubnetArns() ? this.addSubnetArns() : null).add("RemoveSubnetArns", this.hasRemoveSubnetArns() ? this.removeSubnetArns() : null).add("Options", (Object)this.options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "AddSubnetArns": {
                return Optional.ofNullable(clazz.cast(this.addSubnetArns()));
            }
            case "RemoveSubnetArns": {
                return Optional.ofNullable(clazz.cast(this.removeSubnetArns()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcAttachmentRequest, T> g) {
        return obj -> g.apply((UpdateVpcAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String attachmentId;
        private List<String> addSubnetArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSubnetArns = DefaultSdkAutoConstructList.getInstance();
        private VpcOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcAttachmentRequest model) {
            super(model);
            this.attachmentId(model.attachmentId);
            this.addSubnetArns(model.addSubnetArns);
            this.removeSubnetArns(model.removeSubnetArns);
            this.options(model.options);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        @Transient
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Collection<String> getAddSubnetArns() {
            if (this.addSubnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSubnetArns;
        }

        public final void setAddSubnetArns(Collection<String> addSubnetArns) {
            this.addSubnetArns = SubnetArnListCopier.copy(addSubnetArns);
        }

        @Override
        @Transient
        public final Builder addSubnetArns(Collection<String> addSubnetArns) {
            this.addSubnetArns = SubnetArnListCopier.copy(addSubnetArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addSubnetArns(String ... addSubnetArns) {
            this.addSubnetArns(Arrays.asList(addSubnetArns));
            return this;
        }

        public final Collection<String> getRemoveSubnetArns() {
            if (this.removeSubnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSubnetArns;
        }

        public final void setRemoveSubnetArns(Collection<String> removeSubnetArns) {
            this.removeSubnetArns = SubnetArnListCopier.copy(removeSubnetArns);
        }

        @Override
        @Transient
        public final Builder removeSubnetArns(Collection<String> removeSubnetArns) {
            this.removeSubnetArns = SubnetArnListCopier.copy(removeSubnetArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeSubnetArns(String ... removeSubnetArns) {
            this.removeSubnetArns(Arrays.asList(removeSubnetArns));
            return this;
        }

        public final VpcOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(VpcOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(VpcOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcAttachmentRequest build() {
            return new UpdateVpcAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVpcAttachmentRequest> {
        public Builder attachmentId(String var1);

        public Builder addSubnetArns(Collection<String> var1);

        public Builder addSubnetArns(String ... var1);

        public Builder removeSubnetArns(Collection<String> var1);

        public Builder removeSubnetArns(String ... var1);

        public Builder options(VpcOptions var1);

        default public Builder options(Consumer<VpcOptions.Builder> options) {
            return this.options((VpcOptions)((VpcOptions.Builder)VpcOptions.builder().applyMutation(options)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

