/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.GetLinksRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinksResponse;
import software.amazon.awssdk.services.networkmanager.model.Link;

public class GetLinksPublisher
implements SdkPublisher<GetLinksResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetLinksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetLinksPublisher(NetworkManagerAsyncClient client, GetLinksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetLinksPublisher(NetworkManagerAsyncClient client, GetLinksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetLinksResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetLinksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Link> links() {
        Function<GetLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.links() != null) {
                return response.links().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetLinksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetLinksResponseFetcher
    implements AsyncPageFetcher<GetLinksResponse> {
        private GetLinksResponseFetcher() {
        }

        public boolean hasNextPage(GetLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetLinksResponse> nextPage(GetLinksResponse previousPage) {
            if (previousPage == null) {
                return GetLinksPublisher.this.client.getLinks(GetLinksPublisher.this.firstRequest);
            }
            return GetLinksPublisher.this.client.getLinks((GetLinksRequest)((Object)GetLinksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

