/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.AWSLocation;
import software.amazon.awssdk.services.networkmanager.model.Location;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeviceRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, CreateDeviceRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(CreateDeviceRequest.getter(CreateDeviceRequest::globalNetworkId)).setter(CreateDeviceRequest.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()}).build();
    private static final SdkField<AWSLocation> AWS_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AWSLocation").getter(CreateDeviceRequest.getter(CreateDeviceRequest::awsLocation)).setter(CreateDeviceRequest.setter(Builder::awsLocation)).constructor(AWSLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSLocation").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDeviceRequest.getter(CreateDeviceRequest::description)).setter(CreateDeviceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateDeviceRequest.getter(CreateDeviceRequest::type)).setter(CreateDeviceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Vendor").getter(CreateDeviceRequest.getter(CreateDeviceRequest::vendor)).setter(CreateDeviceRequest.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(CreateDeviceRequest.getter(CreateDeviceRequest::model)).setter(CreateDeviceRequest.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(CreateDeviceRequest.getter(CreateDeviceRequest::serialNumber)).setter(CreateDeviceRequest.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(CreateDeviceRequest.getter(CreateDeviceRequest::location)).setter(CreateDeviceRequest.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> SITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SiteId").getter(CreateDeviceRequest.getter(CreateDeviceRequest::siteId)).setter(CreateDeviceRequest.setter(Builder::siteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDeviceRequest.getter(CreateDeviceRequest::tags)).setter(CreateDeviceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, AWS_LOCATION_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, VENDOR_FIELD, MODEL_FIELD, SERIAL_NUMBER_FIELD, LOCATION_FIELD, SITE_ID_FIELD, TAGS_FIELD));
    private final String globalNetworkId;
    private final AWSLocation awsLocation;
    private final String description;
    private final String type;
    private final String vendor;
    private final String model;
    private final String serialNumber;
    private final Location location;
    private final String siteId;
    private final List<Tag> tags;

    private CreateDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.awsLocation = builder.awsLocation;
        this.description = builder.description;
        this.type = builder.type;
        this.vendor = builder.vendor;
        this.model = builder.model;
        this.serialNumber = builder.serialNumber;
        this.location = builder.location;
        this.siteId = builder.siteId;
        this.tags = builder.tags;
    }

    public String globalNetworkId() {
        return this.globalNetworkId;
    }

    public AWSLocation awsLocation() {
        return this.awsLocation;
    }

    public String description() {
        return this.description;
    }

    public String type() {
        return this.type;
    }

    public String vendor() {
        return this.vendor;
    }

    public String model() {
        return this.model;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public Location location() {
        return this.location;
    }

    public String siteId() {
        return this.siteId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.siteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeviceRequest)) {
            return false;
        }
        CreateDeviceRequest other = (CreateDeviceRequest)((Object)obj);
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.awsLocation(), other.awsLocation()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.vendor(), other.vendor()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.siteId(), other.siteId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeviceRequest").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("AWSLocation", (Object)this.awsLocation()).add("Description", (Object)this.description()).add("Type", (Object)this.type()).add("Vendor", (Object)this.vendor()).add("Model", (Object)this.model()).add("SerialNumber", (Object)this.serialNumber()).add("Location", (Object)(this.location() == null ? null : "*** Sensitive Data Redacted ***")).add("SiteId", (Object)this.siteId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "AWSLocation": {
                return Optional.ofNullable(clazz.cast(this.awsLocation()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "SiteId": {
                return Optional.ofNullable(clazz.cast(this.siteId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeviceRequest, T> g) {
        return obj -> g.apply((CreateDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private AWSLocation awsLocation;
        private String description;
        private String type;
        private String vendor;
        private String model;
        private String serialNumber;
        private Location location;
        private String siteId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeviceRequest model) {
            super(model);
            this.globalNetworkId(model.globalNetworkId);
            this.awsLocation(model.awsLocation);
            this.description(model.description);
            this.type(model.type);
            this.vendor(model.vendor);
            this.model(model.model);
            this.serialNumber(model.serialNumber);
            this.location(model.location);
            this.siteId(model.siteId);
            this.tags(model.tags);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        public final AWSLocation.Builder getAwsLocation() {
            return this.awsLocation != null ? this.awsLocation.toBuilder() : null;
        }

        @Override
        public final Builder awsLocation(AWSLocation awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        public final void setAwsLocation(AWSLocation.BuilderImpl awsLocation) {
            this.awsLocation = awsLocation != null ? awsLocation.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getVendor() {
            return this.vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public final String getModel() {
            return this.model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getSiteId() {
            return this.siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeviceRequest build() {
            return new CreateDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeviceRequest> {
        public Builder globalNetworkId(String var1);

        public Builder awsLocation(AWSLocation var1);

        default public Builder awsLocation(Consumer<AWSLocation.Builder> awsLocation) {
            return this.awsLocation((AWSLocation)((AWSLocation.Builder)AWSLocation.builder().applyMutation(awsLocation)).build());
        }

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder vendor(String var1);

        public Builder model(String var1);

        public Builder serialNumber(String var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder siteId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

