/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the registration of a transit gateway to a global network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayRegistration implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayRegistration.Builder, TransitGatewayRegistration> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayRegistration::globalNetworkId)).setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayRegistration::transitGatewayArn)).setter(setter(Builder::transitGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayArn").build()).build();

    private static final SdkField<TransitGatewayRegistrationStateReason> STATE_FIELD = SdkField
            .<TransitGatewayRegistrationStateReason> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransitGatewayRegistration::state)).setter(setter(Builder::state))
            .constructor(TransitGatewayRegistrationStateReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            TRANSIT_GATEWAY_ARN_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String globalNetworkId;

    private final String transitGatewayArn;

    private final TransitGatewayRegistrationStateReason state;

    private TransitGatewayRegistration(BuilderImpl builder) {
        this.globalNetworkId = builder.globalNetworkId;
        this.transitGatewayArn = builder.transitGatewayArn;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the transit gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the transit gateway.
     */
    public String transitGatewayArn() {
        return transitGatewayArn;
    }

    /**
     * <p>
     * The state of the transit gateway registration.
     * </p>
     * 
     * @return The state of the transit gateway registration.
     */
    public TransitGatewayRegistrationStateReason state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRegistration)) {
            return false;
        }
        TransitGatewayRegistration other = (TransitGatewayRegistration) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId())
                && Objects.equals(transitGatewayArn(), other.transitGatewayArn()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayRegistration").add("GlobalNetworkId", globalNetworkId())
                .add("TransitGatewayArn", transitGatewayArn()).add("State", state()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "TransitGatewayArn":
            return Optional.ofNullable(clazz.cast(transitGatewayArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRegistration, T> g) {
        return obj -> g.apply((TransitGatewayRegistration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayRegistration> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the transit gateway.
         * </p>
         * 
         * @param transitGatewayArn
         *        The Amazon Resource Name (ARN) of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayArn(String transitGatewayArn);

        /**
         * <p>
         * The state of the transit gateway registration.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(TransitGatewayRegistrationStateReason state);

        /**
         * <p>
         * The state of the transit gateway registration.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayRegistrationStateReason.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayRegistrationStateReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayRegistrationStateReason.Builder#build()} is called
         * immediately and its result is passed to {@link #state(TransitGatewayRegistrationStateReason)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link TransitGatewayRegistrationStateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(TransitGatewayRegistrationStateReason)
         */
        default Builder state(Consumer<TransitGatewayRegistrationStateReason.Builder> state) {
            return state(TransitGatewayRegistrationStateReason.builder().applyMutation(state).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String globalNetworkId;

        private String transitGatewayArn;

        private TransitGatewayRegistrationStateReason state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRegistration model) {
            globalNetworkId(model.globalNetworkId);
            transitGatewayArn(model.transitGatewayArn);
            state(model.state);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        public final String getTransitGatewayArn() {
            return transitGatewayArn;
        }

        @Override
        public final Builder transitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        public final void setTransitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
        }

        public final TransitGatewayRegistrationStateReason.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(TransitGatewayRegistrationStateReason state) {
            this.state = state;
            return this;
        }

        public final void setState(TransitGatewayRegistrationStateReason.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public TransitGatewayRegistration build() {
            return new TransitGatewayRegistration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
