/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalNetworkResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<UpdateGlobalNetworkResponse.Builder, UpdateGlobalNetworkResponse> {
    private static final SdkField<GlobalNetwork> GLOBAL_NETWORK_FIELD = SdkField
            .<GlobalNetwork> builder(MarshallingType.SDK_POJO).getter(getter(UpdateGlobalNetworkResponse::globalNetwork))
            .setter(setter(Builder::globalNetwork)).constructor(GlobalNetwork::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetwork").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_FIELD));

    private final GlobalNetwork globalNetwork;

    private UpdateGlobalNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.globalNetwork = builder.globalNetwork;
    }

    /**
     * <p>
     * Information about the global network object.
     * </p>
     * 
     * @return Information about the global network object.
     */
    public GlobalNetwork globalNetwork() {
        return globalNetwork;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetwork());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalNetworkResponse)) {
            return false;
        }
        UpdateGlobalNetworkResponse other = (UpdateGlobalNetworkResponse) obj;
        return Objects.equals(globalNetwork(), other.globalNetwork());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateGlobalNetworkResponse").add("GlobalNetwork", globalNetwork()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetwork":
            return Optional.ofNullable(clazz.cast(globalNetwork()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalNetworkResponse, T> g) {
        return obj -> g.apply((UpdateGlobalNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGlobalNetworkResponse> {
        /**
         * <p>
         * Information about the global network object.
         * </p>
         * 
         * @param globalNetwork
         *        Information about the global network object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetwork(GlobalNetwork globalNetwork);

        /**
         * <p>
         * Information about the global network object.
         * </p>
         * This is a convenience that creates an instance of the {@link GlobalNetwork.Builder} avoiding the need to
         * create one manually via {@link GlobalNetwork#builder()}.
         *
         * When the {@link Consumer} completes, {@link GlobalNetwork.Builder#build()} is called immediately and its
         * result is passed to {@link #globalNetwork(GlobalNetwork)}.
         * 
         * @param globalNetwork
         *        a consumer that will call methods on {@link GlobalNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalNetwork(GlobalNetwork)
         */
        default Builder globalNetwork(Consumer<GlobalNetwork.Builder> globalNetwork) {
            return globalNetwork(GlobalNetwork.builder().applyMutation(globalNetwork).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private GlobalNetwork globalNetwork;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalNetworkResponse model) {
            super(model);
            globalNetwork(model.globalNetwork);
        }

        public final GlobalNetwork.Builder getGlobalNetwork() {
            return globalNetwork != null ? globalNetwork.toBuilder() : null;
        }

        @Override
        public final Builder globalNetwork(GlobalNetwork globalNetwork) {
            this.globalNetwork = globalNetwork;
            return this;
        }

        public final void setGlobalNetwork(GlobalNetwork.BuilderImpl globalNetwork) {
            this.globalNetwork = globalNetwork != null ? globalNetwork.build() : null;
        }

        @Override
        public UpdateGlobalNetworkResponse build() {
            return new UpdateGlobalNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
