/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProxyRuleResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<UpdateProxyRuleResponse.Builder, UpdateProxyRuleResponse> {
    private static final SdkField<ProxyRule> PROXY_RULE_FIELD = SdkField.<ProxyRule> builder(MarshallingType.SDK_POJO)
            .memberName("ProxyRule").getter(getter(UpdateProxyRuleResponse::proxyRule)).setter(setter(Builder::proxyRule))
            .constructor(ProxyRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRule").build()).build();

    private static final SdkField<List<ProxyRuleCondition>> REMOVED_CONDITIONS_FIELD = SdkField
            .<List<ProxyRuleCondition>> builder(MarshallingType.LIST)
            .memberName("RemovedConditions")
            .getter(getter(UpdateProxyRuleResponse::removedConditions))
            .setter(setter(Builder::removedConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovedConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateProxyRuleResponse::updateToken)).setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_FIELD,
            REMOVED_CONDITIONS_FIELD, UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProxyRule proxyRule;

    private final List<ProxyRuleCondition> removedConditions;

    private final String updateToken;

    private UpdateProxyRuleResponse(BuilderImpl builder) {
        super(builder);
        this.proxyRule = builder.proxyRule;
        this.removedConditions = builder.removedConditions;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The updated proxy rule resource that reflects the updates from the request.
     * </p>
     * 
     * @return The updated proxy rule resource that reflects the updates from the request.
     */
    public final ProxyRule proxyRule() {
        return proxyRule;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemovedConditions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemovedConditions() {
        return removedConditions != null && !(removedConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Proxy rule conditions removed from the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemovedConditions} method.
     * </p>
     * 
     * @return Proxy rule conditions removed from the rule.
     */
    public final List<ProxyRuleCondition> removedConditions() {
        return removedConditions;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
     * rule. The token marks the state of the proxy rule resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token to
     * ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the operation fails
     * with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule again to get a current copy
     * of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy rule. The token marks the state of the proxy rule resource at the time of the request. </p>
     *         <p>
     *         To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token
     *         to ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the
     *         operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule
     *         again to get a current copy of it with a current token. Reapply your changes as needed, then try the
     *         operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyRule());
        hashCode = 31 * hashCode + Objects.hashCode(hasRemovedConditions() ? removedConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRuleResponse)) {
            return false;
        }
        UpdateProxyRuleResponse other = (UpdateProxyRuleResponse) obj;
        return Objects.equals(proxyRule(), other.proxyRule()) && hasRemovedConditions() == other.hasRemovedConditions()
                && Objects.equals(removedConditions(), other.removedConditions())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProxyRuleResponse").add("ProxyRule", proxyRule())
                .add("RemovedConditions", hasRemovedConditions() ? removedConditions() : null).add("UpdateToken", updateToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRule":
            return Optional.ofNullable(clazz.cast(proxyRule()));
        case "RemovedConditions":
            return Optional.ofNullable(clazz.cast(removedConditions()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRule", PROXY_RULE_FIELD);
        map.put("RemovedConditions", REMOVED_CONDITIONS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRuleResponse, T> g) {
        return obj -> g.apply((UpdateProxyRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProxyRuleResponse> {
        /**
         * <p>
         * The updated proxy rule resource that reflects the updates from the request.
         * </p>
         * 
         * @param proxyRule
         *        The updated proxy rule resource that reflects the updates from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRule(ProxyRule proxyRule);

        /**
         * <p>
         * The updated proxy rule resource that reflects the updates from the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProxyRule.Builder} avoiding the need to
         * create one manually via {@link ProxyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProxyRule.Builder#build()} is called immediately and its result
         * is passed to {@link #proxyRule(ProxyRule)}.
         * 
         * @param proxyRule
         *        a consumer that will call methods on {@link ProxyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxyRule(ProxyRule)
         */
        default Builder proxyRule(Consumer<ProxyRule.Builder> proxyRule) {
            return proxyRule(ProxyRule.builder().applyMutation(proxyRule).build());
        }

        /**
         * <p>
         * Proxy rule conditions removed from the rule.
         * </p>
         * 
         * @param removedConditions
         *        Proxy rule conditions removed from the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removedConditions(Collection<ProxyRuleCondition> removedConditions);

        /**
         * <p>
         * Proxy rule conditions removed from the rule.
         * </p>
         * 
         * @param removedConditions
         *        Proxy rule conditions removed from the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removedConditions(ProxyRuleCondition... removedConditions);

        /**
         * <p>
         * Proxy rule conditions removed from the rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #removedConditions(List<ProxyRuleCondition>)}.
         * 
         * @param removedConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removedConditions(java.util.Collection<ProxyRuleCondition>)
         */
        Builder removedConditions(Consumer<ProxyRuleCondition.Builder>... removedConditions);

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
         * rule. The token marks the state of the proxy rule resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token to
         * ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the operation fails
         * with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule again to get a current
         * copy of it with a current token. Reapply your changes as needed, then try the operation again using the new
         * token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy rule. The token marks the state of the proxy rule resource at the time of the request. </p>
         *        <p>
         *        To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the
         *        token to ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the
         *        operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule
         *        again to get a current copy of it with a current token. Reapply your changes as needed, then try the
         *        operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private ProxyRule proxyRule;

        private List<ProxyRuleCondition> removedConditions = DefaultSdkAutoConstructList.getInstance();

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRuleResponse model) {
            super(model);
            proxyRule(model.proxyRule);
            removedConditions(model.removedConditions);
            updateToken(model.updateToken);
        }

        public final ProxyRule.Builder getProxyRule() {
            return proxyRule != null ? proxyRule.toBuilder() : null;
        }

        public final void setProxyRule(ProxyRule.BuilderImpl proxyRule) {
            this.proxyRule = proxyRule != null ? proxyRule.build() : null;
        }

        @Override
        public final Builder proxyRule(ProxyRule proxyRule) {
            this.proxyRule = proxyRule;
            return this;
        }

        public final List<ProxyRuleCondition.Builder> getRemovedConditions() {
            List<ProxyRuleCondition.Builder> result = ProxyRuleConditionListCopier.copyToBuilder(this.removedConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemovedConditions(Collection<ProxyRuleCondition.BuilderImpl> removedConditions) {
            this.removedConditions = ProxyRuleConditionListCopier.copyFromBuilder(removedConditions);
        }

        @Override
        public final Builder removedConditions(Collection<ProxyRuleCondition> removedConditions) {
            this.removedConditions = ProxyRuleConditionListCopier.copy(removedConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removedConditions(ProxyRuleCondition... removedConditions) {
            removedConditions(Arrays.asList(removedConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removedConditions(Consumer<ProxyRuleCondition.Builder>... removedConditions) {
            removedConditions(Stream.of(removedConditions).map(c -> ProxyRuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public UpdateProxyRuleResponse build() {
            return new UpdateProxyRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
