/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFirewallAnalysisSettingsRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<UpdateFirewallAnalysisSettingsRequest.Builder, UpdateFirewallAnalysisSettingsRequest> {
    private static final SdkField<List<String>> ENABLED_ANALYSIS_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledAnalysisTypes")
            .getter(getter(UpdateFirewallAnalysisSettingsRequest::enabledAnalysisTypesAsStrings))
            .setter(setter(Builder::enabledAnalysisTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledAnalysisTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(UpdateFirewallAnalysisSettingsRequest::firewallArn))
            .setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallName").getter(getter(UpdateFirewallAnalysisSettingsRequest::firewallName))
            .setter(setter(Builder::firewallName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateFirewallAnalysisSettingsRequest::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_ANALYSIS_TYPES_FIELD,
            FIREWALL_ARN_FIELD, FIREWALL_NAME_FIELD, UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> enabledAnalysisTypes;

    private final String firewallArn;

    private final String firewallName;

    private final String updateToken;

    private UpdateFirewallAnalysisSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.enabledAnalysisTypes = builder.enabledAnalysisTypes;
        this.firewallArn = builder.firewallArn;
        this.firewallName = builder.firewallName;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * An optional setting indicating the specific traffic analysis types to enable on the firewall.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledAnalysisTypes} method.
     * </p>
     * 
     * @return An optional setting indicating the specific traffic analysis types to enable on the firewall.
     */
    public final List<EnabledAnalysisType> enabledAnalysisTypes() {
        return EnabledAnalysisTypesCopier.copyStringToEnum(enabledAnalysisTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledAnalysisTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledAnalysisTypes() {
        return enabledAnalysisTypes != null && !(enabledAnalysisTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional setting indicating the specific traffic analysis types to enable on the firewall.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledAnalysisTypes} method.
     * </p>
     * 
     * @return An optional setting indicating the specific traffic analysis types to enable on the firewall.
     */
    public final List<String> enabledAnalysisTypesAsStrings() {
        return enabledAnalysisTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String firewallName() {
        return firewallName;
    }

    /**
     * <p>
     * An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that
     * access the firewall. The token marks the state of the firewall resource at the time of the request.
     * </p>
     * <p>
     * To make an unconditional change to the firewall, omit the token in your update request. Without the token,
     * Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved
     * it.
     * </p>
     * <p>
     * To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the
     * token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation
     * fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to get a current
     * copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return An optional token that you can use for optimistic locking. Network Firewall returns a token to your
     *         requests that access the firewall. The token marks the state of the firewall resource at the time of the
     *         request. </p>
     *         <p>
     *         To make an unconditional change to the firewall, omit the token in your update request. Without the
     *         token, Network Firewall performs your updates regardless of whether the firewall has changed since you
     *         last retrieved it.
     *         </p>
     *         <p>
     *         To make a conditional change to the firewall, provide the token in your update request. Network Firewall
     *         uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed,
     *         the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall
     *         again to get a current copy of it with a new token. Reapply your changes as needed, then try the
     *         operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledAnalysisTypes() ? enabledAnalysisTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallAnalysisSettingsRequest)) {
            return false;
        }
        UpdateFirewallAnalysisSettingsRequest other = (UpdateFirewallAnalysisSettingsRequest) obj;
        return hasEnabledAnalysisTypes() == other.hasEnabledAnalysisTypes()
                && Objects.equals(enabledAnalysisTypesAsStrings(), other.enabledAnalysisTypesAsStrings())
                && Objects.equals(firewallArn(), other.firewallArn()) && Objects.equals(firewallName(), other.firewallName())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFirewallAnalysisSettingsRequest")
                .add("EnabledAnalysisTypes", hasEnabledAnalysisTypes() ? enabledAnalysisTypesAsStrings() : null)
                .add("FirewallArn", firewallArn()).add("FirewallName", firewallName()).add("UpdateToken", updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnabledAnalysisTypes":
            return Optional.ofNullable(clazz.cast(enabledAnalysisTypesAsStrings()));
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "FirewallName":
            return Optional.ofNullable(clazz.cast(firewallName()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnabledAnalysisTypes", ENABLED_ANALYSIS_TYPES_FIELD);
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FirewallName", FIREWALL_NAME_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallAnalysisSettingsRequest, T> g) {
        return obj -> g.apply((UpdateFirewallAnalysisSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFirewallAnalysisSettingsRequest> {
        /**
         * <p>
         * An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * </p>
         * 
         * @param enabledAnalysisTypes
         *        An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAnalysisTypesWithStrings(Collection<String> enabledAnalysisTypes);

        /**
         * <p>
         * An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * </p>
         * 
         * @param enabledAnalysisTypes
         *        An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAnalysisTypesWithStrings(String... enabledAnalysisTypes);

        /**
         * <p>
         * An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * </p>
         * 
         * @param enabledAnalysisTypes
         *        An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAnalysisTypes(Collection<EnabledAnalysisType> enabledAnalysisTypes);

        /**
         * <p>
         * An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * </p>
         * 
         * @param enabledAnalysisTypes
         *        An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAnalysisTypes(EnabledAnalysisType... enabledAnalysisTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param firewallName
         *        The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallName(String firewallName);

        /**
         * <p>
         * An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests
         * that access the firewall. The token marks the state of the firewall resource at the time of the request.
         * </p>
         * <p>
         * To make an unconditional change to the firewall, omit the token in your update request. Without the token,
         * Network Firewall performs your updates regardless of whether the firewall has changed since you last
         * retrieved it.
         * </p>
         * <p>
         * To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses
         * the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the
         * operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the firewall again to
         * get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using
         * the new token.
         * </p>
         * 
         * @param updateToken
         *        An optional token that you can use for optimistic locking. Network Firewall returns a token to your
         *        requests that access the firewall. The token marks the state of the firewall resource at the time of
         *        the request. </p>
         *        <p>
         *        To make an unconditional change to the firewall, omit the token in your update request. Without the
         *        token, Network Firewall performs your updates regardless of whether the firewall has changed since you
         *        last retrieved it.
         *        </p>
         *        <p>
         *        To make a conditional change to the firewall, provide the token in your update request. Network
         *        Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it
         *        has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve
         *        the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then
         *        try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private List<String> enabledAnalysisTypes = DefaultSdkAutoConstructList.getInstance();

        private String firewallArn;

        private String firewallName;

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallAnalysisSettingsRequest model) {
            super(model);
            enabledAnalysisTypesWithStrings(model.enabledAnalysisTypes);
            firewallArn(model.firewallArn);
            firewallName(model.firewallName);
            updateToken(model.updateToken);
        }

        public final Collection<String> getEnabledAnalysisTypes() {
            if (enabledAnalysisTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledAnalysisTypes;
        }

        public final void setEnabledAnalysisTypes(Collection<String> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copy(enabledAnalysisTypes);
        }

        @Override
        public final Builder enabledAnalysisTypesWithStrings(Collection<String> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copy(enabledAnalysisTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledAnalysisTypesWithStrings(String... enabledAnalysisTypes) {
            enabledAnalysisTypesWithStrings(Arrays.asList(enabledAnalysisTypes));
            return this;
        }

        @Override
        public final Builder enabledAnalysisTypes(Collection<EnabledAnalysisType> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = EnabledAnalysisTypesCopier.copyEnumToString(enabledAnalysisTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledAnalysisTypes(EnabledAnalysisType... enabledAnalysisTypes) {
            enabledAnalysisTypes(Arrays.asList(enabledAnalysisTypes));
            return this;
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFirewallName() {
            return firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallAnalysisSettingsRequest build() {
            return new UpdateFirewallAnalysisSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
