/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TLS decryption on traffic to filter on attributes in the HTTP header.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TlsInterceptProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<TlsInterceptProperties.Builder, TlsInterceptProperties> {
    private static final SdkField<String> PCA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PcaArn")
            .getter(getter(TlsInterceptProperties::pcaArn)).setter(setter(Builder::pcaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PcaArn").build()).build();

    private static final SdkField<String> TLS_INTERCEPT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TlsInterceptMode").getter(getter(TlsInterceptProperties::tlsInterceptModeAsString))
            .setter(setter(Builder::tlsInterceptMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsInterceptMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PCA_ARN_FIELD,
            TLS_INTERCEPT_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pcaArn;

    private final String tlsInterceptMode;

    private TlsInterceptProperties(BuilderImpl builder) {
        this.pcaArn = builder.pcaArn;
        this.tlsInterceptMode = builder.tlsInterceptMode;
    }

    /**
     * <p>
     * Private Certificate Authority (PCA) used to issue private TLS certificates so that the proxy can present
     * PCA-signed certificates which applications trust through the same root, establishing a secure and consistent
     * trust model for encrypted communication.
     * </p>
     * 
     * @return Private Certificate Authority (PCA) used to issue private TLS certificates so that the proxy can present
     *         PCA-signed certificates which applications trust through the same root, establishing a secure and
     *         consistent trust model for encrypted communication.
     */
    public final String pcaArn() {
        return pcaArn;
    }

    /**
     * <p>
     * Specifies whether to enable or disable TLS Intercept Mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsInterceptMode}
     * will return {@link TlsInterceptMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tlsInterceptModeAsString}.
     * </p>
     * 
     * @return Specifies whether to enable or disable TLS Intercept Mode.
     * @see TlsInterceptMode
     */
    public final TlsInterceptMode tlsInterceptMode() {
        return TlsInterceptMode.fromValue(tlsInterceptMode);
    }

    /**
     * <p>
     * Specifies whether to enable or disable TLS Intercept Mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsInterceptMode}
     * will return {@link TlsInterceptMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tlsInterceptModeAsString}.
     * </p>
     * 
     * @return Specifies whether to enable or disable TLS Intercept Mode.
     * @see TlsInterceptMode
     */
    public final String tlsInterceptModeAsString() {
        return tlsInterceptMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pcaArn());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInterceptModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsInterceptProperties)) {
            return false;
        }
        TlsInterceptProperties other = (TlsInterceptProperties) obj;
        return Objects.equals(pcaArn(), other.pcaArn())
                && Objects.equals(tlsInterceptModeAsString(), other.tlsInterceptModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TlsInterceptProperties").add("PcaArn", pcaArn())
                .add("TlsInterceptMode", tlsInterceptModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PcaArn":
            return Optional.ofNullable(clazz.cast(pcaArn()));
        case "TlsInterceptMode":
            return Optional.ofNullable(clazz.cast(tlsInterceptModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PcaArn", PCA_ARN_FIELD);
        map.put("TlsInterceptMode", TLS_INTERCEPT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TlsInterceptProperties, T> g) {
        return obj -> g.apply((TlsInterceptProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TlsInterceptProperties> {
        /**
         * <p>
         * Private Certificate Authority (PCA) used to issue private TLS certificates so that the proxy can present
         * PCA-signed certificates which applications trust through the same root, establishing a secure and consistent
         * trust model for encrypted communication.
         * </p>
         * 
         * @param pcaArn
         *        Private Certificate Authority (PCA) used to issue private TLS certificates so that the proxy can
         *        present PCA-signed certificates which applications trust through the same root, establishing a secure
         *        and consistent trust model for encrypted communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcaArn(String pcaArn);

        /**
         * <p>
         * Specifies whether to enable or disable TLS Intercept Mode.
         * </p>
         * 
         * @param tlsInterceptMode
         *        Specifies whether to enable or disable TLS Intercept Mode.
         * @see TlsInterceptMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TlsInterceptMode
         */
        Builder tlsInterceptMode(String tlsInterceptMode);

        /**
         * <p>
         * Specifies whether to enable or disable TLS Intercept Mode.
         * </p>
         * 
         * @param tlsInterceptMode
         *        Specifies whether to enable or disable TLS Intercept Mode.
         * @see TlsInterceptMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TlsInterceptMode
         */
        Builder tlsInterceptMode(TlsInterceptMode tlsInterceptMode);
    }

    static final class BuilderImpl implements Builder {
        private String pcaArn;

        private String tlsInterceptMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TlsInterceptProperties model) {
            pcaArn(model.pcaArn);
            tlsInterceptMode(model.tlsInterceptMode);
        }

        public final String getPcaArn() {
            return pcaArn;
        }

        public final void setPcaArn(String pcaArn) {
            this.pcaArn = pcaArn;
        }

        @Override
        public final Builder pcaArn(String pcaArn) {
            this.pcaArn = pcaArn;
            return this;
        }

        public final String getTlsInterceptMode() {
            return tlsInterceptMode;
        }

        public final void setTlsInterceptMode(String tlsInterceptMode) {
            this.tlsInterceptMode = tlsInterceptMode;
        }

        @Override
        public final Builder tlsInterceptMode(String tlsInterceptMode) {
            this.tlsInterceptMode = tlsInterceptMode;
            return this;
        }

        @Override
        public final Builder tlsInterceptMode(TlsInterceptMode tlsInterceptMode) {
            this.tlsInterceptMode(tlsInterceptMode == null ? null : tlsInterceptMode.toString());
            return this;
        }

        @Override
        public TlsInterceptProperties build() {
            return new TlsInterceptProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
