/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFlowCaptureRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<StartFlowCaptureRequest.Builder, StartFlowCaptureRequest> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(StartFlowCaptureRequest::firewallArn)).setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(StartFlowCaptureRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointAssociationArn").getter(getter(StartFlowCaptureRequest::vpcEndpointAssociationArn))
            .setter(setter(Builder::vpcEndpointAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationArn").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(StartFlowCaptureRequest::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<Integer> MINIMUM_FLOW_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MinimumFlowAgeInSeconds")
            .getter(getter(StartFlowCaptureRequest::minimumFlowAgeInSeconds)).setter(setter(Builder::minimumFlowAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumFlowAgeInSeconds").build())
            .build();

    private static final SdkField<List<FlowFilter>> FLOW_FILTERS_FIELD = SdkField
            .<List<FlowFilter>> builder(MarshallingType.LIST)
            .memberName("FlowFilters")
            .getter(getter(StartFlowCaptureRequest::flowFilters))
            .setter(setter(Builder::flowFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD,
            AVAILABILITY_ZONE_FIELD, VPC_ENDPOINT_ASSOCIATION_ARN_FIELD, VPC_ENDPOINT_ID_FIELD,
            MINIMUM_FLOW_AGE_IN_SECONDS_FIELD, FLOW_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallArn;

    private final String availabilityZone;

    private final String vpcEndpointAssociationArn;

    private final String vpcEndpointId;

    private final Integer minimumFlowAgeInSeconds;

    private final List<FlowFilter> flowFilters;

    private StartFlowCaptureRequest(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.availabilityZone = builder.availabilityZone;
        this.vpcEndpointAssociationArn = builder.vpcEndpointAssociationArn;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.minimumFlowAgeInSeconds = builder.minimumFlowAgeInSeconds;
        this.flowFilters = builder.flowFilters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.
     * </p>
     * <p>
     * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
     * </p>
     * 
     * @return The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.</p>
     *         <p>
     *         Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a VPC endpoint association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a VPC endpoint association.
     */
    public final String vpcEndpointAssociationArn() {
        return vpcEndpointAssociationArn;
    }

    /**
     * <p>
     * A unique identifier for the primary endpoint associated with a firewall.
     * </p>
     * 
     * @return A unique identifier for the primary endpoint associated with a firewall.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The reqested <code>FlowOperation</code> ignores flows with an age (in seconds) lower than
     * <code>MinimumFlowAgeInSeconds</code>. You provide this for start commands.
     * </p>
     * <note>
     * <p>
     * We recommend setting this value to at least 1 minute (60 seconds) to reduce chance of capturing flows that are
     * not yet established.
     * </p>
     * </note>
     * 
     * @return The reqested <code>FlowOperation</code> ignores flows with an age (in seconds) lower than
     *         <code>MinimumFlowAgeInSeconds</code>. You provide this for start commands.</p> <note>
     *         <p>
     *         We recommend setting this value to at least 1 minute (60 seconds) to reduce chance of capturing flows
     *         that are not yet established.
     *         </p>
     */
    public final Integer minimumFlowAgeInSeconds() {
        return minimumFlowAgeInSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the FlowFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFlowFilters() {
        return flowFilters != null && !(flowFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlowFilters} method.
     * </p>
     * 
     * @return Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
     */
    public final List<FlowFilter> flowFilters() {
        return flowFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(minimumFlowAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasFlowFilters() ? flowFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlowCaptureRequest)) {
            return false;
        }
        StartFlowCaptureRequest other = (StartFlowCaptureRequest) obj;
        return Objects.equals(firewallArn(), other.firewallArn()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(vpcEndpointAssociationArn(), other.vpcEndpointAssociationArn())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(minimumFlowAgeInSeconds(), other.minimumFlowAgeInSeconds())
                && hasFlowFilters() == other.hasFlowFilters() && Objects.equals(flowFilters(), other.flowFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartFlowCaptureRequest").add("FirewallArn", firewallArn())
                .add("AvailabilityZone", availabilityZone()).add("VpcEndpointAssociationArn", vpcEndpointAssociationArn())
                .add("VpcEndpointId", vpcEndpointId()).add("MinimumFlowAgeInSeconds", minimumFlowAgeInSeconds())
                .add("FlowFilters", hasFlowFilters() ? flowFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcEndpointAssociationArn":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociationArn()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "MinimumFlowAgeInSeconds":
            return Optional.ofNullable(clazz.cast(minimumFlowAgeInSeconds()));
        case "FlowFilters":
            return Optional.ofNullable(clazz.cast(flowFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("VpcEndpointAssociationArn", VPC_ENDPOINT_ASSOCIATION_ARN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("MinimumFlowAgeInSeconds", MINIMUM_FLOW_AGE_IN_SECONDS_FIELD);
        map.put("FlowFilters", FLOW_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartFlowCaptureRequest, T> g) {
        return obj -> g.apply((StartFlowCaptureRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartFlowCaptureRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.
         * </p>
         * <p>
         * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * </p>
         * 
         * @param availabilityZone
         *        The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>
         *        .</p>
         *        <p>
         *        Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a VPC endpoint association.
         * </p>
         * 
         * @param vpcEndpointAssociationArn
         *        The Amazon Resource Name (ARN) of a VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn);

        /**
         * <p>
         * A unique identifier for the primary endpoint associated with a firewall.
         * </p>
         * 
         * @param vpcEndpointId
         *        A unique identifier for the primary endpoint associated with a firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The reqested <code>FlowOperation</code> ignores flows with an age (in seconds) lower than
         * <code>MinimumFlowAgeInSeconds</code>. You provide this for start commands.
         * </p>
         * <note>
         * <p>
         * We recommend setting this value to at least 1 minute (60 seconds) to reduce chance of capturing flows that
         * are not yet established.
         * </p>
         * </note>
         * 
         * @param minimumFlowAgeInSeconds
         *        The reqested <code>FlowOperation</code> ignores flows with an age (in seconds) lower than
         *        <code>MinimumFlowAgeInSeconds</code>. You provide this for start commands.</p> <note>
         *        <p>
         *        We recommend setting this value to at least 1 minute (60 seconds) to reduce chance of capturing flows
         *        that are not yet established.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumFlowAgeInSeconds(Integer minimumFlowAgeInSeconds);

        /**
         * <p>
         * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * </p>
         * 
         * @param flowFilters
         *        Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowFilters(Collection<FlowFilter> flowFilters);

        /**
         * <p>
         * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * </p>
         * 
         * @param flowFilters
         *        Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowFilters(FlowFilter... flowFilters);

        /**
         * <p>
         * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.FlowFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.networkfirewall.model.FlowFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.FlowFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #flowFilters(List<FlowFilter>)}.
         * 
         * @param flowFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.FlowFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowFilters(java.util.Collection<FlowFilter>)
         */
        Builder flowFilters(Consumer<FlowFilter.Builder>... flowFilters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String firewallArn;

        private String availabilityZone;

        private String vpcEndpointAssociationArn;

        private String vpcEndpointId;

        private Integer minimumFlowAgeInSeconds;

        private List<FlowFilter> flowFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlowCaptureRequest model) {
            super(model);
            firewallArn(model.firewallArn);
            availabilityZone(model.availabilityZone);
            vpcEndpointAssociationArn(model.vpcEndpointAssociationArn);
            vpcEndpointId(model.vpcEndpointId);
            minimumFlowAgeInSeconds(model.minimumFlowAgeInSeconds);
            flowFilters(model.flowFilters);
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcEndpointAssociationArn() {
            return vpcEndpointAssociationArn;
        }

        public final void setVpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
        }

        @Override
        public final Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final Integer getMinimumFlowAgeInSeconds() {
            return minimumFlowAgeInSeconds;
        }

        public final void setMinimumFlowAgeInSeconds(Integer minimumFlowAgeInSeconds) {
            this.minimumFlowAgeInSeconds = minimumFlowAgeInSeconds;
        }

        @Override
        public final Builder minimumFlowAgeInSeconds(Integer minimumFlowAgeInSeconds) {
            this.minimumFlowAgeInSeconds = minimumFlowAgeInSeconds;
            return this;
        }

        public final List<FlowFilter.Builder> getFlowFilters() {
            List<FlowFilter.Builder> result = FlowFiltersCopier.copyToBuilder(this.flowFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowFilters(Collection<FlowFilter.BuilderImpl> flowFilters) {
            this.flowFilters = FlowFiltersCopier.copyFromBuilder(flowFilters);
        }

        @Override
        public final Builder flowFilters(Collection<FlowFilter> flowFilters) {
            this.flowFilters = FlowFiltersCopier.copy(flowFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowFilters(FlowFilter... flowFilters) {
            flowFilters(Arrays.asList(flowFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowFilters(Consumer<FlowFilter.Builder>... flowFilters) {
            flowFilters(Stream.of(flowFilters).map(c -> FlowFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFlowCaptureRequest build() {
            return new StartFlowCaptureRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
