/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing details about a Suricata rule. Contains:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>SID</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Msg</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Metadata</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * Summaries are available for rule groups you manage and for active threat defense Amazon Web Services managed rule
 * groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleSummary implements SdkPojo, Serializable, ToCopyableBuilder<RuleSummary.Builder, RuleSummary> {
    private static final SdkField<String> SID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SID")
            .getter(getter(RuleSummary::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()).build();

    private static final SdkField<String> MSG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Msg")
            .getter(getter(RuleSummary::msg)).setter(setter(Builder::msg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Msg").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(RuleSummary::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SID_FIELD, MSG_FIELD,
            METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sid;

    private final String msg;

    private final String metadata;

    private RuleSummary(BuilderImpl builder) {
        this.sid = builder.sid;
        this.msg = builder.msg;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The unique identifier (Signature ID) of the Suricata rule.
     * </p>
     * 
     * @return The unique identifier (Signature ID) of the Suricata rule.
     */
    public final String sid() {
        return sid;
    }

    /**
     * <p>
     * The contents taken from the rule's msg field.
     * </p>
     * 
     * @return The contents taken from the rule's msg field.
     */
    public final String msg() {
        return msg;
    }

    /**
     * <p>
     * The contents of the rule's metadata.
     * </p>
     * 
     * @return The contents of the rule's metadata.
     */
    public final String metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        hashCode = 31 * hashCode + Objects.hashCode(msg());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleSummary)) {
            return false;
        }
        RuleSummary other = (RuleSummary) obj;
        return Objects.equals(sid(), other.sid()) && Objects.equals(msg(), other.msg())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleSummary").add("SID", sid()).add("Msg", msg()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SID":
            return Optional.ofNullable(clazz.cast(sid()));
        case "Msg":
            return Optional.ofNullable(clazz.cast(msg()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SID", SID_FIELD);
        map.put("Msg", MSG_FIELD);
        map.put("Metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleSummary, T> g) {
        return obj -> g.apply((RuleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleSummary> {
        /**
         * <p>
         * The unique identifier (Signature ID) of the Suricata rule.
         * </p>
         * 
         * @param sid
         *        The unique identifier (Signature ID) of the Suricata rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(String sid);

        /**
         * <p>
         * The contents taken from the rule's msg field.
         * </p>
         * 
         * @param msg
         *        The contents taken from the rule's msg field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msg(String msg);

        /**
         * <p>
         * The contents of the rule's metadata.
         * </p>
         * 
         * @param metadata
         *        The contents of the rule's metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);
    }

    static final class BuilderImpl implements Builder {
        private String sid;

        private String msg;

        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleSummary model) {
            sid(model.sid);
            msg(model.msg);
            metadata(model.metadata);
        }

        public final String getSid() {
            return sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final String getMsg() {
            return msg;
        }

        public final void setMsg(String msg) {
            this.msg = msg;
        }

        @Override
        public final Builder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public RuleSummary build() {
            return new RuleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
