/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proxy rule group(s) to attach to the proxy configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProxyRuleGroupAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<ProxyRuleGroupAttachment.Builder, ProxyRuleGroupAttachment> {
    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupName").getter(getter(ProxyRuleGroupAttachment::proxyRuleGroupName))
            .setter(setter(Builder::proxyRuleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build())
            .build();

    private static final SdkField<Integer> INSERT_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InsertPosition").getter(getter(ProxyRuleGroupAttachment::insertPosition))
            .setter(setter(Builder::insertPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsertPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_NAME_FIELD,
            INSERT_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String proxyRuleGroupName;

    private final Integer insertPosition;

    private ProxyRuleGroupAttachment(BuilderImpl builder) {
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.insertPosition = builder.insertPosition;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you create
     * it.
     * </p>
     * 
     * @return The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
     *         create it.
     */
    public final String proxyRuleGroupName() {
        return proxyRuleGroupName;
    }

    /**
     * <p>
     * Where to insert a proxy rule group in a proxy configuration.
     * </p>
     * 
     * @return Where to insert a proxy rule group in a proxy configuration.
     */
    public final Integer insertPosition() {
        return insertPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(insertPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyRuleGroupAttachment)) {
            return false;
        }
        ProxyRuleGroupAttachment other = (ProxyRuleGroupAttachment) obj;
        return Objects.equals(proxyRuleGroupName(), other.proxyRuleGroupName())
                && Objects.equals(insertPosition(), other.insertPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProxyRuleGroupAttachment").add("ProxyRuleGroupName", proxyRuleGroupName())
                .add("InsertPosition", insertPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleGroupName":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupName()));
        case "InsertPosition":
            return Optional.ofNullable(clazz.cast(insertPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("InsertPosition", INSERT_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyRuleGroupAttachment, T> g) {
        return obj -> g.apply((ProxyRuleGroupAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProxyRuleGroupAttachment> {
        /**
         * <p>
         * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
         * create it.
         * </p>
         * 
         * @param proxyRuleGroupName
         *        The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after
         *        you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupName(String proxyRuleGroupName);

        /**
         * <p>
         * Where to insert a proxy rule group in a proxy configuration.
         * </p>
         * 
         * @param insertPosition
         *        Where to insert a proxy rule group in a proxy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insertPosition(Integer insertPosition);
    }

    static final class BuilderImpl implements Builder {
        private String proxyRuleGroupName;

        private Integer insertPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyRuleGroupAttachment model) {
            proxyRuleGroupName(model.proxyRuleGroupName);
            insertPosition(model.insertPosition);
        }

        public final String getProxyRuleGroupName() {
            return proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final Integer getInsertPosition() {
            return insertPosition;
        }

        public final void setInsertPosition(Integer insertPosition) {
            this.insertPosition = insertPosition;
        }

        @Override
        public final Builder insertPosition(Integer insertPosition) {
            this.insertPosition = insertPosition;
            return this;
        }

        @Override
        public ProxyRuleGroupAttachment build() {
            return new ProxyRuleGroupAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
