/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Proxy Configuration defines the monitoring and protection behavior for a Proxy. The details of the behavior are
 * defined in the rule groups that you add to your configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProxyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProxyConfiguration.Builder, ProxyConfiguration> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationName").getter(getter(ProxyConfiguration::proxyConfigurationName))
            .setter(setter(Builder::proxyConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build())
            .build();

    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationArn").getter(getter(ProxyConfiguration::proxyConfigurationArn))
            .setter(setter(Builder::proxyConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ProxyConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(ProxyConfiguration::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> DELETE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeleteTime").getter(getter(ProxyConfiguration::deleteTime)).setter(setter(Builder::deleteTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTime").build()).build();

    private static final SdkField<List<ProxyConfigRuleGroup>> RULE_GROUPS_FIELD = SdkField
            .<List<ProxyConfigRuleGroup>> builder(MarshallingType.LIST)
            .memberName("RuleGroups")
            .getter(getter(ProxyConfiguration::ruleGroups))
            .setter(setter(Builder::ruleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyConfigRuleGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyConfigRuleGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProxyConfigDefaultRulePhaseActionsRequest> DEFAULT_RULE_PHASE_ACTIONS_FIELD = SdkField
            .<ProxyConfigDefaultRulePhaseActionsRequest> builder(MarshallingType.SDK_POJO).memberName("DefaultRulePhaseActions")
            .getter(getter(ProxyConfiguration::defaultRulePhaseActions)).setter(setter(Builder::defaultRulePhaseActions))
            .constructor(ProxyConfigDefaultRulePhaseActionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRulePhaseActions").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ProxyConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD,
            DELETE_TIME_FIELD, RULE_GROUPS_FIELD, DEFAULT_RULE_PHASE_ACTIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String proxyConfigurationName;

    private final String proxyConfigurationArn;

    private final String description;

    private final Instant createTime;

    private final Instant deleteTime;

    private final List<ProxyConfigRuleGroup> ruleGroups;

    private final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;

    private final List<Tag> tags;

    private ProxyConfiguration(BuilderImpl builder) {
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.ruleGroups = builder.ruleGroups;
        this.defaultRulePhaseActions = builder.defaultRulePhaseActions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
     * create it.
     * </p>
     * 
     * @return The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after
     *         you create it.
     */
    public final String proxyConfigurationName() {
        return proxyConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy configuration.
     */
    public final String proxyConfigurationArn() {
        return proxyConfigurationArn;
    }

    /**
     * <p>
     * A description of the proxy configuration.
     * </p>
     * 
     * @return A description of the proxy configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Time the Proxy Configuration was created.
     * </p>
     * 
     * @return Time the Proxy Configuration was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Time the Proxy Configuration was deleted.
     * </p>
     * 
     * @return Time the Proxy Configuration was deleted.
     */
    public final Instant deleteTime() {
        return deleteTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRuleGroups() {
        return ruleGroups != null && !(ruleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Proxy rule groups within the proxy configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleGroups} method.
     * </p>
     * 
     * @return Proxy rule groups within the proxy configuration.
     */
    public final List<ProxyConfigRuleGroup> ruleGroups() {
        return ruleGroups;
    }

    /**
     * <p>
     * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the rule
     * match is applied.
     * </p>
     * <p>
     * Pre-DNS - before domain resolution.
     * </p>
     * <p>
     * Pre-Request - after DNS, before request.
     * </p>
     * <p>
     * Post-Response - after receiving response.
     * </p>
     * 
     * @return Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where
     *         the rule match is applied. </p>
     *         <p>
     *         Pre-DNS - before domain resolution.
     *         </p>
     *         <p>
     *         Pre-Request - after DNS, before request.
     *         </p>
     *         <p>
     *         Post-Response - after receiving response.
     */
    public final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions() {
        return defaultRulePhaseActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroups() ? ruleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultRulePhaseActions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration) obj;
        return Objects.equals(proxyConfigurationName(), other.proxyConfigurationName())
                && Objects.equals(proxyConfigurationArn(), other.proxyConfigurationArn())
                && Objects.equals(description(), other.description()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(deleteTime(), other.deleteTime()) && hasRuleGroups() == other.hasRuleGroups()
                && Objects.equals(ruleGroups(), other.ruleGroups())
                && Objects.equals(defaultRulePhaseActions(), other.defaultRulePhaseActions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProxyConfiguration").add("ProxyConfigurationName", proxyConfigurationName())
                .add("ProxyConfigurationArn", proxyConfigurationArn()).add("Description", description())
                .add("CreateTime", createTime()).add("DeleteTime", deleteTime())
                .add("RuleGroups", hasRuleGroups() ? ruleGroups() : null)
                .add("DefaultRulePhaseActions", defaultRulePhaseActions()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyConfigurationName":
            return Optional.ofNullable(clazz.cast(proxyConfigurationName()));
        case "ProxyConfigurationArn":
            return Optional.ofNullable(clazz.cast(proxyConfigurationArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "DeleteTime":
            return Optional.ofNullable(clazz.cast(deleteTime()));
        case "RuleGroups":
            return Optional.ofNullable(clazz.cast(ruleGroups()));
        case "DefaultRulePhaseActions":
            return Optional.ofNullable(clazz.cast(defaultRulePhaseActions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("DeleteTime", DELETE_TIME_FIELD);
        map.put("RuleGroups", RULE_GROUPS_FIELD);
        map.put("DefaultRulePhaseActions", DEFAULT_RULE_PHASE_ACTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyConfiguration, T> g) {
        return obj -> g.apply((ProxyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProxyConfiguration> {
        /**
         * <p>
         * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
         * create it.
         * </p>
         * 
         * @param proxyConfigurationName
         *        The descriptive name of the proxy configuration. You can't change the name of a proxy configuration
         *        after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationName(String proxyConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy configuration.
         * </p>
         * 
         * @param proxyConfigurationArn
         *        The Amazon Resource Name (ARN) of a proxy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationArn(String proxyConfigurationArn);

        /**
         * <p>
         * A description of the proxy configuration.
         * </p>
         * 
         * @param description
         *        A description of the proxy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Time the Proxy Configuration was created.
         * </p>
         * 
         * @param createTime
         *        Time the Proxy Configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Time the Proxy Configuration was deleted.
         * </p>
         * 
         * @param deleteTime
         *        Time the Proxy Configuration was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteTime(Instant deleteTime);

        /**
         * <p>
         * Proxy rule groups within the proxy configuration.
         * </p>
         * 
         * @param ruleGroups
         *        Proxy rule groups within the proxy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroups(Collection<ProxyConfigRuleGroup> ruleGroups);

        /**
         * <p>
         * Proxy rule groups within the proxy configuration.
         * </p>
         * 
         * @param ruleGroups
         *        Proxy rule groups within the proxy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroups(ProxyConfigRuleGroup... ruleGroups);

        /**
         * <p>
         * Proxy rule groups within the proxy configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyConfigRuleGroup.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyConfigRuleGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyConfigRuleGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleGroups(List<ProxyConfigRuleGroup>)}.
         * 
         * @param ruleGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyConfigRuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroups(java.util.Collection<ProxyConfigRuleGroup>)
         */
        Builder ruleGroups(Consumer<ProxyConfigRuleGroup.Builder>... ruleGroups);

        /**
         * <p>
         * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the
         * rule match is applied.
         * </p>
         * <p>
         * Pre-DNS - before domain resolution.
         * </p>
         * <p>
         * Pre-Request - after DNS, before request.
         * </p>
         * <p>
         * Post-Response - after receiving response.
         * </p>
         * 
         * @param defaultRulePhaseActions
         *        Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic
         *        where the rule match is applied. </p>
         *        <p>
         *        Pre-DNS - before domain resolution.
         *        </p>
         *        <p>
         *        Pre-Request - after DNS, before request.
         *        </p>
         *        <p>
         *        Post-Response - after receiving response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions);

        /**
         * <p>
         * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the
         * rule match is applied.
         * </p>
         * <p>
         * Pre-DNS - before domain resolution.
         * </p>
         * <p>
         * Pre-Request - after DNS, before request.
         * </p>
         * <p>
         * Post-Response - after receiving response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder} avoiding the need to create one manually via
         * {@link ProxyConfigDefaultRulePhaseActionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest)}.
         * 
         * @param defaultRulePhaseActions
         *        a consumer that will call methods on {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest)
         */
        default Builder defaultRulePhaseActions(
                Consumer<ProxyConfigDefaultRulePhaseActionsRequest.Builder> defaultRulePhaseActions) {
            return defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.builder()
                    .applyMutation(defaultRulePhaseActions).build());
        }

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String proxyConfigurationName;

        private String proxyConfigurationArn;

        private String description;

        private Instant createTime;

        private Instant deleteTime;

        private List<ProxyConfigRuleGroup> ruleGroups = DefaultSdkAutoConstructList.getInstance();

        private ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration model) {
            proxyConfigurationName(model.proxyConfigurationName);
            proxyConfigurationArn(model.proxyConfigurationArn);
            description(model.description);
            createTime(model.createTime);
            deleteTime(model.deleteTime);
            ruleGroups(model.ruleGroups);
            defaultRulePhaseActions(model.defaultRulePhaseActions);
            tags(model.tags);
        }

        public final String getProxyConfigurationName() {
            return proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getDeleteTime() {
            return deleteTime;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final List<ProxyConfigRuleGroup.Builder> getRuleGroups() {
            List<ProxyConfigRuleGroup.Builder> result = ProxyConfigRuleGroupSetCopier.copyToBuilder(this.ruleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroups(Collection<ProxyConfigRuleGroup.BuilderImpl> ruleGroups) {
            this.ruleGroups = ProxyConfigRuleGroupSetCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public final Builder ruleGroups(Collection<ProxyConfigRuleGroup> ruleGroups) {
            this.ruleGroups = ProxyConfigRuleGroupSetCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(ProxyConfigRuleGroup... ruleGroups) {
            ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<ProxyConfigRuleGroup.Builder>... ruleGroups) {
            ruleGroups(Stream.of(ruleGroups).map(c -> ProxyConfigRuleGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ProxyConfigDefaultRulePhaseActionsRequest.Builder getDefaultRulePhaseActions() {
            return defaultRulePhaseActions != null ? defaultRulePhaseActions.toBuilder() : null;
        }

        public final void setDefaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.BuilderImpl defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions != null ? defaultRulePhaseActions.build() : null;
        }

        @Override
        public final Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
