/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Proxy rule group contained within a proxy configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProxyConfigRuleGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ProxyConfigRuleGroup.Builder, ProxyConfigRuleGroup> {
    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupName").getter(getter(ProxyConfigRuleGroup::proxyRuleGroupName))
            .setter(setter(Builder::proxyRuleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build())
            .build();

    private static final SdkField<String> PROXY_RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupArn").getter(getter(ProxyConfigRuleGroup::proxyRuleGroupArn))
            .setter(setter(Builder::proxyRuleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ProxyConfigRuleGroup::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(ProxyConfigRuleGroup::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_NAME_FIELD,
            PROXY_RULE_GROUP_ARN_FIELD, TYPE_FIELD, PRIORITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String proxyRuleGroupName;

    private final String proxyRuleGroupArn;

    private final String type;

    private final Integer priority;

    private ProxyConfigRuleGroup(BuilderImpl builder) {
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.proxyRuleGroupArn = builder.proxyRuleGroupArn;
        this.type = builder.type;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you create
     * it.
     * </p>
     * 
     * @return The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
     *         create it.
     */
    public final String proxyRuleGroupName() {
        return proxyRuleGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy rule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy rule group.
     */
    public final String proxyRuleGroupArn() {
        return proxyRuleGroupArn;
    }

    /**
     * <p>
     * Proxy rule group type.
     * </p>
     * 
     * @return Proxy rule group type.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Priority of the proxy rule group in the proxy configuration.
     * </p>
     * 
     * @return Priority of the proxy rule group in the proxy configuration.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfigRuleGroup)) {
            return false;
        }
        ProxyConfigRuleGroup other = (ProxyConfigRuleGroup) obj;
        return Objects.equals(proxyRuleGroupName(), other.proxyRuleGroupName())
                && Objects.equals(proxyRuleGroupArn(), other.proxyRuleGroupArn()) && Objects.equals(type(), other.type())
                && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProxyConfigRuleGroup").add("ProxyRuleGroupName", proxyRuleGroupName())
                .add("ProxyRuleGroupArn", proxyRuleGroupArn()).add("Type", type()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleGroupName":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupName()));
        case "ProxyRuleGroupArn":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("ProxyRuleGroupArn", PROXY_RULE_GROUP_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyConfigRuleGroup, T> g) {
        return obj -> g.apply((ProxyConfigRuleGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProxyConfigRuleGroup> {
        /**
         * <p>
         * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
         * create it.
         * </p>
         * 
         * @param proxyRuleGroupName
         *        The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after
         *        you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupName(String proxyRuleGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy rule group.
         * </p>
         * 
         * @param proxyRuleGroupArn
         *        The Amazon Resource Name (ARN) of a proxy rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupArn(String proxyRuleGroupArn);

        /**
         * <p>
         * Proxy rule group type.
         * </p>
         * 
         * @param type
         *        Proxy rule group type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Priority of the proxy rule group in the proxy configuration.
         * </p>
         * 
         * @param priority
         *        Priority of the proxy rule group in the proxy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private String proxyRuleGroupName;

        private String proxyRuleGroupArn;

        private String type;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfigRuleGroup model) {
            proxyRuleGroupName(model.proxyRuleGroupName);
            proxyRuleGroupArn(model.proxyRuleGroupArn);
            type(model.type);
            priority(model.priority);
        }

        public final String getProxyRuleGroupName() {
            return proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final String getProxyRuleGroupArn() {
            return proxyRuleGroupArn;
        }

        public final void setProxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
        }

        @Override
        public final Builder proxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public ProxyConfigRuleGroup build() {
            return new ProxyConfigRuleGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
