/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains variables that you can use to override default Suricata settings in your firewall policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyVariables implements SdkPojo, Serializable, ToCopyableBuilder<PolicyVariables.Builder, PolicyVariables> {
    private static final SdkField<Map<String, IPSet>> RULE_VARIABLES_FIELD = SdkField
            .<Map<String, IPSet>> builder(MarshallingType.MAP)
            .memberName("RuleVariables")
            .getter(getter(PolicyVariables::ruleVariables))
            .setter(setter(Builder::ruleVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IPSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, IPSet> ruleVariables;

    private PolicyVariables(BuilderImpl builder) {
        this.ruleVariables = builder.ruleVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleVariables() {
        return ruleVariables != null && !(ruleVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The IPv4 or IPv6 addresses in CIDR notation to use for the Suricata <code>HOME_NET</code> variable. If your
     * firewall uses an inspection VPC, you might want to override the <code>HOME_NET</code> variable with the CIDRs of
     * your home networks. If you don't override <code>HOME_NET</code> with your own CIDRs, Network Firewall by default
     * uses the CIDR of your inspection VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleVariables} method.
     * </p>
     * 
     * @return The IPv4 or IPv6 addresses in CIDR notation to use for the Suricata <code>HOME_NET</code> variable. If
     *         your firewall uses an inspection VPC, you might want to override the <code>HOME_NET</code> variable with
     *         the CIDRs of your home networks. If you don't override <code>HOME_NET</code> with your own CIDRs, Network
     *         Firewall by default uses the CIDR of your inspection VPC.
     */
    public final Map<String, IPSet> ruleVariables() {
        return ruleVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleVariables() ? ruleVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVariables)) {
            return false;
        }
        PolicyVariables other = (PolicyVariables) obj;
        return hasRuleVariables() == other.hasRuleVariables() && Objects.equals(ruleVariables(), other.ruleVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyVariables").add("RuleVariables", hasRuleVariables() ? ruleVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleVariables":
            return Optional.ofNullable(clazz.cast(ruleVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleVariables", RULE_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyVariables, T> g) {
        return obj -> g.apply((PolicyVariables) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyVariables> {
        /**
         * <p>
         * The IPv4 or IPv6 addresses in CIDR notation to use for the Suricata <code>HOME_NET</code> variable. If your
         * firewall uses an inspection VPC, you might want to override the <code>HOME_NET</code> variable with the CIDRs
         * of your home networks. If you don't override <code>HOME_NET</code> with your own CIDRs, Network Firewall by
         * default uses the CIDR of your inspection VPC.
         * </p>
         * 
         * @param ruleVariables
         *        The IPv4 or IPv6 addresses in CIDR notation to use for the Suricata <code>HOME_NET</code> variable. If
         *        your firewall uses an inspection VPC, you might want to override the <code>HOME_NET</code> variable
         *        with the CIDRs of your home networks. If you don't override <code>HOME_NET</code> with your own CIDRs,
         *        Network Firewall by default uses the CIDR of your inspection VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleVariables(Map<String, IPSet> ruleVariables);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, IPSet> ruleVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVariables model) {
            ruleVariables(model.ruleVariables);
        }

        public final Map<String, IPSet.Builder> getRuleVariables() {
            Map<String, IPSet.Builder> result = IPSetsCopier.copyToBuilder(this.ruleVariables);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRuleVariables(Map<String, IPSet.BuilderImpl> ruleVariables) {
            this.ruleVariables = IPSetsCopier.copyFromBuilder(ruleVariables);
        }

        @Override
        public final Builder ruleVariables(Map<String, IPSet> ruleVariables) {
            this.ruleVariables = IPSetsCopier.copy(ruleVariables);
            return this;
        }

        @Override
        public PolicyVariables build() {
            return new PolicyVariables(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
