/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnalysisReportsResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<ListAnalysisReportsResponse.Builder, ListAnalysisReportsResponse> {
    private static final SdkField<List<AnalysisReport>> ANALYSIS_REPORTS_FIELD = SdkField
            .<List<AnalysisReport>> builder(MarshallingType.LIST)
            .memberName("AnalysisReports")
            .getter(getter(ListAnalysisReportsResponse::analysisReports))
            .setter(setter(Builder::analysisReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisReport> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisReport::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnalysisReportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_REPORTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AnalysisReport> analysisReports;

    private final String nextToken;

    private ListAnalysisReportsResponse(BuilderImpl builder) {
        super(builder);
        this.analysisReports = builder.analysisReports;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisReports property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisReports() {
        return analysisReports != null && !(analysisReports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>id</code> and <code>ReportTime</code> associated with a requested analysis report. Does not provide the
     * status of the analysis report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisReports} method.
     * </p>
     * 
     * @return The <code>id</code> and <code>ReportTime</code> associated with a requested analysis report. Does not
     *         provide the status of the analysis report.
     */
    public final List<AnalysisReport> analysisReports() {
        return analysisReports;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
     * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from
     * the prior request in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that
     *         are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
     *         returned from the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisReports() ? analysisReports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalysisReportsResponse)) {
            return false;
        }
        ListAnalysisReportsResponse other = (ListAnalysisReportsResponse) obj;
        return hasAnalysisReports() == other.hasAnalysisReports() && Objects.equals(analysisReports(), other.analysisReports())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnalysisReportsResponse")
                .add("AnalysisReports", hasAnalysisReports() ? analysisReports() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisReports":
            return Optional.ofNullable(clazz.cast(analysisReports()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnalysisReports", ANALYSIS_REPORTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnalysisReportsResponse, T> g) {
        return obj -> g.apply((ListAnalysisReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnalysisReportsResponse> {
        /**
         * <p>
         * The <code>id</code> and <code>ReportTime</code> associated with a requested analysis report. Does not provide
         * the status of the analysis report.
         * </p>
         * 
         * @param analysisReports
         *        The <code>id</code> and <code>ReportTime</code> associated with a requested analysis report. Does not
         *        provide the status of the analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisReports(Collection<AnalysisReport> analysisReports);

        /**
         * <p>
         * The <code>id</code> and <code>ReportTime</code> associated with a requested analysis report. Does not provide
         * the status of the analysis report.
         * </p>
         * 
         * @param analysisReports
         *        The <code>id</code> and <code>ReportTime</code> associated with a requested analysis report. Does not
         *        provide the status of the analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisReports(AnalysisReport... analysisReports);

        /**
         * <p>
         * The <code>id</code> and <code>ReportTime</code> associated with a requested analysis report. Does not provide
         * the status of the analysis report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.AnalysisReport.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.AnalysisReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.AnalysisReport.Builder#build()} is called
         * immediately and its result is passed to {@link #analysisReports(List<AnalysisReport>)}.
         * 
         * @param analysisReports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.AnalysisReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisReports(java.util.Collection<AnalysisReport>)
         */
        Builder analysisReports(Consumer<AnalysisReport.Builder>... analysisReports);

        /**
         * <p>
         * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
         * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned
         * from the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects
         *        that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        returned from the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private List<AnalysisReport> analysisReports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalysisReportsResponse model) {
            super(model);
            analysisReports(model.analysisReports);
            nextToken(model.nextToken);
        }

        public final List<AnalysisReport.Builder> getAnalysisReports() {
            List<AnalysisReport.Builder> result = AnalysisReportsCopier.copyToBuilder(this.analysisReports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisReports(Collection<AnalysisReport.BuilderImpl> analysisReports) {
            this.analysisReports = AnalysisReportsCopier.copyFromBuilder(analysisReports);
        }

        @Override
        public final Builder analysisReports(Collection<AnalysisReport> analysisReports) {
            this.analysisReports = AnalysisReportsCopier.copy(analysisReports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisReports(AnalysisReport... analysisReports) {
            analysisReports(Arrays.asList(analysisReports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisReports(Consumer<AnalysisReport.Builder>... analysisReports) {
            analysisReports(Stream.of(analysisReports).map(c -> AnalysisReport.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnalysisReportsResponse build() {
            return new ListAnalysisReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
