/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAnalysisReportResultsResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<GetAnalysisReportResultsResponse.Builder, GetAnalysisReportResultsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetAnalysisReportResultsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetAnalysisReportResultsResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetAnalysisReportResultsResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> REPORT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReportTime").getter(getter(GetAnalysisReportResultsResponse::reportTime))
            .setter(setter(Builder::reportTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportTime").build()).build();

    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisType").getter(getter(GetAnalysisReportResultsResponse::analysisTypeAsString))
            .setter(setter(Builder::analysisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetAnalysisReportResultsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<AnalysisTypeReportResult>> ANALYSIS_REPORT_RESULTS_FIELD = SdkField
            .<List<AnalysisTypeReportResult>> builder(MarshallingType.LIST)
            .memberName("AnalysisReportResults")
            .getter(getter(GetAnalysisReportResultsResponse::analysisReportResults))
            .setter(setter(Builder::analysisReportResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReportResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisTypeReportResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisTypeReportResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, REPORT_TIME_FIELD, ANALYSIS_TYPE_FIELD, NEXT_TOKEN_FIELD,
            ANALYSIS_REPORT_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final Instant reportTime;

    private final String analysisType;

    private final String nextToken;

    private final List<AnalysisTypeReportResult> analysisReportResults;

    private GetAnalysisReportResultsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.reportTime = builder.reportTime;
        this.analysisType = builder.analysisType;
        this.nextToken = builder.nextToken;
        this.analysisReportResults = builder.analysisReportResults;
    }

    /**
     * <p>
     * The status of the analysis report you specify. Statuses include <code>RUNNING</code>, <code>COMPLETED</code>, or
     * <code>FAILED</code>.
     * </p>
     * 
     * @return The status of the analysis report you specify. Statuses include <code>RUNNING</code>,
     *         <code>COMPLETED</code>, or <code>FAILED</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time within the last 30 days from which to start retrieving analysis data, in UTC format (for
     * example, <code>YYYY-MM-DDTHH:MM:SSZ</code>.
     * </p>
     * 
     * @return The date and time within the last 30 days from which to start retrieving analysis data, in UTC format
     *         (for example, <code>YYYY-MM-DDTHH:MM:SSZ</code>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time, up to the current date, from which to stop retrieving analysis data, in UTC format (for
     * example, <code>YYYY-MM-DDTHH:MM:SSZ</code>).
     * </p>
     * 
     * @return The date and time, up to the current date, from which to stop retrieving analysis data, in UTC format
     *         (for example, <code>YYYY-MM-DDTHH:MM:SSZ</code>).
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The date and time the analysis report was ran.
     * </p>
     * 
     * @return The date and time the analysis report was ran.
     */
    public final Instant reportTime() {
        return reportTime;
    }

    /**
     * <p>
     * The type of traffic that will be used to generate a report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link EnabledAnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of traffic that will be used to generate a report.
     * @see EnabledAnalysisType
     */
    public final EnabledAnalysisType analysisType() {
        return EnabledAnalysisType.fromValue(analysisType);
    }

    /**
     * <p>
     * The type of traffic that will be used to generate a report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link EnabledAnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of traffic that will be used to generate a report.
     * @see EnabledAnalysisType
     */
    public final String analysisTypeAsString() {
        return analysisType;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
     * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from
     * the prior request in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that
     *         are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
     *         returned from the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisReportResults property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAnalysisReportResults() {
        return analysisReportResults != null && !(analysisReportResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retrieves the results of a traffic analysis report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisReportResults} method.
     * </p>
     * 
     * @return Retrieves the results of a traffic analysis report.
     */
    public final List<AnalysisTypeReportResult> analysisReportResults() {
        return analysisReportResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(reportTime());
        hashCode = 31 * hashCode + Objects.hashCode(analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisReportResults() ? analysisReportResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnalysisReportResultsResponse)) {
            return false;
        }
        GetAnalysisReportResultsResponse other = (GetAnalysisReportResultsResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(reportTime(), other.reportTime())
                && Objects.equals(analysisTypeAsString(), other.analysisTypeAsString())
                && Objects.equals(nextToken(), other.nextToken())
                && hasAnalysisReportResults() == other.hasAnalysisReportResults()
                && Objects.equals(analysisReportResults(), other.analysisReportResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAnalysisReportResultsResponse").add("Status", status()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("ReportTime", reportTime()).add("AnalysisType", analysisTypeAsString())
                .add("NextToken", nextToken())
                .add("AnalysisReportResults", hasAnalysisReportResults() ? analysisReportResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ReportTime":
            return Optional.ofNullable(clazz.cast(reportTime()));
        case "AnalysisType":
            return Optional.ofNullable(clazz.cast(analysisTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AnalysisReportResults":
            return Optional.ofNullable(clazz.cast(analysisReportResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ReportTime", REPORT_TIME_FIELD);
        map.put("AnalysisType", ANALYSIS_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AnalysisReportResults", ANALYSIS_REPORT_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAnalysisReportResultsResponse, T> g) {
        return obj -> g.apply((GetAnalysisReportResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAnalysisReportResultsResponse> {
        /**
         * <p>
         * The status of the analysis report you specify. Statuses include <code>RUNNING</code>, <code>COMPLETED</code>,
         * or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The status of the analysis report you specify. Statuses include <code>RUNNING</code>,
         *        <code>COMPLETED</code>, or <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time within the last 30 days from which to start retrieving analysis data, in UTC format (for
         * example, <code>YYYY-MM-DDTHH:MM:SSZ</code>.
         * </p>
         * 
         * @param startTime
         *        The date and time within the last 30 days from which to start retrieving analysis data, in UTC format
         *        (for example, <code>YYYY-MM-DDTHH:MM:SSZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time, up to the current date, from which to stop retrieving analysis data, in UTC format (for
         * example, <code>YYYY-MM-DDTHH:MM:SSZ</code>).
         * </p>
         * 
         * @param endTime
         *        The date and time, up to the current date, from which to stop retrieving analysis data, in UTC format
         *        (for example, <code>YYYY-MM-DDTHH:MM:SSZ</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The date and time the analysis report was ran.
         * </p>
         * 
         * @param reportTime
         *        The date and time the analysis report was ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportTime(Instant reportTime);

        /**
         * <p>
         * The type of traffic that will be used to generate a report.
         * </p>
         * 
         * @param analysisType
         *        The type of traffic that will be used to generate a report.
         * @see EnabledAnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledAnalysisType
         */
        Builder analysisType(String analysisType);

        /**
         * <p>
         * The type of traffic that will be used to generate a report.
         * </p>
         * 
         * @param analysisType
         *        The type of traffic that will be used to generate a report.
         * @see EnabledAnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledAnalysisType
         */
        Builder analysisType(EnabledAnalysisType analysisType);

        /**
         * <p>
         * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
         * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned
         * from the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects
         *        that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        returned from the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Retrieves the results of a traffic analysis report.
         * </p>
         * 
         * @param analysisReportResults
         *        Retrieves the results of a traffic analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisReportResults(Collection<AnalysisTypeReportResult> analysisReportResults);

        /**
         * <p>
         * Retrieves the results of a traffic analysis report.
         * </p>
         * 
         * @param analysisReportResults
         *        Retrieves the results of a traffic analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisReportResults(AnalysisTypeReportResult... analysisReportResults);

        /**
         * <p>
         * Retrieves the results of a traffic analysis report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.AnalysisTypeReportResult.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.AnalysisTypeReportResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.AnalysisTypeReportResult.Builder#build()} is
         * called immediately and its result is passed to {@link #analysisReportResults(List<AnalysisTypeReportResult>)}.
         * 
         * @param analysisReportResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.AnalysisTypeReportResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisReportResults(java.util.Collection<AnalysisTypeReportResult>)
         */
        Builder analysisReportResults(Consumer<AnalysisTypeReportResult.Builder>... analysisReportResults);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String status;

        private Instant startTime;

        private Instant endTime;

        private Instant reportTime;

        private String analysisType;

        private String nextToken;

        private List<AnalysisTypeReportResult> analysisReportResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnalysisReportResultsResponse model) {
            super(model);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            reportTime(model.reportTime);
            analysisType(model.analysisType);
            nextToken(model.nextToken);
            analysisReportResults(model.analysisReportResults);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getReportTime() {
            return reportTime;
        }

        public final void setReportTime(Instant reportTime) {
            this.reportTime = reportTime;
        }

        @Override
        public final Builder reportTime(Instant reportTime) {
            this.reportTime = reportTime;
            return this;
        }

        public final String getAnalysisType() {
            return analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(EnabledAnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AnalysisTypeReportResult.Builder> getAnalysisReportResults() {
            List<AnalysisTypeReportResult.Builder> result = AnalysisReportResultsCopier.copyToBuilder(this.analysisReportResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisReportResults(Collection<AnalysisTypeReportResult.BuilderImpl> analysisReportResults) {
            this.analysisReportResults = AnalysisReportResultsCopier.copyFromBuilder(analysisReportResults);
        }

        @Override
        public final Builder analysisReportResults(Collection<AnalysisTypeReportResult> analysisReportResults) {
            this.analysisReportResults = AnalysisReportResultsCopier.copy(analysisReportResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisReportResults(AnalysisTypeReportResult... analysisReportResults) {
            analysisReportResults(Arrays.asList(analysisReportResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisReportResults(Consumer<AnalysisTypeReportResult.Builder>... analysisReportResults) {
            analysisReportResults(Stream.of(analysisReportResults)
                    .map(c -> AnalysisTypeReportResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAnalysisReportResultsResponse build() {
            return new GetAnalysisReportResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
