/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of objects with metadata about the requested <code>FlowOperation</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowOperationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowOperationMetadata.Builder, FlowOperationMetadata> {
    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOperationId").getter(getter(FlowOperationMetadata::flowOperationId))
            .setter(setter(Builder::flowOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()).build();

    private static final SdkField<String> FLOW_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOperationType").getter(getter(FlowOperationMetadata::flowOperationTypeAsString))
            .setter(setter(Builder::flowOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationType").build()).build();

    private static final SdkField<Instant> FLOW_REQUEST_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FlowRequestTimestamp").getter(getter(FlowOperationMetadata::flowRequestTimestamp))
            .setter(setter(Builder::flowRequestTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowRequestTimestamp").build())
            .build();

    private static final SdkField<String> FLOW_OPERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOperationStatus").getter(getter(FlowOperationMetadata::flowOperationStatusAsString))
            .setter(setter(Builder::flowOperationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_OPERATION_ID_FIELD,
            FLOW_OPERATION_TYPE_FIELD, FLOW_REQUEST_TIMESTAMP_FIELD, FLOW_OPERATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowOperationId;

    private final String flowOperationType;

    private final Instant flowRequestTimestamp;

    private final String flowOperationStatus;

    private FlowOperationMetadata(BuilderImpl builder) {
        this.flowOperationId = builder.flowOperationId;
        this.flowOperationType = builder.flowOperationType;
        this.flowRequestTimestamp = builder.flowRequestTimestamp;
        this.flowOperationStatus = builder.flowOperationStatus;
    }

    /**
     * <p>
     * A unique identifier for the flow operation. This ID is returned in the responses to start and list commands. You
     * provide to describe commands.
     * </p>
     * 
     * @return A unique identifier for the flow operation. This ID is returned in the responses to start and list
     *         commands. You provide to describe commands.
     */
    public final String flowOperationId() {
        return flowOperationId;
    }

    /**
     * <p>
     * Defines the type of <code>FlowOperation</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowOperationType}
     * will return {@link FlowOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #flowOperationTypeAsString}.
     * </p>
     * 
     * @return Defines the type of <code>FlowOperation</code>.
     * @see FlowOperationType
     */
    public final FlowOperationType flowOperationType() {
        return FlowOperationType.fromValue(flowOperationType);
    }

    /**
     * <p>
     * Defines the type of <code>FlowOperation</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowOperationType}
     * will return {@link FlowOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #flowOperationTypeAsString}.
     * </p>
     * 
     * @return Defines the type of <code>FlowOperation</code>.
     * @see FlowOperationType
     */
    public final String flowOperationTypeAsString() {
        return flowOperationType;
    }

    /**
     * <p>
     * A timestamp indicating when the Suricata engine identified flows impacted by an operation.
     * </p>
     * 
     * @return A timestamp indicating when the Suricata engine identified flows impacted by an operation.
     */
    public final Instant flowRequestTimestamp() {
        return flowRequestTimestamp;
    }

    /**
     * <p>
     * Returns the status of the flow operation. This string is returned in the responses to start, list, and describe
     * commands.
     * </p>
     * <p>
     * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code> returned
     * will be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowOperationStatus} will return {@link FlowOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowOperationStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the flow operation. This string is returned in the responses to start, list, and
     *         describe commands.</p>
     *         <p>
     *         If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     *         <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
     *         returned will be empty.
     * @see FlowOperationStatus
     */
    public final FlowOperationStatus flowOperationStatus() {
        return FlowOperationStatus.fromValue(flowOperationStatus);
    }

    /**
     * <p>
     * Returns the status of the flow operation. This string is returned in the responses to start, list, and describe
     * commands.
     * </p>
     * <p>
     * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code> returned
     * will be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowOperationStatus} will return {@link FlowOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowOperationStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the flow operation. This string is returned in the responses to start, list, and
     *         describe commands.</p>
     *         <p>
     *         If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     *         <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
     *         returned will be empty.
     * @see FlowOperationStatus
     */
    public final String flowOperationStatusAsString() {
        return flowOperationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(flowOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flowRequestTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(flowOperationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowOperationMetadata)) {
            return false;
        }
        FlowOperationMetadata other = (FlowOperationMetadata) obj;
        return Objects.equals(flowOperationId(), other.flowOperationId())
                && Objects.equals(flowOperationTypeAsString(), other.flowOperationTypeAsString())
                && Objects.equals(flowRequestTimestamp(), other.flowRequestTimestamp())
                && Objects.equals(flowOperationStatusAsString(), other.flowOperationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowOperationMetadata").add("FlowOperationId", flowOperationId())
                .add("FlowOperationType", flowOperationTypeAsString()).add("FlowRequestTimestamp", flowRequestTimestamp())
                .add("FlowOperationStatus", flowOperationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowOperationId":
            return Optional.ofNullable(clazz.cast(flowOperationId()));
        case "FlowOperationType":
            return Optional.ofNullable(clazz.cast(flowOperationTypeAsString()));
        case "FlowRequestTimestamp":
            return Optional.ofNullable(clazz.cast(flowRequestTimestamp()));
        case "FlowOperationStatus":
            return Optional.ofNullable(clazz.cast(flowOperationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        map.put("FlowOperationType", FLOW_OPERATION_TYPE_FIELD);
        map.put("FlowRequestTimestamp", FLOW_REQUEST_TIMESTAMP_FIELD);
        map.put("FlowOperationStatus", FLOW_OPERATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowOperationMetadata, T> g) {
        return obj -> g.apply((FlowOperationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowOperationMetadata> {
        /**
         * <p>
         * A unique identifier for the flow operation. This ID is returned in the responses to start and list commands.
         * You provide to describe commands.
         * </p>
         * 
         * @param flowOperationId
         *        A unique identifier for the flow operation. This ID is returned in the responses to start and list
         *        commands. You provide to describe commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOperationId(String flowOperationId);

        /**
         * <p>
         * Defines the type of <code>FlowOperation</code>.
         * </p>
         * 
         * @param flowOperationType
         *        Defines the type of <code>FlowOperation</code>.
         * @see FlowOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowOperationType
         */
        Builder flowOperationType(String flowOperationType);

        /**
         * <p>
         * Defines the type of <code>FlowOperation</code>.
         * </p>
         * 
         * @param flowOperationType
         *        Defines the type of <code>FlowOperation</code>.
         * @see FlowOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowOperationType
         */
        Builder flowOperationType(FlowOperationType flowOperationType);

        /**
         * <p>
         * A timestamp indicating when the Suricata engine identified flows impacted by an operation.
         * </p>
         * 
         * @param flowRequestTimestamp
         *        A timestamp indicating when the Suricata engine identified flows impacted by an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowRequestTimestamp(Instant flowRequestTimestamp);

        /**
         * <p>
         * Returns the status of the flow operation. This string is returned in the responses to start, list, and
         * describe commands.
         * </p>
         * <p>
         * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         * returned will be empty.
         * </p>
         * 
         * @param flowOperationStatus
         *        Returns the status of the flow operation. This string is returned in the responses to start, list, and
         *        describe commands.</p>
         *        <p>
         *        If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         *        <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         *        returned will be empty.
         * @see FlowOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowOperationStatus
         */
        Builder flowOperationStatus(String flowOperationStatus);

        /**
         * <p>
         * Returns the status of the flow operation. This string is returned in the responses to start, list, and
         * describe commands.
         * </p>
         * <p>
         * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         * returned will be empty.
         * </p>
         * 
         * @param flowOperationStatus
         *        Returns the status of the flow operation. This string is returned in the responses to start, list, and
         *        describe commands.</p>
         *        <p>
         *        If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         *        <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         *        returned will be empty.
         * @see FlowOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowOperationStatus
         */
        Builder flowOperationStatus(FlowOperationStatus flowOperationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String flowOperationId;

        private String flowOperationType;

        private Instant flowRequestTimestamp;

        private String flowOperationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowOperationMetadata model) {
            flowOperationId(model.flowOperationId);
            flowOperationType(model.flowOperationType);
            flowRequestTimestamp(model.flowRequestTimestamp);
            flowOperationStatus(model.flowOperationStatus);
        }

        public final String getFlowOperationId() {
            return flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        public final String getFlowOperationType() {
            return flowOperationType;
        }

        public final void setFlowOperationType(String flowOperationType) {
            this.flowOperationType = flowOperationType;
        }

        @Override
        public final Builder flowOperationType(String flowOperationType) {
            this.flowOperationType = flowOperationType;
            return this;
        }

        @Override
        public final Builder flowOperationType(FlowOperationType flowOperationType) {
            this.flowOperationType(flowOperationType == null ? null : flowOperationType.toString());
            return this;
        }

        public final Instant getFlowRequestTimestamp() {
            return flowRequestTimestamp;
        }

        public final void setFlowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
        }

        @Override
        public final Builder flowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
            return this;
        }

        public final String getFlowOperationStatus() {
            return flowOperationStatus;
        }

        public final void setFlowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
        }

        @Override
        public final Builder flowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
            return this;
        }

        @Override
        public final Builder flowOperationStatus(FlowOperationStatus flowOperationStatus) {
            this.flowOperationStatus(flowOperationStatus == null ? null : flowOperationStatus.toString());
            return this;
        }

        @Override
        public FlowOperationMetadata build() {
            return new FlowOperationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
