/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowFilter implements SdkPojo, Serializable, ToCopyableBuilder<FlowFilter.Builder, FlowFilter> {
    private static final SdkField<Address> SOURCE_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("SourceAddress").getter(getter(FlowFilter::sourceAddress)).setter(setter(Builder::sourceAddress))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddress").build()).build();

    private static final SdkField<Address> DESTINATION_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationAddress").getter(getter(FlowFilter::destinationAddress))
            .setter(setter(Builder::destinationAddress)).constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress").build())
            .build();

    private static final SdkField<String> SOURCE_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePort").getter(getter(FlowFilter::sourcePort)).setter(setter(Builder::sourcePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()).build();

    private static final SdkField<String> DESTINATION_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPort").getter(getter(FlowFilter::destinationPort)).setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()).build();

    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Protocols")
            .getter(getter(FlowFilter::protocols))
            .setter(setter(Builder::protocols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESS_FIELD,
            DESTINATION_ADDRESS_FIELD, SOURCE_PORT_FIELD, DESTINATION_PORT_FIELD, PROTOCOLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Address sourceAddress;

    private final Address destinationAddress;

    private final String sourcePort;

    private final String destinationPort;

    private final List<String> protocols;

    private FlowFilter(BuilderImpl builder) {
        this.sourceAddress = builder.sourceAddress;
        this.destinationAddress = builder.destinationAddress;
        this.sourcePort = builder.sourcePort;
        this.destinationPort = builder.destinationPort;
        this.protocols = builder.protocols;
    }

    /**
     * Returns the value of the SourceAddress property for this object.
     * 
     * @return The value of the SourceAddress property for this object.
     */
    public final Address sourceAddress() {
        return sourceAddress;
    }

    /**
     * Returns the value of the DestinationAddress property for this object.
     * 
     * @return The value of the DestinationAddress property for this object.
     */
    public final Address destinationAddress() {
        return destinationAddress;
    }

    /**
     * <p>
     * The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you can
     * specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
     * </p>
     * 
     * @return The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you
     *         can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
     *         <code>ANY</code>.
     */
    public final String sourcePort() {
        return sourcePort;
    }

    /**
     * <p>
     * The destination port to inspect for. You can specify an individual port, for example <code>1994</code> and you
     * can specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
     * </p>
     * 
     * @return The destination port to inspect for. You can specify an individual port, for example <code>1994</code>
     *         and you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
     *         <code>ANY</code>.
     */
    public final String destinationPort() {
        return destinationPort;
    }

    /**
     * For responses, this returns true if the service returned a value for the Protocols property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProtocols() {
        return protocols != null && !(protocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol. If
     * not specified, this matches with any protocol.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocols} method.
     * </p>
     * 
     * @return The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each
     *         protocol. If not specified, this matches with any protocol.
     */
    public final List<String> protocols() {
        return protocols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAddress());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocols() ? protocols() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowFilter)) {
            return false;
        }
        FlowFilter other = (FlowFilter) obj;
        return Objects.equals(sourceAddress(), other.sourceAddress())
                && Objects.equals(destinationAddress(), other.destinationAddress())
                && Objects.equals(sourcePort(), other.sourcePort()) && Objects.equals(destinationPort(), other.destinationPort())
                && hasProtocols() == other.hasProtocols() && Objects.equals(protocols(), other.protocols());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowFilter").add("SourceAddress", sourceAddress())
                .add("DestinationAddress", destinationAddress()).add("SourcePort", sourcePort())
                .add("DestinationPort", destinationPort()).add("Protocols", hasProtocols() ? protocols() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceAddress":
            return Optional.ofNullable(clazz.cast(sourceAddress()));
        case "DestinationAddress":
            return Optional.ofNullable(clazz.cast(destinationAddress()));
        case "SourcePort":
            return Optional.ofNullable(clazz.cast(sourcePort()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "Protocols":
            return Optional.ofNullable(clazz.cast(protocols()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceAddress", SOURCE_ADDRESS_FIELD);
        map.put("DestinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("SourcePort", SOURCE_PORT_FIELD);
        map.put("DestinationPort", DESTINATION_PORT_FIELD);
        map.put("Protocols", PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowFilter, T> g) {
        return obj -> g.apply((FlowFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowFilter> {
        /**
         * Sets the value of the SourceAddress property for this object.
         *
         * @param sourceAddress
         *        The new value for the SourceAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAddress(Address sourceAddress);

        /**
         * Sets the value of the SourceAddress property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceAddress(Address)}.
         * 
         * @param sourceAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAddress(Address)
         */
        default Builder sourceAddress(Consumer<Address.Builder> sourceAddress) {
            return sourceAddress(Address.builder().applyMutation(sourceAddress).build());
        }

        /**
         * Sets the value of the DestinationAddress property for this object.
         *
         * @param destinationAddress
         *        The new value for the DestinationAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddress(Address destinationAddress);

        /**
         * Sets the value of the DestinationAddress property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #destinationAddress(Address)}.
         * 
         * @param destinationAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationAddress(Address)
         */
        default Builder destinationAddress(Consumer<Address.Builder> destinationAddress) {
            return destinationAddress(Address.builder().applyMutation(destinationAddress).build());
        }

        /**
         * <p>
         * The source port to inspect for. You can specify an individual port, for example <code>1994</code> and you can
         * specify a port range, for example <code>1990:1994</code>. To match with any port, specify <code>ANY</code>.
         * </p>
         * 
         * @param sourcePort
         *        The source port to inspect for. You can specify an individual port, for example <code>1994</code> and
         *        you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePort(String sourcePort);

        /**
         * <p>
         * The destination port to inspect for. You can specify an individual port, for example <code>1994</code> and
         * you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         * <code>ANY</code>.
         * </p>
         * 
         * @param destinationPort
         *        The destination port to inspect for. You can specify an individual port, for example <code>1994</code>
         *        and you can specify a port range, for example <code>1990:1994</code>. To match with any port, specify
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(String destinationPort);

        /**
         * <p>
         * The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
         * If not specified, this matches with any protocol.
         * </p>
         * 
         * @param protocols
         *        The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each
         *        protocol. If not specified, this matches with any protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Collection<String> protocols);

        /**
         * <p>
         * The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol.
         * If not specified, this matches with any protocol.
         * </p>
         * 
         * @param protocols
         *        The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each
         *        protocol. If not specified, this matches with any protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(String... protocols);
    }

    static final class BuilderImpl implements Builder {
        private Address sourceAddress;

        private Address destinationAddress;

        private String sourcePort;

        private String destinationPort;

        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FlowFilter model) {
            sourceAddress(model.sourceAddress);
            destinationAddress(model.destinationAddress);
            sourcePort(model.sourcePort);
            destinationPort(model.destinationPort);
            protocols(model.protocols);
        }

        public final Address.Builder getSourceAddress() {
            return sourceAddress != null ? sourceAddress.toBuilder() : null;
        }

        public final void setSourceAddress(Address.BuilderImpl sourceAddress) {
            this.sourceAddress = sourceAddress != null ? sourceAddress.build() : null;
        }

        @Override
        public final Builder sourceAddress(Address sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public final Address.Builder getDestinationAddress() {
            return destinationAddress != null ? destinationAddress.toBuilder() : null;
        }

        public final void setDestinationAddress(Address.BuilderImpl destinationAddress) {
            this.destinationAddress = destinationAddress != null ? destinationAddress.build() : null;
        }

        @Override
        public final Builder destinationAddress(Address destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final String getSourcePort() {
            return sourcePort;
        }

        public final void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final String getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final Collection<String> getProtocols() {
            if (protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolStringsCopier.copy(protocols);
        }

        @Override
        public final Builder protocols(Collection<String> protocols) {
            this.protocols = ProtocolStringsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(String... protocols) {
            protocols(Arrays.asList(protocols));
            return this;
        }

        @Override
        public FlowFilter build() {
            return new FlowFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
